/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.LocalVariable;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.FieldUpdater;
import sun.tools.tree.LocalMember;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.Vset;

public class IdentifierExpression
extends Expression {
    Identifier id;
    MemberDefinition field;
    Expression implementation;

    public IdentifierExpression(long where, Identifier id) {
        super(60, where, Type.tError);
        this.id = id;
    }

    public IdentifierExpression(IdentifierToken id) {
        this(id.getWhere(), id.getName());
    }

    public IdentifierExpression(long where, MemberDefinition field) {
        super(60, where, field.getType());
        this.id = field.getName();
        this.field = field;
    }

    @Override
    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    @Override
    public boolean equals(Identifier id) {
        return this.id.equals(id);
    }

    private Vset assign(Environment env, Context ctx, Vset vset) {
        if (this.field.isLocal()) {
            LocalMember local = (LocalMember)this.field;
            if (local.scopeNumber < ctx.frameNumber) {
                env.error(this.where, "assign.to.uplevel", this.id);
            }
            if (local.isFinal()) {
                if (!local.isBlankFinal()) {
                    env.error(this.where, "assign.to.final", this.id);
                } else if (!vset.testVarUnassigned(local.number)) {
                    env.error(this.where, "assign.to.blank.final", this.id);
                }
            }
            vset.addVar(local.number);
            ++local.writecount;
        } else if (this.field.isFinal()) {
            vset = FieldExpression.checkFinalAssign(env, ctx, vset, this.where, this.field);
        }
        return vset;
    }

    private Vset get(Environment env, Context ctx, Vset vset) {
        if (this.field.isLocal()) {
            LocalMember local = (LocalMember)this.field;
            if (local.scopeNumber < ctx.frameNumber && !local.isFinal()) {
                env.error(this.where, "invalid.uplevel", this.id);
            }
            if (!vset.testVar(local.number)) {
                env.error(this.where, "var.not.initialized", this.id);
                vset.addVar(local.number);
            }
            ++local.readcount;
        } else {
            int number;
            if (!this.field.isStatic() && !vset.testVar(ctx.getThisNumber())) {
                env.error(this.where, "access.inst.before.super", this.id);
                this.implementation = null;
            }
            if (this.field.isBlankFinal() && (number = ctx.getFieldNumber(this.field)) >= 0 && !vset.testVar(number)) {
                env.error(this.where, "var.not.initialized", this.id);
            }
        }
        return vset;
    }

    boolean bind(Environment env, Context ctx) {
        try {
            this.field = ctx.getField(env, this.id);
            if (this.field == null) {
                for (ClassDefinition cdef = ctx.field.getClassDefinition(); cdef != null; cdef = cdef.getOuterClass()) {
                    if (cdef.findAnyMethod(env, this.id) == null) continue;
                    env.error(this.where, "invalid.var", this.id, ctx.field.getClassDeclaration());
                    return false;
                }
                env.error(this.where, "undef.var", this.id);
                return false;
            }
            this.type = this.field.getType();
            if (!ctx.field.getClassDefinition().canAccess(env, this.field)) {
                env.error(this.where, "no.field.access", this.id, this.field.getClassDeclaration(), ctx.field.getClassDeclaration());
                return false;
            }
            if (this.field.isLocal()) {
                LocalMember local = (LocalMember)this.field;
                if (local.scopeNumber < ctx.frameNumber) {
                    this.implementation = ctx.makeReference(env, local);
                }
            } else {
                Expression base;
                MemberDefinition f2;
                ClassDefinition fclass;
                MemberDefinition f = this.field;
                if (f.reportDeprecated(env)) {
                    env.error(this.where, "warn.field.is.deprecated", this.id, f.getClassDefinition());
                }
                if ((fclass = f.getClassDefinition()) != ctx.field.getClassDefinition() && (f2 = ctx.getApparentField(env, this.id)) != null && f2 != f) {
                    ClassDefinition c = ctx.findScope(env, fclass);
                    if (c == null) {
                        c = f.getClassDefinition();
                    }
                    if (f2.isLocal()) {
                        env.error(this.where, "inherited.hides.local", this.id, c.getClassDeclaration());
                    } else {
                        env.error(this.where, "inherited.hides.field", this.id, c.getClassDeclaration(), f2.getClassDeclaration());
                    }
                }
                if (f.isStatic()) {
                    base = new TypeExpression(this.where, f.getClassDeclaration().getType());
                    this.implementation = new FieldExpression(this.where, null, f);
                } else {
                    base = ctx.findOuterLink(env, this.where, f);
                    if (base != null) {
                        this.implementation = new FieldExpression(this.where, base, f);
                    }
                }
            }
            if (!ctx.canReach(env, this.field)) {
                env.error(this.where, "forward.ref", this.id, this.field.getClassDeclaration());
                return false;
            }
            return true;
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, ctx.field);
        }
        catch (AmbiguousMember e) {
            env.error(this.where, "ambig.field", this.id, e.field1.getClassDeclaration(), e.field2.getClassDeclaration());
        }
        return false;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        if (this.field != null) {
            return vset;
        }
        if (this.bind(env, ctx)) {
            vset = this.get(env, ctx, vset);
            ctx.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
            if (this.implementation != null) {
                vset = this.implementation.checkValue(env, ctx, vset, exp);
            }
        }
        return vset;
    }

    @Override
    public Vset checkLHS(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        if (!this.bind(env, ctx)) {
            return vset;
        }
        vset = this.assign(env, ctx, vset);
        if (this.implementation != null) {
            vset = this.implementation.checkValue(env, ctx, vset, exp);
        }
        return vset;
    }

    @Override
    public Vset checkAssignOp(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, Expression outside) {
        if (!this.bind(env, ctx)) {
            return vset;
        }
        vset = this.assign(env, ctx, this.get(env, ctx, vset));
        if (this.implementation != null) {
            vset = this.implementation.checkValue(env, ctx, vset, exp);
        }
        return vset;
    }

    @Override
    public FieldUpdater getAssigner(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.getAssigner(env, ctx);
        }
        return null;
    }

    @Override
    public FieldUpdater getUpdater(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.getUpdater(env, ctx);
        }
        return null;
    }

    @Override
    public Vset checkAmbigName(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, UnaryExpression loc) {
        try {
            if (ctx.getField(env, this.id) != null) {
                return this.checkValue(env, ctx, vset, exp);
            }
        }
        catch (ClassNotFound ee) {
        }
        catch (AmbiguousMember ee) {
            // empty catch block
        }
        ClassDefinition c = this.toResolvedType(env, ctx, true);
        if (c != null) {
            loc.right = new TypeExpression(this.where, c.getType());
            return vset;
        }
        this.type = Type.tPackage;
        return vset;
    }

    private ClassDefinition toResolvedType(Environment env, Context ctx, boolean pkgOK) {
        Identifier rid = ctx.resolveName(env, this.id);
        Type t = Type.tClass(rid);
        if (pkgOK && !env.classExists(t)) {
            return null;
        }
        if (env.resolve(this.where, ctx.field.getClassDefinition(), t)) {
            try {
                Identifier rid2;
                ClassDefinition sc;
                ClassDefinition c = env.getClassDefinition(t);
                if (c.isMember() && (sc = ctx.findScope(env, c.getOuterClass())) != c.getOuterClass() && !(rid2 = ctx.getApparentClassName(env, this.id)).equals(idNull) && !rid2.equals(rid)) {
                    env.error(this.where, "inherited.hides.type", this.id, sc.getClassDeclaration());
                }
                if (!c.getLocalName().equals(this.id.getFlatName().getName())) {
                    env.error(this.where, "illegal.mangled.name", this.id, c);
                }
                return c;
            }
            catch (ClassNotFound ee) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    Type toType(Environment env, Context ctx) {
        ClassDefinition c = this.toResolvedType(env, ctx, false);
        if (c != null) {
            return c.getType();
        }
        return Type.tError;
    }

    @Override
    public boolean isConstant() {
        if (this.implementation != null) {
            return this.implementation.isConstant();
        }
        if (this.field != null) {
            return this.field.isConstant();
        }
        return false;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        return null;
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(env, ctx);
        }
        if (this.field == null) {
            return this;
        }
        try {
            if (this.field.isLocal()) {
                if (this.field.isInlineable(env, false)) {
                    Expression e = (Expression)this.field.getValue(env);
                    return e == null ? this : e.inlineValue(env, ctx);
                }
                return this;
            }
            return this;
        }
        catch (ClassNotFound e) {
            throw new CompilerError(e);
        }
    }

    @Override
    public Expression inlineLHS(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inlineLHS(env, ctx);
        }
        return this;
    }

    @Override
    public Expression copyInline(Context ctx) {
        if (this.implementation != null) {
            return this.implementation.copyInline(ctx);
        }
        IdentifierExpression e = (IdentifierExpression)super.copyInline(ctx);
        if (this.field != null && this.field.isLocal()) {
            e.field = ((LocalMember)this.field).getCurrentInlineCopy(ctx);
        }
        return e;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.costInline(thresh, env, ctx);
        }
        return super.costInline(thresh, env, ctx);
    }

    @Override
    int codeLValue(Environment env, Context ctx, Assembler asm) {
        return 0;
    }

    @Override
    void codeLoad(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 21 + this.type.getTypeCodeOffset(), ((LocalMember)this.field).number);
    }

    @Override
    void codeStore(Environment env, Context ctx, Assembler asm) {
        LocalMember local = (LocalMember)this.field;
        asm.add(this.where, 54 + this.type.getTypeCodeOffset(), new LocalVariable(local, local.number));
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.codeLValue(env, ctx, asm);
        this.codeLoad(env, ctx, asm);
    }

    @Override
    public void print(PrintStream out) {
        out.print(this.id + "#" + (this.field != null ? this.field.hashCode() : 0));
        if (this.implementation != null) {
            out.print("/IMPL=");
            this.implementation.print(out);
        }
    }
}

