/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import sun.tools.asm.SwitchData;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CaseStatement;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.IntegerExpression;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class SwitchStatement
extends Statement {
    Expression expr;
    Statement[] args;

    public SwitchStatement(long where, Expression expr, Statement[] args) {
        super(95, where);
        this.expr = expr;
        this.args = args;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        CheckContext newctx = new CheckContext(ctx, this);
        vset = this.expr.checkValue(env, newctx, this.reach(env, vset), exp);
        Type switchType = this.expr.type;
        this.expr = this.convert(env, newctx, Type.tInt, this.expr);
        Hashtable<Expression, Statement> tab = new Hashtable<Expression, Statement>();
        boolean hasDefault = false;
        Vset vs = DEAD_END;
        for (int i = 0; i < this.args.length; ++i) {
            Statement s = this.args[i];
            if (s.op == 96) {
                vs = s.check(env, newctx, vs.join(vset.copy()), exp);
                Expression lbl = ((CaseStatement)s).expr;
                if (lbl != null) {
                    if (lbl instanceof IntegerExpression) {
                        boolean overflow;
                        Integer Ivalue = (Integer)((IntegerExpression)lbl).getValue();
                        int ivalue = Ivalue;
                        if (tab.get(lbl) != null) {
                            env.error(s.where, "duplicate.label", Ivalue);
                            continue;
                        }
                        tab.put(lbl, s);
                        switch (switchType.getTypeCode()) {
                            case 1: {
                                overflow = ivalue != (byte)ivalue;
                                break;
                            }
                            case 3: {
                                overflow = ivalue != (short)ivalue;
                                break;
                            }
                            case 2: {
                                overflow = ivalue != (char)ivalue;
                                break;
                            }
                            default: {
                                overflow = false;
                            }
                        }
                        if (!overflow) continue;
                        env.error(s.where, "switch.overflow", Ivalue, switchType);
                        continue;
                    }
                    if (lbl.isConstant() && lbl.getType() == Type.tInt) continue;
                    env.error(s.where, "const.expr.required");
                    continue;
                }
                if (hasDefault) {
                    env.error(s.where, "duplicate.default");
                }
                hasDefault = true;
                continue;
            }
            vs = s.checkBlockStatement(env, newctx, vs, exp);
        }
        if (!vs.isDeadEnd()) {
            newctx.vsBreak = newctx.vsBreak.join(vs);
        }
        if (hasDefault) {
            vset = newctx.vsBreak;
        }
        return ctx.removeAdditionalVars(vset);
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        ctx = new Context(ctx, this);
        this.expr = this.expr.inlineValue(env, ctx);
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i] = this.args[i].inline(env, ctx);
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        SwitchStatement s = (SwitchStatement)this.clone();
        s.expr = this.expr.copyInline(ctx);
        s.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            s.args[i] = this.args[i].copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = this.expr.costInline(thresh, env, ctx);
        for (int i = 0; i < this.args.length && cost < thresh; ++i) {
            if (this.args[i] == null) continue;
            cost += this.args[i].costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        Expression e;
        Statement s;
        int i;
        CodeContext newctx = new CodeContext(ctx, this);
        this.expr.codeValue(env, newctx, asm);
        SwitchData sw = new SwitchData();
        boolean hasDefault = false;
        for (i = 0; i < this.args.length; ++i) {
            s = this.args[i];
            if (s == null || s.op != 96) continue;
            e = ((CaseStatement)s).expr;
            if (e != null) {
                sw.add(((IntegerExpression)e).value, new Label());
                continue;
            }
            hasDefault = true;
        }
        if (env.coverage()) {
            sw.initTableCase();
        }
        asm.add(this.where, 170, sw);
        for (i = 0; i < this.args.length; ++i) {
            s = this.args[i];
            if (s == null) continue;
            if (s.op == 96) {
                e = ((CaseStatement)s).expr;
                if (e != null) {
                    asm.add(sw.get(((IntegerExpression)e).value));
                    sw.addTableCase(((IntegerExpression)e).value, s.where);
                    continue;
                }
                asm.add(sw.getDefaultLabel());
                sw.addTableDefault(s.where);
                continue;
            }
            s.code(env, newctx, asm);
        }
        if (!hasDefault) {
            asm.add(sw.getDefaultLabel());
        }
        asm.add(newctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("switch (");
        this.expr.print(out);
        out.print(") {\n");
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.printIndent(out, indent + 1);
            this.args[i].print(out, indent + 1);
            out.print("\n");
        }
        this.printIndent(out, indent);
        out.print("}");
    }
}

