/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Vector;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.MemberDefinition;

public class ImplementationType
extends ClassType {
    public static ImplementationType forImplementation(ClassDefinition classDef, ContextStack stack, boolean quiet) {
        ImplementationType result;
        block8: {
            if (stack.anyErrors()) {
                return null;
            }
            boolean doPop = false;
            result = null;
            try {
                sun.tools.java.Type theType = classDef.getType();
                Type existing = ImplementationType.getType(theType, stack);
                if (existing != null) {
                    if (!(existing instanceof ImplementationType)) {
                        return null;
                    }
                    return (ImplementationType)existing;
                }
                if (ImplementationType.couldBeImplementation(quiet, stack, classDef)) {
                    ImplementationType it = new ImplementationType(stack, classDef);
                    ImplementationType.putType(theType, (Type)it, stack);
                    stack.push(it);
                    doPop = true;
                    if (it.initialize(stack, quiet)) {
                        stack.pop(true);
                        result = it;
                    } else {
                        ImplementationType.removeType(theType, stack);
                        stack.pop(false);
                    }
                }
            }
            catch (CompilerError e) {
                if (!doPop) break block8;
                stack.pop(false);
            }
        }
        return result;
    }

    @Override
    public String getTypeDescription() {
        return "Implementation";
    }

    private ImplementationType(ContextStack stack, ClassDefinition classDef) {
        super(0x6010000, classDef, stack);
    }

    private static boolean couldBeImplementation(boolean quiet, ContextStack stack, ClassDefinition classDef) {
        boolean result = false;
        BatchEnvironment env = stack.getEnv();
        try {
            if (!classDef.isClass()) {
                ImplementationType.failedConstraint(17, quiet, stack, classDef.getName());
            } else {
                result = env.defRemote.implementedBy(env, classDef.getClassDeclaration());
                if (!result) {
                    ImplementationType.failedConstraint(8, quiet, stack, classDef.getName());
                }
            }
        }
        catch (ClassNotFound e) {
            ImplementationType.classNotFound(stack, e);
        }
        return result;
    }

    private boolean initialize(ContextStack stack, boolean quiet) {
        boolean result = false;
        ClassDefinition theClass = this.getClassDefinition();
        if (this.initParents(stack)) {
            Vector directInterfaces = new Vector();
            Vector directMethods = new Vector();
            try {
                if (this.addRemoteInterfaces(directInterfaces, true, stack) != null) {
                    boolean haveRemote = false;
                    for (int i = 0; i < directInterfaces.size(); ++i) {
                        InterfaceType theInt = (InterfaceType)directInterfaces.elementAt(i);
                        if (theInt.isType(4096) || theInt.isType(524288)) {
                            haveRemote = true;
                        }
                        ImplementationType.copyRemoteMethods(theInt, directMethods);
                    }
                    if (!haveRemote) {
                        ImplementationType.failedConstraint(8, quiet, stack, this.getQualifiedName());
                        return false;
                    }
                    if (this.checkMethods(theClass, directMethods, stack, quiet)) {
                        result = this.initialize(directInterfaces, directMethods, null, stack, quiet);
                    }
                }
            }
            catch (ClassNotFound e) {
                ImplementationType.classNotFound(stack, e);
            }
        }
        return result;
    }

    private static void copyRemoteMethods(InterfaceType type, Vector list) {
        if (type.isType(4096)) {
            CompoundType.Method[] allMethods = type.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                CompoundType.Method theMethod = allMethods[i];
                if (list.contains(theMethod)) continue;
                list.addElement(theMethod);
            }
            InterfaceType[] allInterfaces = type.getInterfaces();
            for (int i = 0; i < allInterfaces.length; ++i) {
                ImplementationType.copyRemoteMethods(allInterfaces[i], list);
            }
        }
    }

    private boolean checkMethods(ClassDefinition theClass, Vector list, ContextStack stack, boolean quiet) {
        Object[] methods = new CompoundType.Method[list.size()];
        list.copyInto(methods);
        for (MemberDefinition member = theClass.getFirstMember(); member != null; member = member.getNextMember()) {
            if (!member.isMethod() || member.isConstructor() || member.isInitializer() || this.updateExceptions(member, (CompoundType.Method[])methods, stack, quiet)) continue;
            return false;
        }
        return true;
    }

    private boolean updateExceptions(MemberDefinition implMethod, CompoundType.Method[] list, ContextStack stack, boolean quiet) {
        int length = list.length;
        String implMethodSig = implMethod.toString();
        for (int i = 0; i < length; ++i) {
            CompoundType.Method existingMethod = list[i];
            MemberDefinition existing = existingMethod.getMemberDefinition();
            if (!implMethodSig.equals(existing.toString())) continue;
            try {
                ValueType[] implExcept = this.getMethodExceptions(implMethod, quiet, stack);
                existingMethod.setImplExceptions(implExcept);
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

