/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPathEntry;
import sun.tools.java.RmicUncheckedIOException;

final class JrtClassPathEntry
extends ClassPathEntry {
    private final FileSystem fs;
    private final Map<String, Path> pkgDirs;

    JrtClassPathEntry(FileSystem fs) {
        this.fs = fs;
        this.pkgDirs = new HashMap<String, Path>();
    }

    @Override
    void close() throws IOException {
    }

    synchronized Path getPackagePath(String pkgName) throws IOException {
        if (this.pkgDirs.containsKey(pkgName)) {
            return this.pkgDirs.get(pkgName);
        }
        Path pkgLink = this.fs.getPath("/packages/" + pkgName.replace('/', '.'), new String[0]);
        if (Files.isDirectory(pkgLink, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pkgLink);){
                for (Path p : stream) {
                    Path pkgDir;
                    Path modDir;
                    if (!Files.isSymbolicLink(p) || !Files.isDirectory(modDir = Files.readSymbolicLink(p), new LinkOption[0]) || !Files.isDirectory(pkgDir = this.fs.getPath(modDir.toString() + "/" + pkgName, new String[0]), new LinkOption[0])) continue;
                    DirectoryStream<Path> pstream = Files.newDirectoryStream(pkgDir);
                    Throwable throwable = null;
                    try {
                        for (Path f : pstream) {
                            if (!Files.isRegularFile(f, new LinkOption[0]) || !f.toString().endsWith(".class")) continue;
                            this.pkgDirs.put(pkgName, pkgDir);
                            Path path = pkgDir;
                            return path;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pstream == null) continue;
                        if (throwable != null) {
                            try {
                                pstream.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        pstream.close();
                    }
                }
            }
        }
        return null;
    }

    Path getClassPath(String clsName) throws IOException {
        int index = clsName.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        Path pkgPath = this.getPackagePath(clsName.substring(0, index));
        return pkgPath == null ? null : this.fs.getPath(pkgPath + "/" + clsName.substring(index + 1), new String[0]);
    }

    @Override
    ClassFile getFile(String name, String subdir, String basename, boolean isDirectory) {
        try {
            name = name.replace(File.separatorChar, '/');
            Path cp = this.getClassPath(name);
            return cp == null ? null : ClassFile.newClassFile(cp);
        }
        catch (IOException ioExp) {
            throw new RmicUncheckedIOException(ioExp);
        }
    }

    @Override
    void fillFiles(String pkg, String ext, Hashtable<String, ClassFile> files) {
        Path dir;
        try {
            dir = this.getPackagePath(pkg);
            if (dir == null) {
                return;
            }
        }
        catch (IOException ioExp) {
            throw new RmicUncheckedIOException(ioExp);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path p : stream) {
                String name = p.toString();
                if (!(name = name.replace('/', File.separatorChar)).startsWith(pkg) || !name.endsWith(ext)) continue;
                files.put(name, ClassFile.newClassFile(p));
            }
        }
        catch (IOException ioExp) {
            throw new RmicUncheckedIOException(ioExp);
        }
    }
}

