/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class BreakStatement
extends Statement {
    Identifier lbl;

    public BreakStatement(long where, Identifier lbl) {
        super(98, where);
        this.lbl = lbl;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.reach(env, vset);
        this.checkLabel(env, ctx);
        CheckContext destctx = (CheckContext)new CheckContext(ctx, this).getBreakContext(this.lbl);
        if (destctx != null) {
            if (destctx.frameNumber != ctx.frameNumber) {
                env.error(this.where, "branch.to.uplevel", this.lbl);
            }
            destctx.vsBreak = destctx.vsBreak.join(vset);
        } else if (this.lbl != null) {
            env.error(this.where, "label.not.found", this.lbl);
        } else {
            env.error(this.where, "invalid.break");
        }
        CheckContext exitctx = ctx.getTryExitContext();
        if (exitctx != null) {
            exitctx.vsTryExit = exitctx.vsTryExit.join(vset);
        }
        return DEAD_END;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext newctx = new CodeContext(ctx, this);
        CodeContext destctx = (CodeContext)newctx.getBreakContext(this.lbl);
        this.codeFinally(env, ctx, asm, destctx, null);
        asm.add(this.where, 167, destctx.breakLabel);
        asm.add(newctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("break");
        if (this.lbl != null) {
            out.print(" " + this.lbl);
        }
        out.print(";");
    }
}

