/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.CatchData;
import sun.tools.asm.TryData;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CatchStatement;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class TryStatement
extends Statement {
    Statement body;
    Statement[] args;
    long arrayCloneWhere;

    public TryStatement(long where, Statement body, Statement[] args) {
        super(101, where);
        this.body = body;
        this.args = args;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        try {
            int i;
            vset = this.reach(env, vset);
            Hashtable<Object, Object> newexp = new Hashtable<Object, Object>();
            CheckContext newctx = new CheckContext(ctx, this);
            Vset vs = this.body.check(env, newctx, vset.copy(), newexp);
            Vset cvs = Vset.firstDAandSecondDU(vset, vs.copy().join(newctx.vsTryExit));
            for (i = 0; i < this.args.length; ++i) {
                vs = vs.join(this.args[i].check(env, newctx, cvs.copy(), exp));
            }
            block3: for (i = 1; i < this.args.length; ++i) {
                CatchStatement cs = (CatchStatement)this.args[i];
                if (cs.field == null) continue;
                Type type = cs.field.getType();
                ClassDefinition def = env.getClassDefinition(type);
                for (int j = 0; j < i; ++j) {
                    Type t;
                    ClassDeclaration c;
                    CatchStatement cs2 = (CatchStatement)this.args[j];
                    if (cs2.field == null || !def.subClassOf(env, c = env.getClassDeclaration(t = cs2.field.getType()))) continue;
                    env.error(this.args[i].where, "catch.not.reached");
                    continue block3;
                }
            }
            ClassDeclaration ignore1 = env.getClassDeclaration(idJavaLangError);
            ClassDeclaration ignore2 = env.getClassDeclaration(idJavaLangRuntimeException);
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                ClassDefinition def;
                Type type;
                CatchStatement cs = (CatchStatement)this.args[i2];
                if (cs.field == null || !(type = cs.field.getType()).isType(10) || (def = env.getClassDefinition(type)).subClassOf(env, ignore1) || def.superClassOf(env, ignore1) || def.subClassOf(env, ignore2) || def.superClassOf(env, ignore2)) continue;
                boolean ok = false;
                Enumeration<Object> e = newexp.keys();
                while (e.hasMoreElements()) {
                    ClassDeclaration c = (ClassDeclaration)e.nextElement();
                    if (!def.superClassOf(env, c) && !def.subClassOf(env, c)) continue;
                    ok = true;
                    break;
                }
                if (!ok && this.arrayCloneWhere != 0L && def.getName().toString().equals("java.lang.CloneNotSupportedException")) {
                    env.error(this.arrayCloneWhere, "warn.array.clone.supported", def.getName());
                }
                if (ok) continue;
                env.error(cs.where, "catch.not.thrown", def.getName());
            }
            Enumeration<Object> e = newexp.keys();
            while (e.hasMoreElements()) {
                ClassDeclaration c = (ClassDeclaration)e.nextElement();
                ClassDefinition def = c.getClassDefinition(env);
                boolean add = true;
                for (int i3 = 0; i3 < this.args.length; ++i3) {
                    Type type;
                    CatchStatement cs = (CatchStatement)this.args[i3];
                    if (cs.field == null || (type = cs.field.getType()).isType(13) || !def.subClassOf(env, env.getClassDeclaration(type))) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                exp.put(c, newexp.get(c));
            }
            return ctx.removeAdditionalVars(vs.join(newctx.vsBreak));
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, opNames[this.op]);
            return vset;
        }
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        if (this.body != null) {
            this.body = this.body.inline(env, new Context(ctx, this));
        }
        if (this.body == null) {
            return null;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i] = this.args[i].inline(env, new Context(ctx, this));
        }
        return this.args.length == 0 ? this.eliminate(env, this.body) : this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        TryStatement s = (TryStatement)this.clone();
        if (this.body != null) {
            s.body = this.body.copyInline(ctx, valNeeded);
        }
        s.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            s.args[i] = this.args[i].copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return thresh;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        int i;
        CodeContext newctx = new CodeContext(ctx, this);
        TryData td = new TryData();
        for (i = 0; i < this.args.length; ++i) {
            Type t = ((CatchStatement)this.args[i]).field.getType();
            if (t.isType(10)) {
                td.add(env.getClassDeclaration(t));
                continue;
            }
            td.add(t);
        }
        asm.add(this.where, -3, td);
        if (this.body != null) {
            this.body.code(env, newctx, asm);
        }
        asm.add(td.getEndLabel());
        asm.add(this.where, 167, newctx.breakLabel);
        for (i = 0; i < this.args.length; ++i) {
            CatchData cd = td.getCatch(i);
            asm.add(cd.getLabel());
            this.args[i].code(env, newctx, asm);
            asm.add(this.where, 167, newctx.breakLabel);
        }
        asm.add(newctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("try ");
        if (this.body != null) {
            this.body.print(out, indent);
        } else {
            out.print("<empty>");
        }
        for (int i = 0; i < this.args.length; ++i) {
            out.print(" ");
            this.args[i].print(out, indent);
        }
    }
}

