/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

public class StaticStringsHash {
    public String[] strings = null;
    public int[] keys = null;
    public int[][] buckets = null;
    public String method = null;
    private int length;
    private int[] tempKeys;
    private int[] bucketSizes;
    private int bucketCount;
    private int maxDepth;
    private int minStringLength = Integer.MAX_VALUE;
    private int keyKind;
    private int charAt;
    private static final int LENGTH = 0;
    private static final int CHAR_AT = 1;
    private static final int HASH_CODE = 2;
    private static final int CHAR_AT_MAX_LINES = 50;
    private static final int CHAR_AT_MAX_CHARS = 1000;

    public int getKey(String str) {
        switch (this.keyKind) {
            case 0: {
                return str.length();
            }
            case 1: {
                return str.charAt(this.charAt);
            }
            case 2: {
                return str.hashCode();
            }
        }
        throw new Error("Bad keyKind");
    }

    public StaticStringsHash(String[] strings) {
        int i;
        boolean didSwap;
        int i2;
        this.strings = strings;
        this.length = strings.length;
        this.tempKeys = new int[this.length];
        this.bucketSizes = new int[this.length];
        this.setMinStringLength();
        int currentMaxDepth = this.getKeys(0);
        int useCharAt = -1;
        boolean useHashCode = false;
        if (currentMaxDepth > 1) {
            int hashCodeDepth;
            int minLength = this.minStringLength;
            if (this.length > 50 && this.length * minLength > 1000) {
                minLength = this.length / 1000;
            }
            this.charAt = 0;
            for (i2 = 0; i2 < minLength; ++i2) {
                int charAtDepth = this.getKeys(1);
                if (charAtDepth < currentMaxDepth) {
                    currentMaxDepth = charAtDepth;
                    useCharAt = i2;
                    if (currentMaxDepth == 1) break;
                }
                ++this.charAt;
            }
            this.charAt = useCharAt;
            if (currentMaxDepth > 1 && (hashCodeDepth = this.getKeys(2)) < currentMaxDepth - 3) {
                useHashCode = true;
            }
            if (!useHashCode) {
                if (useCharAt >= 0) {
                    this.getKeys(1);
                } else {
                    this.getKeys(0);
                }
            }
        }
        this.keys = new int[this.bucketCount];
        System.arraycopy(this.tempKeys, 0, this.keys, 0, this.bucketCount);
        do {
            didSwap = false;
            for (i2 = 0; i2 < this.bucketCount - 1; ++i2) {
                if (this.keys[i2] <= this.keys[i2 + 1]) continue;
                int temp = this.keys[i2];
                this.keys[i2] = this.keys[i2 + 1];
                this.keys[i2 + 1] = temp;
                temp = this.bucketSizes[i2];
                this.bucketSizes[i2] = this.bucketSizes[i2 + 1];
                this.bucketSizes[i2 + 1] = temp;
                didSwap = true;
            }
        } while (didSwap);
        int unused = this.findUnusedKey();
        this.buckets = new int[this.bucketCount][];
        for (i = 0; i < this.bucketCount; ++i) {
            this.buckets[i] = new int[this.bucketSizes[i]];
            for (int j = 0; j < this.bucketSizes[i]; ++j) {
                this.buckets[i][j] = unused;
            }
        }
        block5: for (i = 0; i < strings.length; ++i) {
            int key = this.getKey(strings[i]);
            for (int j = 0; j < this.bucketCount; ++j) {
                if (this.keys[j] != key) continue;
                int k = 0;
                while (this.buckets[j][k] != unused) {
                    ++k;
                }
                this.buckets[j][k] = i;
                continue block5;
            }
        }
    }

    public static void main(String[] args) {
        StaticStringsHash hash = new StaticStringsHash(args);
        System.out.println();
        System.out.println("    public boolean contains(String key) {");
        System.out.println("        switch (key." + hash.method + ") {");
        for (int i = 0; i < hash.buckets.length; ++i) {
            System.out.println("            case " + hash.keys[i] + ": ");
            for (int j = 0; j < hash.buckets[i].length; ++j) {
                if (j > 0) {
                    System.out.print("                } else ");
                } else {
                    System.out.print("                ");
                }
                System.out.println("if (key.equals(\"" + hash.strings[hash.buckets[i][j]] + "\")) {");
                System.out.println("                    return true;");
            }
            System.out.println("                }");
        }
        System.out.println("        }");
        System.out.println("        return false;");
        System.out.println("    }");
    }

    private void resetKeys(int keyKind) {
        this.keyKind = keyKind;
        switch (keyKind) {
            case 0: {
                this.method = "length()";
                break;
            }
            case 1: {
                this.method = "charAt(" + this.charAt + ")";
                break;
            }
            case 2: {
                this.method = "hashCode()";
            }
        }
        this.maxDepth = 1;
        this.bucketCount = 0;
        for (int i = 0; i < this.length; ++i) {
            this.tempKeys[i] = 0;
            this.bucketSizes[i] = 0;
        }
    }

    private void setMinStringLength() {
        for (int i = 0; i < this.length; ++i) {
            if (this.strings[i].length() >= this.minStringLength) continue;
            this.minStringLength = this.strings[i].length();
        }
    }

    private int findUnusedKey() {
        int unused = 0;
        int keysLength = this.keys.length;
        while (true) {
            boolean match = false;
            for (int i = 0; i < keysLength; ++i) {
                if (this.keys[i] != unused) continue;
                match = true;
                break;
            }
            if (!match) break;
            --unused;
        }
        return unused;
    }

    private int getKeys(int methodKind) {
        this.resetKeys(methodKind);
        for (int i = 0; i < this.strings.length; ++i) {
            this.addKey(this.getKey(this.strings[i]));
        }
        return this.maxDepth;
    }

    private void addKey(int key) {
        boolean addIt = true;
        for (int j = 0; j < this.bucketCount; ++j) {
            if (this.tempKeys[j] != key) continue;
            addIt = false;
            int n = j;
            this.bucketSizes[n] = this.bucketSizes[n] + 1;
            if (this.bucketSizes[j] <= this.maxDepth) break;
            this.maxDepth = this.bucketSizes[j];
            break;
        }
        if (addIt) {
            this.tempKeys[this.bucketCount] = key;
            this.bucketSizes[this.bucketCount] = 1;
            ++this.bucketCount;
        }
    }
}

