/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.tree.BinaryBitExpression;
import sun.tools.tree.BooleanExpression;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.IntExpression;
import sun.tools.tree.LongExpression;

public class BitOrExpression
extends BinaryBitExpression {
    public BitOrExpression(long where, Expression left, Expression right) {
        super(16, where, left, right);
    }

    @Override
    Expression eval(boolean a, boolean b) {
        return new BooleanExpression(this.where, a | b);
    }

    @Override
    Expression eval(int a, int b) {
        return new IntExpression(this.where, a | b);
    }

    @Override
    Expression eval(long a, long b) {
        return new LongExpression(this.where, a | b);
    }

    @Override
    Expression simplify() {
        if (this.left.equals(false) || this.left.equals(0)) {
            return this.right;
        }
        if (this.right.equals(false) || this.right.equals(0)) {
            return this.left;
        }
        if (this.left.equals(true)) {
            return new CommaExpression(this.where, this.right, this.left).simplify();
        }
        if (this.right.equals(true)) {
            return new CommaExpression(this.where, this.left, this.right).simplify();
        }
        return this;
    }

    @Override
    void codeOperation(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 128 + this.type.getTypeCodeOffset());
    }
}

