/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.LocalVariable;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;

final class LocalVariableTable {
    LocalVariable[] locals = new LocalVariable[8];
    int len;

    LocalVariableTable() {
    }

    void define(MemberDefinition field, int slot, int from, int to) {
        if (from >= to) {
            return;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.locals[i].field != field || this.locals[i].slot != slot || from > this.locals[i].to || to < this.locals[i].from) continue;
            this.locals[i].from = Math.min(this.locals[i].from, from);
            this.locals[i].to = Math.max(this.locals[i].to, to);
            return;
        }
        if (this.len == this.locals.length) {
            LocalVariable[] newlocals = new LocalVariable[this.len * 2];
            System.arraycopy(this.locals, 0, newlocals, 0, this.len);
            this.locals = newlocals;
        }
        this.locals[this.len++] = new LocalVariable(field, slot, from, to);
    }

    private void trim_ranges() {
        for (int i = 0; i < this.len; ++i) {
            for (int j = i + 1; j < this.len; ++j) {
                if (this.locals[i].field.getName() != this.locals[j].field.getName() || this.locals[i].from > this.locals[j].to || this.locals[i].to < this.locals[j].from) continue;
                if (this.locals[i].slot < this.locals[j].slot) {
                    if (this.locals[i].from >= this.locals[j].from) continue;
                    this.locals[i].to = Math.min(this.locals[i].to, this.locals[j].from);
                    continue;
                }
                if (this.locals[i].slot <= this.locals[j].slot || this.locals[i].from <= this.locals[j].from) continue;
                this.locals[j].to = Math.min(this.locals[j].to, this.locals[i].from);
            }
        }
    }

    void write(Environment env, DataOutputStream out, ConstantPool tab) throws IOException {
        this.trim_ranges();
        out.writeShort(this.len);
        for (int i = 0; i < this.len; ++i) {
            out.writeShort(this.locals[i].from);
            out.writeShort(this.locals[i].to - this.locals[i].from);
            out.writeShort(tab.index(this.locals[i].field.getName().toString()));
            out.writeShort(tab.index(this.locals[i].field.getType().getTypeSignature()));
            out.writeShort(this.locals[i].slot);
        }
    }
}

