/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.BinaryLogicalExpression;
import sun.tools.tree.BooleanExpression;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.ConditionVars;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.Vset;

public class OrExpression
extends BinaryLogicalExpression {
    public OrExpression(long where, Expression left, Expression right) {
        super(14, where, left, right);
    }

    @Override
    public void checkCondition(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, ConditionVars cvars) {
        this.left.checkCondition(env, ctx, vset, exp, cvars);
        this.left = this.convert(env, ctx, Type.tBoolean, this.left);
        Vset vsTrue = cvars.vsTrue.copy();
        Vset vsFalse = cvars.vsFalse.copy();
        this.right.checkCondition(env, ctx, vsFalse, exp, cvars);
        this.right = this.convert(env, ctx, Type.tBoolean, this.right);
        cvars.vsTrue = cvars.vsTrue.join(vsTrue);
    }

    @Override
    Expression eval(boolean a, boolean b) {
        return new BooleanExpression(this.where, a || b);
    }

    @Override
    Expression simplify() {
        if (this.right.equals(false)) {
            return this.left;
        }
        if (this.left.equals(true)) {
            return this.left;
        }
        if (this.left.equals(false)) {
            return this.right;
        }
        if (this.right.equals(true)) {
            return new CommaExpression(this.where, this.left, this.right).simplify();
        }
        return this;
    }

    @Override
    void codeBranch(Environment env, Context ctx, Assembler asm, Label lbl, boolean whenTrue) {
        if (whenTrue) {
            this.left.codeBranch(env, ctx, asm, lbl, true);
            this.right.codeBranch(env, ctx, asm, lbl, true);
        } else {
            Label lbl2 = new Label();
            this.left.codeBranch(env, ctx, asm, lbl2, true);
            this.right.codeBranch(env, ctx, asm, lbl, false);
            asm.add(lbl2);
        }
    }
}

