/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.BinaryExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;

public class BinaryEqualityExpression
extends BinaryExpression {
    public BinaryEqualityExpression(int op, long where, Expression left, Expression right) {
        super(op, where, Type.tBoolean, left, right);
    }

    @Override
    void selectType(Environment env, Context ctx, int tm) {
        if ((tm & 0x2000) != 0) {
            return;
        }
        if ((tm & 0x700) != 0) {
            try {
                if (env.explicitCast(this.left.type, this.right.type) || env.explicitCast(this.right.type, this.left.type)) {
                    return;
                }
                env.error(this.where, "incompatible.type", this.left.type, this.left.type, this.right.type);
            }
            catch (ClassNotFound e) {
                env.error(this.where, "class.not.found", e.name, opNames[this.op]);
            }
            return;
        }
        Type t = (tm & 0x80) != 0 ? Type.tDouble : ((tm & 0x40) != 0 ? Type.tFloat : ((tm & 0x20) != 0 ? Type.tLong : ((tm & 1) != 0 ? Type.tBoolean : Type.tInt)));
        this.left = this.convert(env, ctx, t, this.left);
        this.right = this.convert(env, ctx, t, this.right);
    }
}

