/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.LocalVariable;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class CatchStatement
extends Statement {
    int mod;
    Expression texpr;
    Identifier id;
    Statement body;
    LocalMember field;

    public CatchStatement(long where, Expression texpr, IdentifierToken id, Statement body) {
        super(102, where);
        this.mod = id.getModifiers();
        this.texpr = texpr;
        this.id = id.getName();
        this.body = body;
    }

    @Deprecated
    public CatchStatement(long where, Expression texpr, Identifier id, Statement body) {
        super(102, where);
        this.texpr = texpr;
        this.id = id;
        this.body = body;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.reach(env, vset);
        ctx = new Context(ctx, this);
        Type type = this.texpr.toType(env, ctx);
        try {
            if (ctx.getLocalField(this.id) != null) {
                env.error(this.where, "local.redefined", this.id);
            }
            if (!type.isType(13)) {
                if (!type.isType(10)) {
                    env.error(this.where, "catch.not.throwable", type);
                } else {
                    ClassDefinition def = env.getClassDefinition(type);
                    if (!def.subClassOf(env, env.getClassDeclaration(idJavaLangThrowable))) {
                        env.error(this.where, "catch.not.throwable", def);
                    }
                }
            }
            this.field = new LocalMember(this.where, ctx.field.getClassDefinition(), this.mod, type, this.id);
            ctx.declare(env, this.field);
            vset.addVar(this.field.number);
            return this.body.check(env, ctx, vset, exp);
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, opNames[this.op]);
            return vset;
        }
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        ctx = new Context(ctx, this);
        if (this.field.isUsed()) {
            ctx.declare(env, this.field);
        }
        if (this.body != null) {
            this.body = this.body.inline(env, ctx);
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        CatchStatement s = (CatchStatement)this.clone();
        if (this.body != null) {
            s.body = this.body.copyInline(ctx, valNeeded);
        }
        if (this.field != null) {
            s.field = this.field.copyInline(ctx);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 1;
        if (this.body != null) {
            cost += this.body.costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext newctx = new CodeContext(ctx, this);
        if (this.field.isUsed()) {
            newctx.declare(env, this.field);
            asm.add(this.where, 58, new LocalVariable(this.field, this.field.number));
        } else {
            asm.add(this.where, 87);
        }
        if (this.body != null) {
            this.body.code(env, newctx, asm);
        }
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("catch (");
        this.texpr.print(out);
        out.print(" " + this.id + ") ");
        if (this.body != null) {
            this.body.print(out, indent);
        } else {
            out.print("<empty>");
        }
    }
}

