/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.AssignExpression;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.CompoundStatement;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.ExpressionStatement;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.InlineMethodExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.NaryExpression;
import sun.tools.tree.NewInstanceExpression;
import sun.tools.tree.NullExpression;
import sun.tools.tree.Statement;
import sun.tools.tree.SuperExpression;
import sun.tools.tree.ThisExpression;
import sun.tools.tree.TryStatement;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.VarDeclarationStatement;
import sun.tools.tree.Vset;

public class MethodExpression
extends NaryExpression {
    Identifier id;
    ClassDefinition clazz;
    MemberDefinition field;
    Expression implementation;
    private boolean isSuper;
    static final int MAXINLINECOST = Statement.MAXINLINECOST;

    public MethodExpression(long where, Expression right, Identifier id, Expression[] args) {
        super(47, where, Type.tError, right, args);
        this.id = id;
    }

    public MethodExpression(long where, Expression right, MemberDefinition field, Expression[] args) {
        super(47, where, field.getType().getReturnType(), right, args);
        this.id = field.getName();
        this.field = field;
        this.clazz = field.getClassDefinition();
    }

    public MethodExpression(long where, Expression right, MemberDefinition field, Expression[] args, boolean forceSuper) {
        this(where, right, field, args);
        this.isSuper = forceSuper;
    }

    @Override
    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        Expression e;
        Expression[] newargs;
        ClassDeclaration c = null;
        boolean isArray = false;
        boolean staticRef = false;
        MemberDefinition implMethod = null;
        ClassDefinition ctxClass = ctx.field.getClassDefinition();
        Expression[] args = this.args;
        if (this.id.equals(idInit)) {
            ClassDefinition conCls = ctxClass;
            try {
                Expression conOuter = null;
                if (this.right instanceof SuperExpression) {
                    conCls = conCls.getSuperClass().getClassDefinition(env);
                    conOuter = ((SuperExpression)this.right).outerArg;
                } else if (this.right instanceof ThisExpression) {
                    conOuter = ((ThisExpression)this.right).outerArg;
                }
                args = NewInstanceExpression.insertOuterLink(env, ctx, this.where, conCls, conOuter, args);
            }
            catch (ClassNotFound ee) {
                // empty catch block
            }
        }
        Type[] argTypes = new Type[args.length];
        ClassDefinition sourceClass = ctxClass;
        try {
            ClassDefinition cdef;
            if (this.right == null) {
                ClassDefinition cdef2;
                staticRef = ctx.field.isStatic();
                MemberDefinition m = null;
                for (cdef2 = ctxClass; cdef2 != null && (m = cdef2.findAnyMethod(env, this.id)) == null; cdef2 = cdef2.getOuterClass()) {
                }
                if (m == null) {
                    c = ctx.field.getClassDeclaration();
                } else {
                    c = cdef2.getClassDeclaration();
                    if (m.getClassDefinition() != cdef2) {
                        ClassDefinition cdef22 = cdef2;
                        while ((cdef22 = cdef22.getOuterClass()) != null) {
                            MemberDefinition m2 = cdef22.findAnyMethod(env, this.id);
                            if (m2 == null || m2.getClassDefinition() != cdef22) continue;
                            env.error(this.where, "inherited.hides.method", this.id, cdef2.getClassDeclaration(), cdef22.getClassDeclaration());
                            break;
                        }
                    }
                }
            } else {
                if (this.id.equals(idInit)) {
                    int thisN = ctx.getThisNumber();
                    if (!ctx.field.isConstructor()) {
                        env.error(this.where, "invalid.constr.invoke");
                        return vset.addVar(thisN);
                    }
                    if (!vset.isReallyDeadEnd() && vset.testVar(thisN)) {
                        env.error(this.where, "constr.invoke.not.first");
                        return vset;
                    }
                    vset = vset.addVar(thisN);
                    vset = this.right instanceof SuperExpression ? this.right.checkAmbigName(env, ctx, vset, exp, this) : this.right.checkValue(env, ctx, vset, exp);
                } else {
                    vset = this.right.checkAmbigName(env, ctx, vset, exp, this);
                    if (this.right.type == Type.tPackage) {
                        FieldExpression.reportFailedPackagePrefix(env, this.right);
                        return vset;
                    }
                    if (this.right instanceof TypeExpression) {
                        staticRef = true;
                    }
                }
                if (this.right.type.isType(10)) {
                    c = env.getClassDeclaration(this.right.type);
                } else if (this.right.type.isType(9)) {
                    isArray = true;
                    c = env.getClassDeclaration(Type.tObject);
                } else {
                    if (!this.right.type.isType(13)) {
                        env.error(this.where, "invalid.method.invoke", this.right.type);
                    }
                    return vset;
                }
                if (this.right instanceof FieldExpression) {
                    Identifier id = ((FieldExpression)this.right).id;
                    if (id == idThis) {
                        sourceClass = ((FieldExpression)this.right).clazz;
                    } else if (id == idSuper) {
                        this.isSuper = true;
                        sourceClass = ((FieldExpression)this.right).clazz;
                    }
                } else if (this.right instanceof SuperExpression) {
                    this.isSuper = true;
                }
                if (this.id != idInit && !FieldExpression.isTypeAccessible(this.where, env, this.right.type, sourceClass)) {
                    ClassDeclaration cdecl = sourceClass.getClassDeclaration();
                    if (staticRef) {
                        env.error(this.where, "no.type.access", this.id, this.right.type.toString(), cdecl);
                    } else {
                        env.error(this.where, "cant.access.member.type", this.id, this.right.type.toString(), cdecl);
                    }
                }
            }
            boolean hasErrors = false;
            if (this.id.equals(idInit)) {
                vset = vset.clearVar(ctx.getThisNumber());
            }
            for (int i = 0; i < args.length; ++i) {
                vset = args[i].checkValue(env, ctx, vset, exp);
                argTypes[i] = args[i].type;
                hasErrors = hasErrors || argTypes[i].isType(13);
            }
            if (this.id.equals(idInit)) {
                vset = vset.addVar(ctx.getThisNumber());
            }
            if (hasErrors) {
                return vset;
            }
            this.clazz = c.getClassDefinition(env);
            if (this.field == null) {
                this.field = this.clazz.matchMethod(env, sourceClass, this.id, argTypes);
                if (this.field == null) {
                    if (this.id.equals(idInit)) {
                        if (this.diagnoseMismatch(env, args, argTypes)) {
                            return vset;
                        }
                        String sig = this.clazz.getName().getName().toString();
                        sig = Type.tMethod(Type.tError, argTypes).typeString(sig, false, false);
                        env.error(this.where, "unmatched.constr", sig, c);
                        return vset;
                    }
                    String sig = this.id.toString();
                    sig = Type.tMethod(Type.tError, argTypes).typeString(sig, false, false);
                    if (this.clazz.findAnyMethod(env, this.id) == null) {
                        if (ctx.getField(env, this.id) != null) {
                            env.error(this.where, "invalid.method", this.id, c);
                        } else {
                            env.error(this.where, "undef.meth", sig, c);
                        }
                    } else if (!this.diagnoseMismatch(env, args, argTypes)) {
                        env.error(this.where, "unmatched.meth", sig, c);
                    }
                    return vset;
                }
            }
            this.type = this.field.getType().getReturnType();
            if (staticRef && !this.field.isStatic()) {
                env.error(this.where, "no.static.meth.access", this.field, this.field.getClassDeclaration());
                return vset;
            }
            if (!(!this.field.isProtected() || this.right == null || this.right instanceof SuperExpression || this.right instanceof FieldExpression && ((FieldExpression)this.right).id == idSuper || sourceClass.protectedAccess(env, this.field, this.right.type))) {
                env.error(this.where, "invalid.protected.method.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            if (this.right instanceof FieldExpression && ((FieldExpression)this.right).id == idSuper && !this.field.isPrivate() && sourceClass != ctxClass) {
                implMethod = sourceClass.getAccessMember(env, ctx, this.field, true);
            }
            if (implMethod == null && this.field.isPrivate() && (cdef = this.field.getClassDefinition()) != ctxClass) {
                implMethod = cdef.getAccessMember(env, ctx, this.field, false);
            }
            if (this.field.isAbstract() && this.right != null && this.right.op == 83) {
                env.error(this.where, "invoke.abstract", this.field, this.field.getClassDeclaration());
                return vset;
            }
            if (this.field.reportDeprecated(env)) {
                if (this.field.isConstructor()) {
                    env.error(this.where, "warn.constr.is.deprecated", this.field);
                } else {
                    env.error(this.where, "warn.meth.is.deprecated", this.field, this.field.getClassDefinition());
                }
            }
            if (this.field.isConstructor() && ctx.field.equals(this.field)) {
                env.error(this.where, "recursive.constr", this.field);
            }
            if (sourceClass == ctxClass) {
                ClassDefinition declarer = this.field.getClassDefinition();
                if (!this.field.isConstructor() && declarer.isPackagePrivate() && !declarer.getName().getQualifier().equals(sourceClass.getName().getQualifier())) {
                    this.field = MemberDefinition.makeProxyMember(this.field, this.clazz, env);
                }
            }
            sourceClass.addDependency(this.field.getClassDeclaration());
            if (sourceClass != ctxClass) {
                ctxClass.addDependency(this.field.getClassDeclaration());
            }
        }
        catch (ClassNotFound ee) {
            env.error(this.where, "class.not.found", ee.name, ctx.field);
            return vset;
        }
        catch (AmbiguousMember ee) {
            env.error(this.where, "ambig.field", this.id, ee.field1, ee.field2);
            return vset;
        }
        if (this.right == null && !this.field.isStatic()) {
            this.right = ctx.findOuterLink(env, this.where, this.field);
            vset = this.right.checkValue(env, ctx, vset, exp);
        }
        argTypes = this.field.getType().getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.convert(env, ctx, argTypes[i], args[i]);
        }
        if (this.field.isConstructor()) {
            MemberDefinition m = this.field;
            if (implMethod != null) {
                m = implMethod;
            }
            int nargs = args.length;
            newargs = args;
            if (nargs > this.args.length) {
                int i;
                ThisExpression rightI;
                if (this.right instanceof SuperExpression) {
                    rightI = new SuperExpression(this.right.where, ctx);
                    ((SuperExpression)this.right).outerArg = args[0];
                } else if (this.right instanceof ThisExpression) {
                    rightI = new ThisExpression(this.right.where, ctx);
                } else {
                    throw new CompilerError("this.init");
                }
                if (implMethod != null) {
                    newargs = new Expression[nargs + 1];
                    this.args = new Expression[nargs];
                    newargs[0] = args[0];
                    this.args[0] = newargs[1] = new NullExpression(this.where);
                    for (i = 1; i < nargs; ++i) {
                        Expression expression = args[i];
                        newargs[i + 1] = expression;
                        this.args[i] = expression;
                    }
                } else {
                    for (i = 1; i < nargs; ++i) {
                        this.args[i - 1] = args[i];
                    }
                }
                this.implementation = new MethodExpression(this.where, (Expression)rightI, m, newargs);
                this.implementation.type = this.type;
            } else {
                if (implMethod != null) {
                    newargs = new Expression[nargs + 1];
                    newargs[0] = new NullExpression(this.where);
                    for (int i = 0; i < nargs; ++i) {
                        newargs[i + 1] = args[i];
                    }
                }
                this.implementation = new MethodExpression(this.where, this.right, m, newargs);
            }
        } else {
            if (args.length > this.args.length) {
                throw new CompilerError("method arg");
            }
            if (implMethod != null) {
                Expression[] oldargs = this.args;
                if (this.field.isStatic()) {
                    MethodExpression call = new MethodExpression(this.where, null, implMethod, oldargs);
                    this.implementation = new CommaExpression(this.where, this.right, call);
                } else {
                    int nargs = oldargs.length;
                    newargs = new Expression[nargs + 1];
                    newargs[0] = this.right;
                    for (int i = 0; i < nargs; ++i) {
                        newargs[i + 1] = oldargs[i];
                    }
                    this.implementation = new MethodExpression(this.where, null, implMethod, newargs);
                }
            }
        }
        if (ctx.field.isConstructor() && this.field.isConstructor() && this.right != null && this.right.op == 83 && (e = this.makeVarInits(env, ctx)) != null) {
            if (this.implementation == null) {
                this.implementation = (Expression)this.clone();
            }
            this.implementation = new CommaExpression(this.where, this.implementation, e);
        }
        ClassDeclaration[] exceptions = this.field.getExceptions(env);
        if (isArray && this.field.getName() == idClone && this.field.getType().getArgumentTypes().length == 0) {
            exceptions = new ClassDeclaration[]{};
            Context p = ctx;
            while (p != null) {
                if (p.node != null && p.node.op == 101) {
                    ((TryStatement)p.node).arrayCloneWhere = this.where;
                }
                p = p.prev;
            }
        }
        for (int i = 0; i < exceptions.length; ++i) {
            if (exp.get(exceptions[i]) != null) continue;
            exp.put(exceptions[i], this);
        }
        if (ctx.field.isConstructor() && this.field.isConstructor() && this.right != null && this.right.op == 82) {
            ClassDefinition cls = this.field.getClassDefinition();
            for (MemberDefinition f = cls.getFirstMember(); f != null; f = f.getNextMember()) {
                if (!f.isVariable() || !f.isBlankFinal() || f.isStatic()) continue;
                vset = vset.addVar(ctx.getFieldNumber(f));
            }
        }
        return vset;
    }

    @Override
    public Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        return this.checkValue(env, ctx, vset, exp);
    }

    boolean diagnoseMismatch(Environment env, Expression[] args, Type[] argTypes) throws ClassNotFound {
        Type[] margType = new Type[1];
        boolean saidSomething = false;
        int start = 0;
        while (start < argTypes.length) {
            String opName;
            int code = this.clazz.diagnoseMismatch(env, this.id, argTypes, start, margType);
            String string = opName = this.id.equals(idInit) ? "constructor" : opNames[this.op];
            if (code == -2) {
                env.error(this.where, "wrong.number.args", opName);
                saidSomething = true;
            }
            if (code < 0) break;
            int i = code >> 2;
            boolean castOK = (code & 2) != 0;
            boolean ambig = (code & 1) != 0;
            Type targetType = margType[0];
            String ttype = "" + targetType;
            if (castOK) {
                env.error(args[i].where, "explicit.cast.needed", opName, argTypes[i], ttype);
            } else {
                env.error(args[i].where, "incompatible.type", opName, argTypes[i], ttype);
            }
            saidSomething = true;
            start = i + 1;
        }
        return saidSomething;
    }

    private Expression inlineMethod(Environment env, Context ctx, Statement s, boolean valNeeded) {
        if (env.dump()) {
            System.out.println("INLINE METHOD " + this.field + " in " + ctx.field);
        }
        LocalMember[] v = LocalMember.copyArguments(ctx, this.field);
        Statement[] body = new Statement[v.length + 2];
        int n = 0;
        if (this.field.isStatic()) {
            body[0] = new ExpressionStatement(this.where, this.right);
        } else {
            if (this.right != null && this.right.op == 83) {
                this.right = new ThisExpression(this.right.where, ctx);
            }
            body[0] = new VarDeclarationStatement(this.where, v[n++], this.right);
        }
        for (int i = 0; i < this.args.length; ++i) {
            body[i + 1] = new VarDeclarationStatement(this.where, v[n++], this.args[i]);
        }
        body[body.length - 1] = s != null ? s.copyInline(ctx, valNeeded) : null;
        LocalMember.doneWithArguments(ctx, v);
        Type type = valNeeded ? this.type : Type.tVoid;
        InlineMethodExpression e = new InlineMethodExpression(this.where, type, this.field, new CompoundStatement(this.where, body));
        return valNeeded ? ((Expression)e).inlineValue(env, ctx) : ((Expression)e).inline(env, ctx);
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inline(env, ctx);
        }
        try {
            Statement s;
            if (this.right != null) {
                this.right = this.field.isStatic() ? this.right.inline(env, ctx) : this.right.inlineValue(env, ctx);
            }
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].inlineValue(env, ctx);
            }
            ClassDefinition ctxClass = ctx.field.getClassDefinition();
            Expression e = this;
            if (!(!env.opt() || !this.field.isInlineable(env, this.clazz.isFinal()) || this.right != null && this.right.op != 82 && !this.field.isStatic() || !ctxClass.permitInlinedAccess(env, this.field.getClassDeclaration()) || !ctxClass.permitInlinedAccess(env, this.field) || this.right != null && !ctxClass.permitInlinedAccess(env, env.getClassDeclaration(this.right.type)) || this.id != null && this.id.equals(idInit) || ctx.field.isInitializer() || !ctx.field.isMethod() || ctx.getInlineMemberContext(this.field) != null || (s = (Statement)this.field.getValue(env)) != null && s.costInline(MAXINLINECOST, env, ctx) >= MAXINLINECOST)) {
                e = this.inlineMethod(env, ctx, s, false);
            }
            return e;
        }
        catch (ClassNotFound e) {
            throw new CompilerError(e);
        }
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(env, ctx);
        }
        try {
            Statement s;
            ClassDefinition refc;
            UplevelReference r;
            if (this.right != null) {
                Expression expression = this.right = this.field.isStatic() ? this.right.inline(env, ctx) : this.right.inlineValue(env, ctx);
            }
            if (this.field.getName().equals(idInit) && (r = (refc = this.field.getClassDefinition()).getReferencesFrozen()) != null) {
                r.willCodeArguments(env, ctx);
            }
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].inlineValue(env, ctx);
            }
            ClassDefinition ctxClass = ctx.field.getClassDefinition();
            if (env.opt() && this.field.isInlineable(env, this.clazz.isFinal()) && (this.right == null || this.right.op == 82 || this.field.isStatic()) && ctxClass.permitInlinedAccess(env, this.field.getClassDeclaration()) && ctxClass.permitInlinedAccess(env, this.field) && (this.right == null || ctxClass.permitInlinedAccess(env, env.getClassDeclaration(this.right.type))) && !ctx.field.isInitializer() && ctx.field.isMethod() && ctx.getInlineMemberContext(this.field) == null && ((s = (Statement)this.field.getValue(env)) == null || s.costInline(MAXINLINECOST, env, ctx) < MAXINLINECOST)) {
                return this.inlineMethod(env, ctx, s, true);
            }
            return this;
        }
        catch (ClassNotFound e) {
            throw new CompilerError(e);
        }
    }

    @Override
    public Expression copyInline(Context ctx) {
        if (this.implementation != null) {
            return this.implementation.copyInline(ctx);
        }
        return super.copyInline(ctx);
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.costInline(thresh, env, ctx);
        }
        if (this.right != null && this.right.op == 83) {
            return thresh;
        }
        return super.costInline(thresh, env, ctx);
    }

    private Expression makeVarInits(Environment env, Context ctx) {
        ClassDefinition clazz = ctx.field.getClassDefinition();
        Expression e = null;
        for (MemberDefinition f = clazz.getFirstMember(); f != null; f = f.getNextMember()) {
            if (!f.isVariable() && !f.isInitializer() || f.isStatic()) continue;
            try {
                f.check(env);
            }
            catch (ClassNotFound ee) {
                env.error(f.getWhere(), "class.not.found", ee.name, f.getClassDefinition());
            }
            Expression val = null;
            if (f.isUplevelValue()) {
                if (f != clazz.findOuterMember()) continue;
                IdentifierExpression arg = new IdentifierExpression(this.where, f.getName());
                if (!arg.bind(env, ctx)) {
                    throw new CompilerError("bind " + arg.id);
                }
                val = arg;
            } else if (f.isInitializer()) {
                Statement s = (Statement)f.getValue();
                val = new InlineMethodExpression(this.where, Type.tVoid, f, s);
            } else {
                val = (Expression)f.getValue();
            }
            if (val == null) continue;
            long p = f.getWhere();
            Expression init = val = val.copyInline(ctx);
            if (f.isVariable()) {
                Expression v = new ThisExpression(p, ctx);
                v = new FieldExpression(p, v, f);
                init = new AssignExpression(p, v, val);
            }
            e = e == null ? init : new CommaExpression(p, e, init);
        }
        return e;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        ClassDefinition refc;
        UplevelReference r;
        if (this.implementation != null) {
            throw new CompilerError("codeValue");
        }
        int i = 0;
        if (this.field.isStatic()) {
            if (this.right != null) {
                this.right.code(env, ctx, asm);
            }
        } else if (this.right == null) {
            asm.add(this.where, 25, 0);
        } else if (this.right.op == 83) {
            this.right.codeValue(env, ctx, asm);
            if (idInit.equals(this.id) && (r = (refc = this.field.getClassDefinition()).getReferencesFrozen()) != null) {
                if (r.isClientOuterField()) {
                    this.args[i++].codeValue(env, ctx, asm);
                }
                r.codeArguments(env, ctx, asm, this.where, this.field);
            }
        } else {
            this.right.codeValue(env, ctx, asm);
        }
        while (i < this.args.length) {
            this.args[i].codeValue(env, ctx, asm);
            ++i;
        }
        if (this.field.isStatic()) {
            asm.add(this.where, 184, this.field);
        } else if (this.field.isConstructor() || this.field.isPrivate() || this.isSuper) {
            asm.add(this.where, 183, this.field);
        } else if (this.field.getClassDefinition().isInterface()) {
            asm.add(this.where, 185, this.field);
        } else {
            asm.add(this.where, 182, this.field);
        }
        if (this.right != null && this.right.op == 83 && idInit.equals(this.id) && (r = (refc = ctx.field.getClassDefinition()).getReferencesFrozen()) != null) {
            r.codeInitialization(env, ctx, asm, this.where, this.field);
        }
    }

    @Override
    public Expression firstConstructor() {
        return this.id.equals(idInit) ? this : null;
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op]);
        if (this.right != null) {
            out.print(" ");
            this.right.print(out);
        }
        out.print(" " + (this.id == null ? idInit : this.id));
        for (int i = 0; i < this.args.length; ++i) {
            out.print(" ");
            if (this.args[i] != null) {
                this.args[i].print(out);
                continue;
            }
            out.print("<null>");
        }
        out.print(")");
        if (this.implementation != null) {
            out.print("/IMPL=");
            this.implementation.print(out);
        }
    }
}

