/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.io.InputStream;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.ScannerInputReader;

public class Scanner
implements Constants {
    public static final long OFFSETINC = 1L;
    public static final long LINEINC = 0x100000000L;
    public static final int EOF = -1;
    public Environment env;
    protected ScannerInputReader in;
    public boolean scanComments = false;
    public int token;
    public long pos;
    public long prevPos;
    protected int ch;
    public char charValue;
    public int intValue;
    public long longValue;
    public float floatValue;
    public double doubleValue;
    public String stringValue;
    public Identifier idValue;
    public int radix;
    public String docComment;
    private int count;
    private char[] buffer = new char[1024];

    private void growBuffer() {
        char[] newBuffer = new char[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        this.buffer = newBuffer;
    }

    private void putc(int ch) {
        if (this.count == this.buffer.length) {
            this.growBuffer();
        }
        this.buffer[this.count++] = (char)ch;
    }

    private String bufferString() {
        return new String(this.buffer, 0, this.count);
    }

    public Scanner(Environment env, InputStream in) throws IOException {
        this.env = env;
        this.useInputStream(in);
    }

    protected void useInputStream(InputStream in) throws IOException {
        try {
            this.in = new ScannerInputReader(this.env, in);
        }
        catch (Exception e) {
            this.env.setCharacterEncoding(null);
            this.in = new ScannerInputReader(this.env, in);
        }
        this.ch = this.in.read();
        this.prevPos = this.in.pos;
        this.scan();
    }

    protected Scanner(Environment env) {
        this.env = env;
    }

    private static void defineKeyword(int val) {
        Identifier.lookup(opNames[val]).setType(val);
    }

    private void skipComment() throws IOException {
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.comment");
                    return;
                }
                case 42: {
                    this.ch = this.in.read();
                    if (this.ch != 47) continue block4;
                    this.ch = this.in.read();
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    private String scanDocComment() throws IOException {
        int c;
        ScannerInputReader in = this.in;
        char[] buffer = this.buffer;
        int count = 0;
        while ((c = in.read()) == 42) {
        }
        if (c == 47) {
            this.ch = in.read();
            return "";
        }
        if (c == 10) {
            c = in.read();
        }
        block12: while (true) {
            switch (c) {
                case 9: 
                case 32: {
                    c = in.read();
                    continue block12;
                }
            }
            if (c == 42) {
                while ((c = in.read()) == 42) {
                }
                if (c == 47) {
                    this.ch = in.read();
                    break;
                }
            }
            block14: while (true) {
                switch (c) {
                    case -1: {
                        this.env.error(this.pos, "eof.in.comment");
                        this.ch = -1;
                        break block12;
                    }
                    case 42: {
                        c = in.read();
                        if (c == 47) {
                            this.ch = in.read();
                            break block12;
                        }
                        if (count == buffer.length) {
                            this.growBuffer();
                            buffer = this.buffer;
                        }
                        buffer[count++] = 42;
                        continue block14;
                    }
                    case 10: {
                        if (count == buffer.length) {
                            this.growBuffer();
                            buffer = this.buffer;
                        }
                        buffer[count++] = 10;
                        c = in.read();
                        continue block12;
                    }
                    default: {
                        if (count == buffer.length) {
                            this.growBuffer();
                            buffer = this.buffer;
                        }
                        buffer[count++] = (char)c;
                        c = in.read();
                        continue block14;
                    }
                }
                break;
            }
            break;
        }
        if (count > 0) {
            int i;
            block15: for (i = count - 1; i > -1; --i) {
                switch (buffer[i]) {
                    case '\t': 
                    case ' ': 
                    case '*': {
                        continue block15;
                    }
                }
            }
            count = i + 1;
            return new String(buffer, 0, count);
        }
        return "";
    }

    private void scanNumber() throws IOException {
        block26: {
            boolean overflow;
            block29: {
                long value;
                block28: {
                    boolean seenDigit;
                    block27: {
                        boolean seenNonOctal;
                        block25: {
                            seenNonOctal = false;
                            overflow = false;
                            seenDigit = false;
                            this.radix = this.ch == 48 ? 8 : 10;
                            value = this.ch - 48;
                            this.count = 0;
                            this.putc(this.ch);
                            block19: while (true) {
                                this.ch = this.in.read();
                                switch (this.ch) {
                                    case 46: {
                                        if (this.radix == 16) break block19;
                                        this.scanReal();
                                        return;
                                    }
                                    case 56: 
                                    case 57: {
                                        seenNonOctal = true;
                                    }
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: {
                                        seenDigit = true;
                                        this.putc(this.ch);
                                        if (this.radix == 10) {
                                            overflow = overflow || value * 10L / 10L != value;
                                            value = value * 10L + (long)(this.ch - 48);
                                            overflow = overflow || value - 1L < -1L;
                                            continue block19;
                                        }
                                        if (this.radix == 8) {
                                            overflow = overflow || value >>> 61 != 0L;
                                            value = (value << 3) + (long)(this.ch - 48);
                                            continue block19;
                                        }
                                        overflow = overflow || value >>> 60 != 0L;
                                        value = (value << 4) + (long)(this.ch - 48);
                                        continue block19;
                                    }
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        if (this.radix != 16) {
                                            this.scanReal();
                                            return;
                                        }
                                    }
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 97: 
                                    case 98: 
                                    case 99: {
                                        seenDigit = true;
                                        this.putc(this.ch);
                                        if (this.radix != 16) break block19;
                                        overflow = overflow || value >>> 60 != 0L;
                                        value = (value << 4) + 10L + (long)Character.toLowerCase((char)this.ch) - 97L;
                                        continue block19;
                                    }
                                    case 76: 
                                    case 108: {
                                        this.ch = this.in.read();
                                        this.longValue = value;
                                        this.token = 66;
                                        break block19;
                                    }
                                    case 88: 
                                    case 120: {
                                        if (this.count != 1 || this.radix != 8) break block19;
                                        this.radix = 16;
                                        seenDigit = false;
                                        continue block19;
                                    }
                                    default: {
                                        this.intValue = (int)value;
                                        this.token = 65;
                                        break block19;
                                    }
                                }
                                break;
                            }
                            if (!Character.isJavaLetterOrDigit((char)this.ch) && this.ch != 46) break block25;
                            this.env.error(this.in.pos, "invalid.number");
                            do {
                                this.ch = this.in.read();
                            } while (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46);
                            this.intValue = 0;
                            this.token = 65;
                            break block26;
                        }
                        if (this.radix != 8 || !seenNonOctal) break block27;
                        this.intValue = 0;
                        this.token = 65;
                        this.env.error(this.pos, "invalid.octal.number");
                        break block26;
                    }
                    if (this.radix != 16 || seenDigit) break block28;
                    this.intValue = 0;
                    this.token = 65;
                    this.env.error(this.pos, "invalid.hex.number");
                    break block26;
                }
                if (this.token != 65) break block29;
                boolean bl = overflow = overflow || (value & 0xFFFFFFFF00000000L) != 0L || this.radix == 10 && value > 0x80000000L;
                if (!overflow) break block26;
                this.intValue = 0;
                switch (this.radix) {
                    case 8: {
                        this.env.error(this.pos, "overflow.int.oct");
                        break block26;
                    }
                    case 10: {
                        this.env.error(this.pos, "overflow.int.dec");
                        break block26;
                    }
                    case 16: {
                        this.env.error(this.pos, "overflow.int.hex");
                        break block26;
                    }
                    default: {
                        throw new CompilerError("invalid radix");
                    }
                }
            }
            if (overflow) {
                this.longValue = 0L;
                switch (this.radix) {
                    case 8: {
                        this.env.error(this.pos, "overflow.long.oct");
                        break;
                    }
                    case 10: {
                        this.env.error(this.pos, "overflow.long.dec");
                        break;
                    }
                    case 16: {
                        this.env.error(this.pos, "overflow.long.hex");
                        break;
                    }
                    default: {
                        throw new CompilerError("invalid radix");
                    }
                }
            }
        }
    }

    private void scanReal() throws IOException {
        char lastChar;
        boolean seenExponent = false;
        boolean isSingleFloat = false;
        if (this.ch == 46) {
            this.putc(this.ch);
            this.ch = this.in.read();
        }
        block9: while (true) {
            switch (this.ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putc(this.ch);
                    break;
                }
                case 69: 
                case 101: {
                    if (seenExponent) break block9;
                    this.putc(this.ch);
                    seenExponent = true;
                    break;
                }
                case 43: 
                case 45: {
                    lastChar = this.buffer[this.count - 1];
                    if (lastChar != 'e' && lastChar != 'E') break block9;
                    this.putc(this.ch);
                    break;
                }
                case 70: 
                case 102: {
                    this.ch = this.in.read();
                    isSingleFloat = true;
                    break block9;
                }
                case 68: 
                case 100: {
                    this.ch = this.in.read();
                }
                default: {
                    break block9;
                }
            }
            this.ch = this.in.read();
        }
        if (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46) {
            this.env.error(this.in.pos, "invalid.number");
            do {
                this.ch = this.in.read();
            } while (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46);
            this.doubleValue = 0.0;
            this.token = 68;
        } else {
            this.token = isSingleFloat ? 67 : 68;
            try {
                lastChar = this.buffer[this.count - 1];
                if (lastChar == 'e' || lastChar == 'E' || lastChar == '+' || lastChar == '-') {
                    this.env.error(this.in.pos - 1L, "float.format");
                } else if (isSingleFloat) {
                    String string = this.bufferString();
                    this.floatValue = Float.valueOf(string).floatValue();
                    if (Float.isInfinite(this.floatValue)) {
                        this.env.error(this.pos, "overflow.float");
                    } else if (this.floatValue == 0.0f && !Scanner.looksLikeZero(string)) {
                        this.env.error(this.pos, "underflow.float");
                    }
                } else {
                    String string = this.bufferString();
                    this.doubleValue = Double.valueOf(string);
                    if (Double.isInfinite(this.doubleValue)) {
                        this.env.error(this.pos, "overflow.double");
                    } else if (this.doubleValue == 0.0 && !Scanner.looksLikeZero(string)) {
                        this.env.error(this.pos, "underflow.double");
                    }
                }
            }
            catch (NumberFormatException ee) {
                this.env.error(this.pos, "float.format");
                this.doubleValue = 0.0;
                this.floatValue = 0.0f;
            }
        }
    }

    private static boolean looksLikeZero(String token) {
        int length = token.length();
        block5: for (int i = 0; i < length; ++i) {
            switch (token.charAt(i)) {
                case '\u0000': 
                case '.': {
                    continue block5;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
                case 'E': 
                case 'F': 
                case 'e': 
                case 'f': {
                    return true;
                }
            }
        }
        return true;
    }

    private int scanEscapeChar() throws IOException {
        long p = this.in.pos;
        this.ch = this.in.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n = this.ch - 48;
                block14: for (int i = 2; i > 0; --i) {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n = (n << 3) + this.ch - 48;
                            continue block14;
                        }
                        default: {
                            if (n > 255) {
                                this.env.error(p, "invalid.escape.char");
                            }
                            return n;
                        }
                    }
                }
                this.ch = this.in.read();
                if (n > 255) {
                    this.env.error(p, "invalid.escape.char");
                }
                return n;
            }
            case 114: {
                this.ch = this.in.read();
                return 13;
            }
            case 110: {
                this.ch = this.in.read();
                return 10;
            }
            case 102: {
                this.ch = this.in.read();
                return 12;
            }
            case 98: {
                this.ch = this.in.read();
                return 8;
            }
            case 116: {
                this.ch = this.in.read();
                return 9;
            }
            case 92: {
                this.ch = this.in.read();
                return 92;
            }
            case 34: {
                this.ch = this.in.read();
                return 34;
            }
            case 39: {
                this.ch = this.in.read();
                return 39;
            }
        }
        this.env.error(p, "invalid.escape.char");
        this.ch = this.in.read();
        return -1;
    }

    private void scanString() throws IOException {
        this.token = 69;
        this.count = 0;
        this.ch = this.in.read();
        block6: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 10: 
                case 13: {
                    this.ch = this.in.read();
                    this.env.error(this.pos, "newline.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 34: {
                    this.ch = this.in.read();
                    this.stringValue = this.bufferString();
                    return;
                }
                case 92: {
                    int c = this.scanEscapeChar();
                    if (c < 0) continue block6;
                    this.putc((char)c);
                    continue block6;
                }
            }
            this.putc(this.ch);
            this.ch = this.in.read();
        }
    }

    private void scanCharacter() throws IOException {
        this.token = 63;
        this.ch = this.in.read();
        switch (this.ch) {
            case 92: {
                int c = this.scanEscapeChar();
                this.charValue = (char)(c >= 0 ? c : 0);
                break;
            }
            case 39: {
                this.charValue = '\u0000';
                this.env.error(this.pos, "invalid.char.constant");
                this.ch = this.in.read();
                while (this.ch == 39) {
                    this.ch = this.in.read();
                }
                return;
            }
            case 10: 
            case 13: {
                this.charValue = '\u0000';
                this.env.error(this.pos, "invalid.char.constant");
                return;
            }
            default: {
                this.charValue = (char)this.ch;
                this.ch = this.in.read();
            }
        }
        if (this.ch != 39) {
            this.env.error(this.pos, "invalid.char.constant");
            while (true) {
                switch (this.ch) {
                    case 39: {
                        this.ch = this.in.read();
                        return;
                    }
                    case -1: 
                    case 10: 
                    case 59: {
                        return;
                    }
                }
                this.ch = this.in.read();
            }
        }
        this.ch = this.in.read();
    }

    private void scanIdentifier() throws IOException {
        this.count = 0;
        block3: while (true) {
            this.putc(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 36: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block3;
                }
            }
            if (!Character.isJavaLetterOrDigit((char)this.ch)) break;
        }
        this.idValue = Identifier.lookup(this.bufferString());
        this.token = this.idValue.getType();
    }

    public long getEndPos() {
        return this.in.pos;
    }

    public IdentifierToken getIdToken() {
        return this.token != 60 ? null : new IdentifierToken(this.pos, this.idValue);
    }

    public long scan() throws IOException {
        return this.xscan();
    }

    protected long xscan() throws IOException {
        ScannerInputReader in = this.in;
        long retPos = this.pos;
        this.prevPos = in.pos;
        this.docComment = null;
        block70: while (true) {
            this.pos = in.pos;
            switch (this.ch) {
                case -1: {
                    this.token = -1;
                    return retPos;
                }
                case 10: {
                    if (this.scanComments) {
                        this.ch = 32;
                        this.token = 146;
                        return retPos;
                    }
                }
                case 9: 
                case 12: 
                case 32: {
                    this.ch = in.read();
                    continue block70;
                }
                case 47: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 47: {
                            while ((this.ch = in.read()) != -1 && this.ch != 10) {
                            }
                            if (!this.scanComments) continue block70;
                            this.token = 146;
                            return retPos;
                        }
                        case 42: {
                            this.ch = in.read();
                            if (this.ch == 42) {
                                this.docComment = this.scanDocComment();
                            } else {
                                this.skipComment();
                            }
                            if (!this.scanComments) continue block70;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 3;
                            return retPos;
                        }
                    }
                    this.token = 31;
                    return retPos;
                }
                case 34: {
                    this.scanString();
                    return retPos;
                }
                case 39: {
                    this.scanCharacter();
                    return retPos;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.scanNumber();
                    return retPos;
                }
                case 46: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.count = 0;
                            this.putc(46);
                            this.scanReal();
                            break;
                        }
                        default: {
                            this.token = 46;
                        }
                    }
                    return retPos;
                }
                case 123: {
                    this.ch = in.read();
                    this.token = 138;
                    return retPos;
                }
                case 125: {
                    this.ch = in.read();
                    this.token = 139;
                    return retPos;
                }
                case 40: {
                    this.ch = in.read();
                    this.token = 140;
                    return retPos;
                }
                case 41: {
                    this.ch = in.read();
                    this.token = 141;
                    return retPos;
                }
                case 91: {
                    this.ch = in.read();
                    this.token = 142;
                    return retPos;
                }
                case 93: {
                    this.ch = in.read();
                    this.token = 143;
                    return retPos;
                }
                case 44: {
                    this.ch = in.read();
                    this.token = 0;
                    return retPos;
                }
                case 59: {
                    this.ch = in.read();
                    this.token = 135;
                    return retPos;
                }
                case 63: {
                    this.ch = in.read();
                    this.token = 137;
                    return retPos;
                }
                case 126: {
                    this.ch = in.read();
                    this.token = 38;
                    return retPos;
                }
                case 58: {
                    this.ch = in.read();
                    this.token = 136;
                    return retPos;
                }
                case 45: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 45: {
                            this.ch = in.read();
                            this.token = 51;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 6;
                            return retPos;
                        }
                    }
                    this.token = 30;
                    return retPos;
                }
                case 43: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 43: {
                            this.ch = in.read();
                            this.token = 50;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 5;
                            return retPos;
                        }
                    }
                    this.token = 29;
                    return retPos;
                }
                case 60: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 60: {
                            this.ch = in.read();
                            if (this.ch == 61) {
                                this.ch = in.read();
                                this.token = 7;
                                return retPos;
                            }
                            this.token = 26;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 23;
                            return retPos;
                        }
                    }
                    this.token = 24;
                    return retPos;
                }
                case 62: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 62: {
                            this.ch = in.read();
                            switch (this.ch) {
                                case 61: {
                                    this.ch = in.read();
                                    this.token = 8;
                                    return retPos;
                                }
                                case 62: {
                                    this.ch = in.read();
                                    if (this.ch == 61) {
                                        this.ch = in.read();
                                        this.token = 9;
                                        return retPos;
                                    }
                                    this.token = 28;
                                    return retPos;
                                }
                            }
                            this.token = 27;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 21;
                            return retPos;
                        }
                    }
                    this.token = 22;
                    return retPos;
                }
                case 124: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 124: {
                            this.ch = in.read();
                            this.token = 14;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 11;
                            return retPos;
                        }
                    }
                    this.token = 16;
                    return retPos;
                }
                case 38: {
                    this.ch = in.read();
                    switch (this.ch) {
                        case 38: {
                            this.ch = in.read();
                            this.token = 15;
                            return retPos;
                        }
                        case 61: {
                            this.ch = in.read();
                            this.token = 10;
                            return retPos;
                        }
                    }
                    this.token = 18;
                    return retPos;
                }
                case 61: {
                    this.ch = in.read();
                    if (this.ch == 61) {
                        this.ch = in.read();
                        this.token = 20;
                        return retPos;
                    }
                    this.token = 1;
                    return retPos;
                }
                case 37: {
                    this.ch = in.read();
                    if (this.ch == 61) {
                        this.ch = in.read();
                        this.token = 4;
                        return retPos;
                    }
                    this.token = 32;
                    return retPos;
                }
                case 94: {
                    this.ch = in.read();
                    if (this.ch == 61) {
                        this.ch = in.read();
                        this.token = 12;
                        return retPos;
                    }
                    this.token = 17;
                    return retPos;
                }
                case 33: {
                    this.ch = in.read();
                    if (this.ch == 61) {
                        this.ch = in.read();
                        this.token = 19;
                        return retPos;
                    }
                    this.token = 37;
                    return retPos;
                }
                case 42: {
                    this.ch = in.read();
                    if (this.ch == 61) {
                        this.ch = in.read();
                        this.token = 2;
                        return retPos;
                    }
                    this.token = 33;
                    return retPos;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.scanIdentifier();
                    return retPos;
                }
                case 26: {
                    this.ch = in.read();
                    if (this.ch == -1) {
                        this.token = -1;
                        return retPos;
                    }
                    this.env.error(this.pos, "funny.char");
                    this.ch = in.read();
                    continue block70;
                }
            }
            if (Character.isJavaLetter((char)this.ch)) {
                this.scanIdentifier();
                return retPos;
            }
            this.env.error(this.pos, "funny.char");
            this.ch = in.read();
        }
    }

    public void match(int open, int close) throws IOException {
        int depth = 1;
        while (true) {
            this.scan();
            if (this.token == open) {
                ++depth;
                continue;
            }
            if (this.token == close) {
                if (--depth != 0) continue;
                return;
            }
            if (this.token == -1) break;
        }
        this.env.error(this.pos, "unbalanced.paren");
    }

    static {
        Scanner.defineKeyword(92);
        Scanner.defineKeyword(90);
        Scanner.defineKeyword(91);
        Scanner.defineKeyword(93);
        Scanner.defineKeyword(94);
        Scanner.defineKeyword(95);
        Scanner.defineKeyword(96);
        Scanner.defineKeyword(97);
        Scanner.defineKeyword(98);
        Scanner.defineKeyword(99);
        Scanner.defineKeyword(100);
        Scanner.defineKeyword(101);
        Scanner.defineKeyword(102);
        Scanner.defineKeyword(103);
        Scanner.defineKeyword(104);
        Scanner.defineKeyword(70);
        Scanner.defineKeyword(71);
        Scanner.defineKeyword(72);
        Scanner.defineKeyword(73);
        Scanner.defineKeyword(74);
        Scanner.defineKeyword(75);
        Scanner.defineKeyword(76);
        Scanner.defineKeyword(77);
        Scanner.defineKeyword(78);
        Scanner.defineKeyword(25);
        Scanner.defineKeyword(80);
        Scanner.defineKeyword(81);
        Scanner.defineKeyword(49);
        Scanner.defineKeyword(82);
        Scanner.defineKeyword(83);
        Scanner.defineKeyword(84);
        Scanner.defineKeyword(110);
        Scanner.defineKeyword(111);
        Scanner.defineKeyword(112);
        Scanner.defineKeyword(113);
        Scanner.defineKeyword(114);
        Scanner.defineKeyword(115);
        Scanner.defineKeyword(144);
        Scanner.defineKeyword(120);
        Scanner.defineKeyword(121);
        Scanner.defineKeyword(122);
        Scanner.defineKeyword(124);
        Scanner.defineKeyword(125);
        Scanner.defineKeyword(126);
        Scanner.defineKeyword(127);
        Scanner.defineKeyword(130);
        Scanner.defineKeyword(129);
        Scanner.defineKeyword(128);
        Scanner.defineKeyword(131);
        Scanner.defineKeyword(123);
        Scanner.defineKeyword(58);
    }
}

