/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.util.Hashtable;
import sun.tools.java.ArrayType;
import sun.tools.java.ClassType;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.MethodType;

public class Type
implements Constants {
    private static final Hashtable<String, Type> typeHash = new Hashtable(231);
    protected int typeCode;
    protected String typeSig;
    public static final Type[] noArgs = new Type[0];
    public static final Type tError = new Type(13, "?");
    public static final Type tPackage = new Type(13, ".");
    public static final Type tNull = new Type(8, "*");
    public static final Type tVoid = new Type(11, "V");
    public static final Type tBoolean = new Type(0, "Z");
    public static final Type tByte = new Type(1, "B");
    public static final Type tChar = new Type(2, "C");
    public static final Type tShort = new Type(3, "S");
    public static final Type tInt = new Type(4, "I");
    public static final Type tFloat = new Type(6, "F");
    public static final Type tLong = new Type(5, "J");
    public static final Type tDouble = new Type(7, "D");
    public static final Type tObject = Type.tClass(idJavaLangObject);
    public static final Type tClassDesc = Type.tClass(idJavaLangClass);
    public static final Type tString = Type.tClass(idJavaLangString);
    public static final Type tCloneable = Type.tClass(idJavaLangCloneable);
    public static final Type tSerializable = Type.tClass(idJavaIoSerializable);

    protected Type(int typeCode, String typeSig) {
        this.typeCode = typeCode;
        this.typeSig = typeSig;
        typeHash.put(typeSig, this);
    }

    public final String getTypeSignature() {
        return this.typeSig;
    }

    public final int getTypeCode() {
        return this.typeCode;
    }

    public final int getTypeMask() {
        return 1 << this.typeCode;
    }

    public final boolean isType(int tc) {
        return this.typeCode == tc;
    }

    public boolean isVoidArray() {
        if (!this.isType(9)) {
            return false;
        }
        Type type = this;
        while (type.isType(9)) {
            type = type.getElementType();
        }
        return type.isType(11);
    }

    public final boolean inMask(int tm) {
        return (1 << this.typeCode & tm) != 0;
    }

    public static synchronized Type tArray(Type elem) {
        String sig = new String("[" + elem.getTypeSignature());
        Type t = typeHash.get(sig);
        if (t == null) {
            t = new ArrayType(sig, elem);
        }
        return t;
    }

    public Type getElementType() {
        throw new CompilerError("getElementType");
    }

    public int getArrayDimension() {
        return 0;
    }

    public static synchronized Type tClass(Identifier className) {
        if (className.isInner()) {
            Type t = Type.tClass(Type.mangleInnerType(className));
            if (t.getClassName() != className) {
                Type.changeClassName(t.getClassName(), className);
            }
            return t;
        }
        if (className.typeObject != null) {
            return className.typeObject;
        }
        String sig = new String("L" + className.toString().replace('.', '/') + ";");
        Type t = typeHash.get(sig);
        if (t == null) {
            t = new ClassType(sig, className);
        }
        className.typeObject = t;
        return t;
    }

    public Identifier getClassName() {
        throw new CompilerError("getClassName:" + this);
    }

    public static Identifier mangleInnerType(Identifier className) {
        if (!className.isInner()) {
            return className;
        }
        Identifier mname = Identifier.lookup(className.getFlatName().toString().replace('.', '$'));
        if (mname.isInner()) {
            throw new CompilerError("mangle " + mname);
        }
        return Identifier.lookup(className.getQualifier(), mname);
    }

    static void changeClassName(Identifier oldName, Identifier newName) {
        ((ClassType)Type.tClass((Identifier)oldName)).className = newName;
    }

    public static synchronized Type tMethod(Type ret) {
        return Type.tMethod(ret, noArgs);
    }

    public static synchronized Type tMethod(Type returnType, Type[] argTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            sb.append(argTypes[i].getTypeSignature());
        }
        sb.append(")");
        sb.append(returnType.getTypeSignature());
        String sig = sb.toString();
        Type t = typeHash.get(sig);
        if (t == null) {
            t = new MethodType(sig, returnType, argTypes);
        }
        return t;
    }

    public Type getReturnType() {
        throw new CompilerError("getReturnType");
    }

    public Type[] getArgumentTypes() {
        throw new CompilerError("getArgumentTypes");
    }

    public static synchronized Type tType(String sig) {
        Type t = typeHash.get(sig);
        if (t != null) {
            return t;
        }
        switch (sig.charAt(0)) {
            case '[': {
                return Type.tArray(Type.tType(sig.substring(1)));
            }
            case 'L': {
                return Type.tClass(Identifier.lookup(sig.substring(1, sig.length() - 1).replace('/', '.')));
            }
            case '(': {
                Type[] argv = new Type[8];
                int argc = 0;
                int i = 1;
                while (sig.charAt(i) != ')') {
                    int j = i;
                    while (sig.charAt(j) == '[') {
                        ++j;
                    }
                    if (sig.charAt(j++) == 'L') {
                        while (sig.charAt(j++) != ';') {
                        }
                    }
                    if (argc == argv.length) {
                        Type[] newargv = new Type[argc * 2];
                        System.arraycopy(argv, 0, newargv, 0, argc);
                        argv = newargv;
                    }
                    argv[argc++] = Type.tType(sig.substring(i, j));
                    i = j;
                }
                Type[] argtypes = new Type[argc];
                System.arraycopy(argv, 0, argtypes, 0, argc);
                return Type.tMethod(Type.tType(sig.substring(i + 1)), argtypes);
            }
        }
        throw new CompilerError("invalid TypeSignature:" + sig);
    }

    public boolean equalArguments(Type t) {
        return false;
    }

    public int stackSize() {
        switch (this.typeCode) {
            case 11: 
            case 13: {
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                return 1;
            }
            case 5: 
            case 7: {
                return 2;
            }
        }
        throw new CompilerError("stackSize " + this.toString());
    }

    public int getTypeCodeOffset() {
        switch (this.typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: 
            case 9: 
            case 10: {
                return 4;
            }
        }
        throw new CompilerError("invalid typecode: " + this.typeCode);
    }

    public String typeString(String id, boolean abbrev, boolean ret) {
        String s = null;
        switch (this.typeCode) {
            case 8: {
                s = "null";
                break;
            }
            case 11: {
                s = "void";
                break;
            }
            case 0: {
                s = "boolean";
                break;
            }
            case 1: {
                s = "byte";
                break;
            }
            case 2: {
                s = "char";
                break;
            }
            case 3: {
                s = "short";
                break;
            }
            case 4: {
                s = "int";
                break;
            }
            case 5: {
                s = "long";
                break;
            }
            case 6: {
                s = "float";
                break;
            }
            case 7: {
                s = "double";
                break;
            }
            case 13: {
                s = "<error>";
                if (this != tPackage) break;
                s = "<package>";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        return id.length() > 0 ? s + " " + id : s;
    }

    public String typeString(String id) {
        return this.typeString(id, false, true);
    }

    public String toString() {
        return this.typeString("", false, true);
    }
}

