/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javac;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Package;
import sun.tools.java.Type;
import sun.tools.javac.BatchParser;
import sun.tools.javac.ErrorConsumer;
import sun.tools.javac.ErrorMessage;
import sun.tools.javac.Main;
import sun.tools.javac.SourceClass;
import sun.tools.javac.SourceMember;
import sun.tools.tree.Node;

@Deprecated
public class BatchEnvironment
extends Environment
implements ErrorConsumer {
    OutputStream out;
    protected ClassPath sourcePath;
    protected ClassPath binaryPath;
    Hashtable<Identifier, Package> packages = new Hashtable(31);
    Vector<ClassDeclaration> classesOrdered = new Vector();
    Hashtable<Type, ClassDeclaration> classes = new Hashtable(351);
    public int flags;
    public short majorVersion = (short)45;
    public short minorVersion = (short)3;
    public File covFile;
    public int nerrors;
    public int nwarnings;
    public int ndeprecations;
    Vector<Object> deprecationFiles = new Vector();
    ErrorConsumer errorConsumer;
    private Set<Identifier> exemptPackages;
    String errorFileName;
    ErrorMessage errors;
    private int errorsPushed;
    public int errorLimit = 100;
    private boolean hitErrorLimit;

    public BatchEnvironment(ClassPath path) {
        this(System.out, path);
    }

    public BatchEnvironment(OutputStream out, ClassPath path) {
        this(out, path, (ErrorConsumer)null);
    }

    public BatchEnvironment(OutputStream out, ClassPath path, ErrorConsumer errorConsumer) {
        this(out, path, path, errorConsumer);
    }

    public BatchEnvironment(ClassPath sourcePath, ClassPath binaryPath) {
        this((OutputStream)System.out, sourcePath, binaryPath);
    }

    public BatchEnvironment(OutputStream out, ClassPath sourcePath, ClassPath binaryPath) {
        this(out, sourcePath, binaryPath, null);
    }

    public BatchEnvironment(OutputStream out, ClassPath sourcePath, ClassPath binaryPath, ErrorConsumer errorConsumer) {
        this.out = out;
        this.sourcePath = sourcePath;
        this.binaryPath = binaryPath;
        this.errorConsumer = errorConsumer == null ? this : errorConsumer;
    }

    static BatchEnvironment create(OutputStream out, String srcPathString, String classPathString, String sysClassPathString) {
        ClassPath[] classPaths = BatchEnvironment.classPaths(srcPathString, classPathString, sysClassPathString);
        return new BatchEnvironment(out, classPaths[0], classPaths[1]);
    }

    protected static ClassPath[] classPaths(String srcPathString, String classPathString, String sysClassPathString) {
        StringBuffer binaryPathBuffer = new StringBuffer();
        if (classPathString == null && (classPathString = System.getProperty("env.class.path")) == null) {
            classPathString = ".";
        }
        if (srcPathString == null) {
            srcPathString = classPathString;
        }
        if (sysClassPathString == null && (sysClassPathString = System.getProperty("sun.boot.class.path")) == null) {
            sysClassPathString = classPathString;
        }
        BatchEnvironment.appendPath(binaryPathBuffer, sysClassPathString);
        BatchEnvironment.appendPath(binaryPathBuffer, classPathString);
        ClassPath sourcePath = new ClassPath(srcPathString);
        ClassPath binaryPath = new ClassPath(binaryPathBuffer.toString());
        return new ClassPath[]{sourcePath, binaryPath};
    }

    private static void appendPath(StringBuffer buf, String str) {
        if (str.length() > 0) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(str);
        }
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public short getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public File getcovFile() {
        return this.covFile;
    }

    public Enumeration<ClassDeclaration> getClasses() {
        return this.classesOrdered.elements();
    }

    @Override
    public boolean isExemptPackage(Identifier id) {
        if (this.exemptPackages == null) {
            this.setExemptPackages();
        }
        return this.exemptPackages.contains(id);
    }

    private void setExemptPackages() {
        this.exemptPackages = new HashSet<Identifier>(101);
        Enumeration<ClassDeclaration> e = this.getClasses();
        while (e.hasMoreElements()) {
            SourceClass def;
            ClassDeclaration c = e.nextElement();
            if (c.getStatus() != 4 || (def = (SourceClass)c.getClassDefinition()).isLocal()) continue;
            for (Identifier pkg = def.getImports().getCurrentPackage(); pkg != idNull && this.exemptPackages.add(pkg); pkg = pkg.getQualifier()) {
            }
        }
        if (!this.exemptPackages.contains(idJavaLang)) {
            this.exemptPackages.add(idJavaLang);
            try {
                if (!this.getPackage(idJavaLang).exists()) {
                    this.error(0L, "package.not.found.strong", idJavaLang);
                    return;
                }
            }
            catch (IOException ee) {
                this.error(0L, "io.exception.package", idJavaLang);
            }
        }
    }

    @Override
    public ClassDeclaration getClassDeclaration(Identifier nm) {
        return this.getClassDeclaration(Type.tClass(nm));
    }

    @Override
    public ClassDeclaration getClassDeclaration(Type t) {
        ClassDeclaration c = this.classes.get(t);
        if (c == null) {
            c = new ClassDeclaration(t.getClassName());
            this.classes.put(t, c);
            this.classesOrdered.addElement(c);
        }
        return c;
    }

    @Override
    public boolean classExists(Identifier nm) {
        if (nm.isInner()) {
            nm = nm.getTopName();
        }
        Type t = Type.tClass(nm);
        try {
            ClassDeclaration c = this.classes.get(t);
            return c != null ? c.getName().equals(nm) : this.getPackage(nm.getQualifier()).classExists(nm.getName());
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public Package getPackage(Identifier pkg) throws IOException {
        Package p = this.packages.get(pkg);
        if (p == null) {
            p = new Package(this.sourcePath, this.binaryPath, pkg);
            this.packages.put(pkg, p);
        }
        return p;
    }

    public void parseFile(ClassFile file) throws FileNotFoundException {
        BatchParser p;
        InputStream input;
        long tm = System.currentTimeMillis();
        this.dtEnter("parseFile: PARSING SOURCE " + file);
        Environment env = new Environment(this, file);
        try {
            input = file.getInputStream();
            env.setCharacterEncoding(this.getCharacterEncoding());
            p = new BatchParser(env, input);
        }
        catch (IOException ex) {
            this.dtEvent("parseFile: IO EXCEPTION " + file);
            throw new FileNotFoundException();
        }
        try {
            p.parseFile();
        }
        catch (Exception e) {
            throw new CompilerError(e);
        }
        try {
            input.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.verbose()) {
            tm = System.currentTimeMillis() - tm;
            this.output(Main.getText("benv.parsed_in", file.getPath(), Long.toString(tm)));
        }
        if (p.classes.size() == 0) {
            p.imports.resolve(env);
        } else {
            Enumeration<SourceClass> e = p.classes.elements();
            ClassDefinition first = e.nextElement();
            if (first.isInnerClass()) {
                throw new CompilerError("BatchEnvironment, first is inner");
            }
            ClassDefinition current = first;
            while (e.hasMoreElements()) {
                ClassDefinition next = e.nextElement();
                if (next.isInnerClass()) continue;
                current.addDependency(next.getClassDeclaration());
                next.addDependency(current.getClassDeclaration());
                current = next;
            }
            if (current != first) {
                current.addDependency(first.getClassDeclaration());
                first.addDependency(current.getClassDeclaration());
            }
        }
        this.dtExit("parseFile: SOURCE PARSED " + file);
    }

    BinaryClass loadFile(ClassFile file) throws IOException {
        long tm = System.currentTimeMillis();
        InputStream input = file.getInputStream();
        BinaryClass c = null;
        this.dtEnter("loadFile: LOADING CLASSFILE " + file);
        try {
            DataInputStream is = new DataInputStream(new BufferedInputStream(input));
            c = BinaryClass.load(new Environment(this, file), is, this.loadFileFlags());
        }
        catch (ClassFormatError e) {
            this.error(0L, "class.format", file.getPath(), e.getMessage());
            this.dtExit("loadFile: CLASS FORMAT ERROR " + file);
            return null;
        }
        catch (EOFException e) {
            this.error(0L, "truncated.class", file.getPath());
            return null;
        }
        input.close();
        if (this.verbose()) {
            tm = System.currentTimeMillis() - tm;
            this.output(Main.getText("benv.loaded_in", file.getPath(), Long.toString(tm)));
        }
        this.dtExit("loadFile: CLASSFILE LOADED " + file);
        return c;
    }

    int loadFileFlags() {
        return 0;
    }

    boolean needsCompilation(Hashtable<ClassDeclaration, ClassDeclaration> check, ClassDeclaration c) {
        switch (c.getStatus()) {
            case 0: {
                this.dtEnter("needsCompilation: UNDEFINED " + c.getName());
                this.loadDefinition(c);
                return this.needsCompilation(check, c);
            }
            case 1: {
                this.dtEnter("needsCompilation: UNDECIDED " + c.getName());
                if (check.get(c) == null) {
                    check.put(c, c);
                    BinaryClass bin = (BinaryClass)c.getClassDefinition();
                    Enumeration<ClassDeclaration> e = bin.getDependencies();
                    while (e.hasMoreElements()) {
                        ClassDeclaration dep = e.nextElement();
                        if (!this.needsCompilation(check, dep)) continue;
                        c.setDefinition(bin, 3);
                        this.dtExit("needsCompilation: YES (source) " + c.getName());
                        return true;
                    }
                }
                this.dtExit("needsCompilation: NO (undecided) " + c.getName());
                return false;
            }
            case 2: {
                this.dtEnter("needsCompilation: BINARY " + c.getName());
                this.dtExit("needsCompilation: NO (binary) " + c.getName());
                return false;
            }
        }
        this.dtExit("needsCompilation: YES " + c.getName());
        return true;
    }

    @Override
    public void loadDefinition(ClassDeclaration c) {
        this.dtEnter("loadDefinition: ENTER " + c.getName() + ", status " + c.getStatus());
        switch (c.getStatus()) {
            case 0: {
                Package pkg;
                this.dtEvent("loadDefinition: STATUS IS UNDEFINED");
                Identifier nm = c.getName();
                try {
                    pkg = this.getPackage(nm.getQualifier());
                }
                catch (IOException e) {
                    c.setDefinition(null, 7);
                    this.error(0L, "io.exception", c);
                    this.dtExit("loadDefinition: IO EXCEPTION (package)");
                    return;
                }
                ClassFile binfile = pkg.getBinaryFile(nm.getName());
                if (binfile == null) {
                    c.setDefinition(null, 3);
                    this.dtExit("loadDefinition: MUST BE SOURCE (no binary) " + c.getName());
                    return;
                }
                ClassFile srcfile = pkg.getSourceFile(nm.getName());
                if (srcfile == null) {
                    this.dtEvent("loadDefinition: NO SOURCE " + c.getName());
                    BinaryClass bc = null;
                    try {
                        bc = this.loadFile(binfile);
                    }
                    catch (IOException e) {
                        c.setDefinition(null, 7);
                        this.error(0L, "io.exception", binfile);
                        this.dtExit("loadDefinition: IO EXCEPTION (binary)");
                        return;
                    }
                    if (bc != null && !bc.getName().equals(nm)) {
                        this.error(0L, "wrong.class", binfile.getPath(), c, bc);
                        bc = null;
                        this.dtEvent("loadDefinition: WRONG CLASS (binary)");
                    }
                    if (bc == null) {
                        c.setDefinition(null, 7);
                        this.dtExit("loadDefinition: NOT FOUND (source or binary)");
                        return;
                    }
                    if (bc.getSource() != null) {
                        srcfile = ClassFile.newClassFile(new File((String)bc.getSource()));
                        if ((srcfile = pkg.getSourceFile(srcfile.getName())) != null && srcfile.exists()) {
                            this.dtEvent("loadDefinition: FILENAME IN BINARY " + srcfile);
                            if (srcfile.lastModified() > binfile.lastModified()) {
                                c.setDefinition(bc, 3);
                                this.dtEvent("loadDefinition: SOURCE IS NEWER " + srcfile);
                                bc.loadNested(this);
                                this.dtExit("loadDefinition: MUST BE SOURCE " + c.getName());
                                return;
                            }
                            if (this.dependencies()) {
                                c.setDefinition(bc, 1);
                                this.dtEvent("loadDefinition: UNDECIDED " + c.getName());
                            } else {
                                c.setDefinition(bc, 2);
                                this.dtEvent("loadDefinition: MUST BE BINARY " + c.getName());
                            }
                            bc.loadNested(this);
                            this.dtExit("loadDefinition: EXIT " + c.getName() + ", status " + c.getStatus());
                            return;
                        }
                    }
                    c.setDefinition(bc, 2);
                    this.dtEvent("loadDefinition: MUST BE BINARY (no source) " + c.getName());
                    bc.loadNested(this);
                    this.dtExit("loadDefinition: EXIT " + c.getName() + ", status " + c.getStatus());
                    return;
                }
                BinaryClass bc = null;
                try {
                    if (srcfile.lastModified() > binfile.lastModified()) {
                        c.setDefinition(null, 3);
                        this.dtEvent("loadDefinition: MUST BE SOURCE (younger than binary) " + c.getName());
                        return;
                    }
                    bc = this.loadFile(binfile);
                }
                catch (IOException e) {
                    this.error(0L, "io.exception", binfile);
                    this.dtEvent("loadDefinition: IO EXCEPTION (binary)");
                }
                if (bc != null && !bc.getName().equals(nm)) {
                    this.error(0L, "wrong.class", binfile.getPath(), c, bc);
                    bc = null;
                    this.dtEvent("loadDefinition: WRONG CLASS (binary)");
                }
                if (bc != null) {
                    Identifier name = bc.getName();
                    if (name.equals(c.getName())) {
                        if (this.dependencies()) {
                            c.setDefinition(bc, 1);
                            this.dtEvent("loadDefinition: UNDECIDED " + name);
                        } else {
                            c.setDefinition(bc, 2);
                            this.dtEvent("loadDefinition: MUST BE BINARY " + name);
                        }
                    } else {
                        c.setDefinition(null, 7);
                        this.dtEvent("loadDefinition: NOT FOUND (source or binary)");
                        if (this.dependencies()) {
                            this.getClassDeclaration(name).setDefinition(bc, 1);
                            this.dtEvent("loadDefinition: UNDECIDED " + name);
                        } else {
                            this.getClassDeclaration(name).setDefinition(bc, 2);
                            this.dtEvent("loadDefinition: MUST BE BINARY " + name);
                        }
                    }
                } else {
                    c.setDefinition(null, 7);
                    this.dtEvent("loadDefinition: NOT FOUND (source or binary)");
                }
                if (bc != null && bc == c.getClassDefinition()) {
                    bc.loadNested(this);
                }
                this.dtExit("loadDefinition: EXIT " + c.getName() + ", status " + c.getStatus());
                return;
            }
            case 1: {
                this.dtEvent("loadDefinition: STATUS IS UNDECIDED");
                Hashtable<ClassDeclaration, ClassDeclaration> tab = new Hashtable<ClassDeclaration, ClassDeclaration>();
                if (!this.needsCompilation(tab, c)) {
                    Enumeration<ClassDeclaration> e = tab.keys();
                    while (e.hasMoreElements()) {
                        ClassDeclaration dep = e.nextElement();
                        if (dep.getStatus() != 1) continue;
                        dep.setDefinition(dep.getClassDefinition(), 2);
                        this.dtEvent("loadDefinition: MUST BE BINARY " + dep);
                    }
                }
                this.dtExit("loadDefinition: EXIT " + c.getName() + ", status " + c.getStatus());
                return;
            }
            case 3: {
                this.dtEvent("loadDefinition: STATUS IS SOURCE");
                ClassFile srcfile = null;
                Package pkg = null;
                if (c.getClassDefinition() != null) {
                    try {
                        pkg = this.getPackage(c.getName().getQualifier());
                        srcfile = pkg.getSourceFile((String)c.getClassDefinition().getSource());
                    }
                    catch (IOException e) {
                        this.error(0L, "io.exception", c);
                        this.dtEvent("loadDefinition: IO EXCEPTION (package)");
                    }
                    if (srcfile == null) {
                        String fn = (String)c.getClassDefinition().getSource();
                        srcfile = ClassFile.newClassFile(new File(fn));
                    }
                } else {
                    Identifier nm = c.getName();
                    try {
                        pkg = this.getPackage(nm.getQualifier());
                        srcfile = pkg.getSourceFile(nm.getName());
                    }
                    catch (IOException e) {
                        this.error(0L, "io.exception", c);
                        this.dtEvent("loadDefinition: IO EXCEPTION (package)");
                    }
                    if (srcfile == null) {
                        c.setDefinition(null, 7);
                        this.dtExit("loadDefinition: SOURCE NOT FOUND " + c.getName() + ", status " + c.getStatus());
                        return;
                    }
                }
                try {
                    this.parseFile(srcfile);
                }
                catch (FileNotFoundException e) {
                    this.error(0L, "io.exception", srcfile);
                    this.dtEvent("loadDefinition: IO EXCEPTION (source)");
                }
                if (c.getClassDefinition() == null || c.getStatus() == 3) {
                    this.error(0L, "wrong.source", srcfile.getPath(), c, pkg);
                    c.setDefinition(null, 7);
                    this.dtEvent("loadDefinition: WRONG CLASS (source) " + c.getName());
                }
                this.dtExit("loadDefinition: EXIT " + c.getName() + ", status " + c.getStatus());
                return;
            }
        }
        this.dtExit("loadDefinition: EXIT " + c.getName() + ", status " + c.getStatus());
    }

    @Override
    public ClassDefinition makeClassDefinition(Environment toplevelEnv, long where, IdentifierToken name, String doc, int modifiers, IdentifierToken superClass, IdentifierToken[] interfaces, ClassDefinition outerClass) {
        Identifier pkgNm;
        Identifier nm = name.getName();
        long nmpos = name.getWhere();
        String mangledName = null;
        ClassDefinition localContextClass = null;
        Identifier localName = null;
        if (nm.isQualified() || nm.isInner()) {
            pkgNm = nm;
        } else if ((modifiers & 0x30000) != 0) {
            localContextClass = outerClass.getTopClass();
            int i = 1;
            while (localContextClass.getLocalClass(mangledName = i + (nm.equals(idNull) ? "" : "$" + nm)) != null) {
                ++i;
            }
            Identifier outerNm = localContextClass.getName();
            pkgNm = Identifier.lookupInner(outerNm, Identifier.lookup(mangledName));
            localName = (modifiers & 0x10000) != 0 ? idNull : nm;
        } else {
            pkgNm = outerClass != null ? Identifier.lookupInner(outerClass.getName(), nm) : nm;
        }
        ClassDeclaration c = toplevelEnv.getClassDeclaration(pkgNm);
        if (c.isDefined()) {
            toplevelEnv.error(nmpos, "class.multidef", c.getName(), c.getClassDefinition().getSource());
            c = new ClassDeclaration(pkgNm);
        }
        if (superClass == null && !pkgNm.equals(idJavaLangObject)) {
            superClass = new IdentifierToken(idJavaLangObject);
        }
        SourceClass sourceClass = new SourceClass(toplevelEnv, where, c, doc, modifiers, superClass, interfaces, (SourceClass)outerClass, localName);
        if (outerClass != null) {
            outerClass.addMember(toplevelEnv, new SourceMember(sourceClass));
            if ((modifiers & 0x30000) != 0) {
                localContextClass.addLocalClass(sourceClass, mangledName);
            }
        }
        return sourceClass;
    }

    @Override
    public MemberDefinition makeMemberDefinition(Environment origEnv, long where, ClassDefinition clazz, String doc, int modifiers, Type type, Identifier name, IdentifierToken[] argNames, IdentifierToken[] expIds, Object value) {
        this.dtEvent("makeMemberDefinition: " + name + " IN " + clazz);
        Vector<MemberDefinition> v = null;
        if (argNames != null) {
            v = new Vector<MemberDefinition>(argNames.length);
            for (int i = 0; i < argNames.length; ++i) {
                v.addElement((MemberDefinition)((Object)argNames[i]));
            }
        }
        SourceMember f = new SourceMember(where, clazz, doc, modifiers, type, name, v, expIds, (Node)value);
        clazz.addMember(origEnv, f);
        return f;
    }

    @Override
    public void shutdown() {
        try {
            if (this.sourcePath != null) {
                this.sourcePath.close();
            }
            if (this.binaryPath != null && this.binaryPath != this.sourcePath) {
                this.binaryPath.close();
            }
        }
        catch (IOException ee) {
            this.output(Main.getText("benv.failed_to_close_class_path", ee.toString()));
        }
        this.sourcePath = null;
        this.binaryPath = null;
        super.shutdown();
    }

    public String errorString(String err, Object arg1, Object arg2, Object arg3) {
        String key = null;
        key = err.startsWith("warn.") ? "javac.err." + err.substring(5) : "javac.err." + err;
        return Main.getText(key, arg1 != null ? arg1.toString() : null, arg2 != null ? arg2.toString() : null, arg3 != null ? arg3.toString() : null);
    }

    protected boolean insertError(long where, String message) {
        if (this.errors == null || this.errors.where > where) {
            ErrorMessage newMsg = new ErrorMessage(where, message);
            newMsg.next = this.errors;
            this.errors = newMsg;
        } else {
            ErrorMessage next;
            if (this.errors.where == where && this.errors.message.equals(message)) {
                return false;
            }
            ErrorMessage current = this.errors;
            while ((next = current.next) != null && next.where < where) {
                current = next;
            }
            while ((next = current.next) != null && next.where == where) {
                if (next.message.equals(message)) {
                    return false;
                }
                current = next;
            }
            ErrorMessage newMsg = new ErrorMessage(where, message);
            newMsg.next = current.next;
            current.next = newMsg;
        }
        return true;
    }

    @Override
    public void pushError(String errorFileName, int line, String message, String referenceText, String referenceTextPointer) {
        int limit = this.errorLimit + this.nwarnings;
        if (++this.errorsPushed >= limit && this.errorLimit >= 0) {
            if (!this.hitErrorLimit) {
                this.hitErrorLimit = true;
                this.output(this.errorString("too.many.errors", this.errorLimit, null, null));
            }
            return;
        }
        if (errorFileName.endsWith(".java")) {
            this.output(errorFileName + ":" + line + ": " + message);
            this.output(referenceText);
            this.output(referenceTextPointer);
        } else {
            this.output(errorFileName + ": " + message);
        }
    }

    public void flushErrors() {
        if (this.errors == null) {
            return;
        }
        boolean inputAvail = false;
        char[] data = null;
        int dataLength = 0;
        try {
            FileInputStream in = new FileInputStream(this.errorFileName);
            data = new char[in.available()];
            InputStreamReader reader = this.getCharacterEncoding() != null ? new InputStreamReader((InputStream)in, this.getCharacterEncoding()) : new InputStreamReader(in);
            dataLength = reader.read(data);
            reader.close();
            inputAvail = true;
        }
        catch (IOException e) {
            // empty catch block
        }
        ErrorMessage msg = this.errors;
        while (msg != null) {
            int ln = (int)(msg.where >>> 32);
            int off = (int)(msg.where & 0xFFFFFFFFL);
            if (off > dataLength) {
                off = dataLength;
            }
            String referenceString = "";
            String markerString = "";
            if (inputAvail) {
                int j;
                int i;
                for (i = off; i > 0 && data[i - 1] != '\n' && data[i - 1] != '\r'; --i) {
                }
                for (j = off; j < dataLength && data[j] != '\n' && data[j] != '\r'; ++j) {
                }
                referenceString = new String(data, i, j - i);
                char[] strdata = new char[off - i + 1];
                for (j = i; j < off; ++j) {
                    strdata[j - i] = data[j] == '\t' ? 9 : 32;
                }
                strdata[off - i] = 94;
                markerString = new String(strdata);
            }
            this.errorConsumer.pushError(this.errorFileName, ln, msg.message, referenceString, markerString);
            msg = msg.next;
        }
        this.errors = null;
    }

    public void reportError(Object src, long where, String err, String msg) {
        if (src == null) {
            if (this.errorFileName != null) {
                this.flushErrors();
                this.errorFileName = null;
            }
            if (err.startsWith("warn.")) {
                if (this.warnings()) {
                    ++this.nwarnings;
                    this.output(msg);
                }
                return;
            }
            this.output("error: " + msg);
            ++this.nerrors;
            this.flags |= 0x10000;
        } else if (src instanceof String) {
            String fileName = (String)src;
            if (!fileName.equals(this.errorFileName)) {
                this.flushErrors();
                this.errorFileName = fileName;
            }
            if (err.startsWith("warn.")) {
                if (err.indexOf("is.deprecated") >= 0) {
                    if (!this.deprecationFiles.contains(src)) {
                        this.deprecationFiles.addElement(src);
                    }
                    if (this.deprecation()) {
                        if (this.insertError(where, msg)) {
                            ++this.ndeprecations;
                        }
                    } else {
                        ++this.ndeprecations;
                    }
                } else if (this.warnings()) {
                    if (this.insertError(where, msg)) {
                        ++this.nwarnings;
                    }
                } else {
                    ++this.nwarnings;
                }
            } else if (this.insertError(where, msg)) {
                ++this.nerrors;
                this.flags |= 0x10000;
            }
        } else if (src instanceof ClassFile) {
            this.reportError(((ClassFile)src).getPath(), where, err, msg);
        } else if (src instanceof Identifier) {
            this.reportError(src.toString(), where, err, msg);
        } else if (src instanceof ClassDeclaration) {
            try {
                this.reportError(((ClassDeclaration)src).getClassDefinition(this), where, err, msg);
            }
            catch (ClassNotFound e) {
                this.reportError(((ClassDeclaration)src).getName(), where, err, msg);
            }
        } else if (src instanceof ClassDefinition) {
            ClassDefinition c = (ClassDefinition)src;
            if (!err.startsWith("warn.")) {
                c.setError();
            }
            this.reportError(c.getSource(), where, err, msg);
        } else if (src instanceof MemberDefinition) {
            this.reportError(((MemberDefinition)src).getClassDeclaration(), where, err, msg);
        } else {
            this.output(src + ":error=" + err + ":" + msg);
        }
    }

    @Override
    public void error(Object source, long where, String err, Object arg1, Object arg2, Object arg3) {
        if (this.errorsPushed >= this.errorLimit + this.nwarnings) {
            return;
        }
        if (System.getProperty("javac.dump.stack") != null) {
            this.output("javac.err." + err + ": " + this.errorString(err, arg1, arg2, arg3));
            new Exception("Stack trace").printStackTrace(new PrintStream(this.out));
        }
        this.reportError(source, where, err, this.errorString(err, arg1, arg2, arg3));
    }

    @Override
    public void output(String msg) {
        PrintStream out = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        out.println(msg);
    }
}

