/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.ConvertExpression;
import sun.tools.tree.Expression;

public class Node
implements Constants,
Cloneable {
    int op;
    long where;

    Node(int op, long where) {
        this.op = op;
        this.where = where;
    }

    public int getOp() {
        return this.op;
    }

    public long getWhere() {
        return this.where;
    }

    public Expression convert(Environment env, Context ctx, Type t, Expression e) {
        if (e.type.isType(13) || t.isType(13)) {
            return e;
        }
        if (e.type.equals(t)) {
            return e;
        }
        try {
            if (e.fitsType(env, ctx, t)) {
                return new ConvertExpression(this.where, t, e);
            }
            if (env.explicitCast(e.type, t)) {
                env.error(this.where, "explicit.cast.needed", opNames[this.op], e.type, t);
                return new ConvertExpression(this.where, t, e);
            }
        }
        catch (ClassNotFound ee) {
            env.error(this.where, "class.not.found", ee.name, opNames[this.op]);
        }
        env.error(this.where, "incompatible.type", opNames[this.op], e.type, t);
        return new ConvertExpression(this.where, Type.tError, e);
    }

    public void print(PrintStream out) {
        throw new CompilerError("print");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.print(new PrintStream(bos));
        return bos.toString();
    }
}

