/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CompoundStatement;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.ExpressionStatement;
import sun.tools.tree.FinallyStatement;
import sun.tools.tree.InlineReturnStatement;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.SynchronizedStatement;
import sun.tools.tree.Vset;

public class ReturnStatement
extends Statement {
    Expression expr;

    public ReturnStatement(long where, Expression expr) {
        super(100, where);
        this.expr = expr;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        CheckContext exitctx;
        CheckContext mctx;
        this.checkLabel(env, ctx);
        vset = this.reach(env, vset);
        if (this.expr != null) {
            vset = this.expr.checkValue(env, ctx, vset, exp);
        }
        if (ctx.field.isInitializer()) {
            env.error(this.where, "return.inside.static.initializer");
            return DEAD_END;
        }
        if (ctx.field.getType().getReturnType().isType(11)) {
            if (this.expr != null) {
                if (ctx.field.isConstructor()) {
                    env.error(this.where, "return.with.value.constr", ctx.field);
                } else {
                    env.error(this.where, "return.with.value", ctx.field);
                }
                this.expr = null;
            }
        } else if (this.expr == null) {
            env.error(this.where, "return.without.value", ctx.field);
        } else {
            this.expr = this.convert(env, ctx, ctx.field.getType().getReturnType(), this.expr);
        }
        if ((mctx = ctx.getReturnContext()) != null) {
            mctx.vsBreak = mctx.vsBreak.join(vset);
        }
        if ((exitctx = ctx.getTryExitContext()) != null) {
            exitctx.vsTryExit = exitctx.vsTryExit.join(vset);
        }
        if (this.expr != null) {
            Node outerFinallyNode = null;
            Context c = ctx;
            while (c != null) {
                if (c.node != null) {
                    if (c.node.op == 47) break;
                    if (c.node.op == 126) {
                        outerFinallyNode = c.node;
                        break;
                    }
                    if (c.node.op == 103 && ((CheckContext)c).vsContinue != null) {
                        outerFinallyNode = c.node;
                    }
                }
                c = c.prev;
            }
            if (outerFinallyNode != null) {
                if (outerFinallyNode.op == 103) {
                    ((FinallyStatement)outerFinallyNode).needReturnSlot = true;
                } else {
                    ((SynchronizedStatement)outerFinallyNode).needReturnSlot = true;
                }
            }
        }
        return DEAD_END;
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        if (this.expr != null) {
            this.expr = this.expr.inlineValue(env, ctx);
        }
        return this;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + (this.expr != null ? this.expr.costInline(thresh, env, ctx) : 0);
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        Expression e;
        Expression expression = e = this.expr != null ? this.expr.copyInline(ctx) : null;
        if (!valNeeded && e != null) {
            Statement[] body = new Statement[]{new ExpressionStatement(this.where, e), new InlineReturnStatement(this.where, null)};
            return new CompoundStatement(this.where, body);
        }
        return new InlineReturnStatement(this.where, e);
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        if (this.expr == null) {
            this.codeFinally(env, ctx, asm, null, null);
            asm.add(this.where, 177);
        } else {
            this.expr.codeValue(env, ctx, asm);
            this.codeFinally(env, ctx, asm, null, this.expr.type);
            asm.add(this.where, 172 + this.expr.type.getTypeCodeOffset());
        }
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("return");
        if (this.expr != null) {
            out.print(" ");
            this.expr.print(out);
        }
        out.print(";");
    }
}

