/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.BooleanExpression;
import sun.tools.tree.Context;
import sun.tools.tree.DoubleExpression;
import sun.tools.tree.Expression;
import sun.tools.tree.FloatExpression;
import sun.tools.tree.IntegerExpression;
import sun.tools.tree.LongExpression;
import sun.tools.tree.StringExpression;
import sun.tools.tree.Vset;

public class UnaryExpression
extends Expression {
    Expression right;

    UnaryExpression(int op, long where, Type type, Expression right) {
        super(op, where, type);
        this.right = right;
    }

    @Override
    public Expression order() {
        if (this.precedence() > this.right.precedence()) {
            UnaryExpression e = (UnaryExpression)this.right;
            this.right = e.right;
            e.right = this.order();
            return e;
        }
        return this;
    }

    void selectType(Environment env, Context ctx, int tm) {
        throw new CompilerError("selectType: " + opNames[this.op]);
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.right.checkValue(env, ctx, vset, exp);
        int tm = this.right.type.getTypeMask();
        this.selectType(env, ctx, tm);
        if ((tm & 0x2000) == 0 && this.type.isType(13)) {
            env.error(this.where, "invalid.arg", opNames[this.op]);
        }
        return vset;
    }

    @Override
    public boolean isConstant() {
        switch (this.op) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 55: 
            case 56: {
                return this.right.isConstant();
            }
        }
        return false;
    }

    Expression eval(int a) {
        return this;
    }

    Expression eval(long a) {
        return this;
    }

    Expression eval(float a) {
        return this;
    }

    Expression eval(double a) {
        return this;
    }

    Expression eval(boolean a) {
        return this;
    }

    Expression eval(String a) {
        return this;
    }

    @Override
    Expression eval() {
        switch (this.right.op) {
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                return this.eval(((IntegerExpression)this.right).value);
            }
            case 66: {
                return this.eval(((LongExpression)this.right).value);
            }
            case 67: {
                return this.eval(((FloatExpression)this.right).value);
            }
            case 68: {
                return this.eval(((DoubleExpression)this.right).value);
            }
            case 61: {
                return this.eval(((BooleanExpression)this.right).value);
            }
            case 69: {
                return this.eval(((StringExpression)this.right).value);
            }
        }
        return this;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        return this.right.inline(env, ctx);
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        this.right = this.right.inlineValue(env, ctx);
        try {
            return this.eval().simplify();
        }
        catch (ArithmeticException e) {
            return this;
        }
    }

    @Override
    public Expression copyInline(Context ctx) {
        UnaryExpression e = (UnaryExpression)this.clone();
        if (this.right != null) {
            e.right = this.right.copyInline(ctx);
        }
        return e;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + this.right.costInline(thresh, env, ctx);
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        this.right.print(out);
        out.print(")");
    }
}

