/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.asm.Assembler;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.AssignExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.LocalMember;

public class UplevelReference
implements Constants {
    ClassDefinition client;
    LocalMember target;
    LocalMember localArgument;
    MemberDefinition localField;
    UplevelReference next;

    public UplevelReference(ClassDefinition client, LocalMember target) {
        Identifier valName;
        this.client = client;
        this.target = target;
        if (target.getName().equals(idThis)) {
            ClassDefinition tc = target.getClassDefinition();
            int depth = 0;
            ClassDefinition pd = tc;
            while (!pd.isTopLevel()) {
                ++depth;
                pd = pd.getOuterClass();
            }
            valName = Identifier.lookup("this$" + depth);
        } else {
            valName = Identifier.lookup("val$" + target.getName());
        }
        Identifier base = valName;
        int tick = 0;
        while (true) {
            boolean failed = client.getFirstMatch(valName) != null;
            UplevelReference r = client.getReferences();
            while (r != null) {
                if (r.target.getName().equals(valName)) {
                    failed = true;
                }
                r = r.next;
            }
            if (!failed) break;
            valName = Identifier.lookup(base + "$" + ++tick);
        }
        this.localArgument = new LocalMember(target.getWhere(), client, 524304, target.getType(), valName);
    }

    public UplevelReference insertInto(UplevelReference references) {
        if (references == null || this.isEarlierThan(references)) {
            this.next = references;
            return this;
        }
        UplevelReference prev = references;
        while (prev.next != null && !this.isEarlierThan(prev.next)) {
            prev = prev.next;
        }
        this.next = prev.next;
        prev.next = this;
        return references;
    }

    public final boolean isEarlierThan(UplevelReference other) {
        if (this.isClientOuterField()) {
            return true;
        }
        if (other.isClientOuterField()) {
            return false;
        }
        LocalMember target2 = other.target;
        Identifier name = this.target.getName();
        Identifier name2 = target2.getName();
        int cmp = name.toString().compareTo(name2.toString());
        if (cmp != 0) {
            return cmp < 0;
        }
        Identifier cname = this.target.getClassDefinition().getName();
        Identifier cname2 = target2.getClassDefinition().getName();
        int ccmp = cname.toString().compareTo(cname2.toString());
        return ccmp < 0;
    }

    public final LocalMember getTarget() {
        return this.target;
    }

    public final LocalMember getLocalArgument() {
        return this.localArgument;
    }

    public final MemberDefinition getLocalField() {
        return this.localField;
    }

    public final MemberDefinition getLocalField(Environment env) {
        if (this.localField == null) {
            this.makeLocalField(env);
        }
        return this.localField;
    }

    public final ClassDefinition getClient() {
        return this.client;
    }

    public final UplevelReference getNext() {
        return this.next;
    }

    public boolean isClientOuterField() {
        MemberDefinition outerf = this.client.findOuterMember();
        return outerf != null && this.localField == outerf;
    }

    public boolean localArgumentAvailable(Environment env, Context ctx) {
        MemberDefinition reff = ctx.field;
        if (reff.getClassDefinition() != this.client) {
            throw new CompilerError("localArgumentAvailable");
        }
        return reff.isConstructor() || reff.isVariable() || reff.isInitializer();
    }

    public void noteReference(Environment env, Context ctx) {
        if (this.localField == null && !this.localArgumentAvailable(env, ctx)) {
            this.makeLocalField(env);
        }
    }

    private void makeLocalField(Environment env) {
        this.client.referencesMustNotBeFrozen();
        int mod = 524306;
        this.localField = env.makeMemberDefinition(env, this.localArgument.getWhere(), this.client, null, mod, this.localArgument.getType(), this.localArgument.getName(), null, null, null);
    }

    public Expression makeLocalReference(Environment env, Context ctx) {
        if (ctx.field.getClassDefinition() != this.client) {
            throw new CompilerError("makeLocalReference");
        }
        if (this.localArgumentAvailable(env, ctx)) {
            return new IdentifierExpression(0L, this.localArgument);
        }
        return this.makeFieldReference(env, ctx);
    }

    public Expression makeFieldReference(Environment env, Context ctx) {
        Expression e = ctx.findOuterLink(env, 0L, this.localField);
        return new FieldExpression(0L, e, this.localField);
    }

    public void willCodeArguments(Environment env, Context ctx) {
        if (!this.isClientOuterField()) {
            ctx.noteReference(env, this.target);
        }
        if (this.next != null) {
            this.next.willCodeArguments(env, ctx);
        }
    }

    public void codeArguments(Environment env, Context ctx, Assembler asm, long where, MemberDefinition conField) {
        if (!this.isClientOuterField()) {
            Expression e = ctx.makeReference(env, this.target);
            e.codeValue(env, ctx, asm);
        }
        if (this.next != null) {
            this.next.codeArguments(env, ctx, asm, where, conField);
        }
    }

    public void codeInitialization(Environment env, Context ctx, Assembler asm, long where, MemberDefinition conField) {
        if (this.localField != null && !this.isClientOuterField()) {
            Expression e = ctx.makeReference(env, this.target);
            Expression f = this.makeFieldReference(env, ctx);
            e = new AssignExpression(e.getWhere(), f, e);
            e.type = this.localField.getType();
            e.code(env, ctx, asm);
        }
        if (this.next != null) {
            this.next.codeInitialization(env, ctx, asm, where, conField);
        }
    }

    public String toString() {
        return "[" + this.localArgument + " in " + this.client + "]";
    }
}

