/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import com.sun.corba.ee.impl.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.RMIConstants;
import sun.rmi.rmic.RemoteClass;
import sun.rmi.rmic.Util;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RMIGenerator
implements RMIConstants,
Generator {
    private static final Hashtable<String, Integer> versionOptions = new Hashtable();
    private BatchEnvironment env;
    private RemoteClass remoteClass;
    private int version;
    private RemoteClass.Method[] remoteMethods;
    private Identifier remoteClassName;
    private Identifier stubClassName;
    private Identifier skeletonClassName;
    private ClassDefinition cdef;
    private File destDir;
    private File stubFile;
    private File skeletonFile;
    private String[] methodFieldNames;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;
    private ClassDefinition defRuntimeException;

    public RMIGenerator() {
        this.version = 3;
    }

    @Override
    public boolean parseArgs(String[] argv, Main main) {
        String explicitVersion = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg;
            if (argv[i] == null || !versionOptions.containsKey(arg = argv[i].toLowerCase())) continue;
            if (explicitVersion != null && !explicitVersion.equals(arg)) {
                main.error("rmic.cannot.use.both", explicitVersion, arg);
                return false;
            }
            explicitVersion = arg;
            this.version = versionOptions.get(arg);
            argv[i] = null;
        }
        return true;
    }

    @Override
    public void generate(BatchEnvironment env, ClassDefinition cdef, File destDir) {
        RMIGenerator gen;
        RemoteClass remoteClass = RemoteClass.forClass(env, cdef);
        if (remoteClass == null) {
            return;
        }
        try {
            gen = new RMIGenerator(env, cdef, destDir, remoteClass, this.version);
        }
        catch (ClassNotFound e) {
            env.error(0L, "rmic.class.not.found", e.name);
            return;
        }
        gen.generate();
    }

    private void generate() {
        IndentingWriter out;
        this.env.addGeneratedFile(this.stubFile);
        try {
            out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.stubFile)));
            this.writeStub(out);
            out.close();
            if (this.env.verbose()) {
                this.env.output(Main.getText("rmic.wrote", this.stubFile.getPath()));
            }
            this.env.parseFile(ClassFile.newClassFile(this.stubFile));
        }
        catch (IOException e) {
            this.env.error(0L, "cant.write", this.stubFile.toString());
            return;
        }
        if (this.version == 1 || this.version == 2) {
            this.env.addGeneratedFile(this.skeletonFile);
            try {
                out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.skeletonFile)));
                this.writeSkeleton(out);
                out.close();
                if (this.env.verbose()) {
                    this.env.output(Main.getText("rmic.wrote", this.skeletonFile.getPath()));
                }
                this.env.parseFile(ClassFile.newClassFile(this.skeletonFile));
            }
            catch (IOException e) {
                this.env.error(0L, "cant.write", this.stubFile.toString());
                return;
            }
        } else {
            File outputDir = Util.getOutputDirectoryFor(this.remoteClassName, this.destDir, this.env);
            File skeletonClassFile = new File(outputDir, this.skeletonClassName.getName().toString() + ".class");
            this.skeletonFile.delete();
            skeletonClassFile.delete();
        }
    }

    protected static File sourceFileForClass(Identifier className, Identifier outputClassName, File destDir, BatchEnvironment env) {
        String classNameStr;
        File temp;
        File packageDir = Util.getOutputDirectoryFor(className, destDir, env);
        String outputName = Names.mangleClass(outputClassName).getName().toString();
        if (outputName.endsWith("_Skel") && (temp = new File(packageDir, Utility.tieName((String)(classNameStr = className.getName().toString())) + ".class")).exists() && !env.getMain().iiopGeneration) {
            env.error(0L, "warn.rmic.tie.found", classNameStr, temp.getAbsolutePath());
        }
        String outputFileName = outputName + ".java";
        return new File(packageDir, outputFileName);
    }

    private RMIGenerator(BatchEnvironment env, ClassDefinition cdef, File destDir, RemoteClass remoteClass, int version) throws ClassNotFound {
        this.destDir = destDir;
        this.cdef = cdef;
        this.env = env;
        this.remoteClass = remoteClass;
        this.version = version;
        this.remoteMethods = remoteClass.getRemoteMethods();
        this.remoteClassName = remoteClass.getName();
        this.stubClassName = Names.stubFor(this.remoteClassName);
        this.skeletonClassName = Names.skeletonFor(this.remoteClassName);
        this.methodFieldNames = RMIGenerator.nameMethodFields(this.remoteMethods);
        this.stubFile = RMIGenerator.sourceFileForClass(this.remoteClassName, this.stubClassName, destDir, env);
        this.skeletonFile = RMIGenerator.sourceFileForClass(this.remoteClassName, this.skeletonClassName, destDir, env);
        this.defException = env.getClassDeclaration(idJavaLangException).getClassDefinition(env);
        this.defRemoteException = env.getClassDeclaration(idRemoteException).getClassDefinition(env);
        this.defRuntimeException = env.getClassDeclaration(idJavaLangRuntimeException).getClassDefinition(env);
    }

    private void writeStub(IndentingWriter p) throws IOException {
        int i;
        p.pln("// Stub class generated by rmic, do not edit.");
        p.pln("// Contents subject to change without notice.");
        p.pln();
        if (this.remoteClassName.isQualified()) {
            p.pln("package " + this.remoteClassName.getQualifier() + ";");
            p.pln();
        }
        p.plnI("public final class " + Names.mangleClass(this.stubClassName.getName()));
        p.pln("extends " + idRemoteStub);
        ClassDefinition[] remoteInterfaces = this.remoteClass.getRemoteInterfaces();
        if (remoteInterfaces.length > 0) {
            p.p("implements ");
            for (i = 0; i < remoteInterfaces.length; ++i) {
                if (i > 0) {
                    p.p(", ");
                }
                p.p(remoteInterfaces[i].getName().toString());
            }
            p.pln();
        }
        p.pOlnI("{");
        if (this.version == 1 || this.version == 2) {
            this.writeOperationsArray(p);
            p.pln();
            this.writeInterfaceHash(p);
            p.pln();
        }
        if (this.version == 2 || this.version == 3) {
            p.pln("private static final long serialVersionUID = 2;");
            p.pln();
            if (this.methodFieldNames.length > 0) {
                if (this.version == 2) {
                    p.pln("private static boolean useNewInvoke;");
                }
                this.writeMethodFieldDeclarations(p);
                p.pln();
                p.plnI("static {");
                p.plnI("try {");
                if (this.version == 2) {
                    p.plnI(idRemoteRef + ".class.getMethod(\"invoke\",");
                    p.plnI("new java.lang.Class[] {");
                    p.pln(idRemote + ".class,");
                    p.pln("java.lang.reflect.Method.class,");
                    p.pln("java.lang.Object[].class,");
                    p.pln("long.class");
                    p.pOln("});");
                    p.pO();
                    p.pln("useNewInvoke = true;");
                }
                this.writeMethodFieldInitializers(p);
                p.pOlnI("} catch (java.lang.NoSuchMethodException e) {");
                if (this.version == 2) {
                    p.pln("useNewInvoke = false;");
                } else {
                    p.plnI("throw new java.lang.NoSuchMethodError(");
                    p.pln("\"stub class initialization failed\");");
                    p.pO();
                }
                p.pOln("}");
                p.pOln("}");
                p.pln();
            }
        }
        this.writeStubConstructors(p);
        p.pln();
        if (this.remoteMethods.length > 0) {
            p.pln("// methods from remote interfaces");
            for (i = 0; i < this.remoteMethods.length; ++i) {
                p.pln();
                this.writeStubMethod(p, i);
            }
        }
        p.pOln("}");
    }

    private void writeStubConstructors(IndentingWriter p) throws IOException {
        p.pln("// constructors");
        if (this.version == 1 || this.version == 2) {
            p.plnI("public " + Names.mangleClass(this.stubClassName.getName()) + "() {");
            p.pln("super();");
            p.pOln("}");
        }
        p.plnI("public " + Names.mangleClass(this.stubClassName.getName()) + "(" + idRemoteRef + " ref) {");
        p.pln("super(ref);");
        p.pOln("}");
    }

    private void writeStubMethod(IndentingWriter p, int opnum) throws IOException {
        int i;
        RemoteClass.Method method = this.remoteMethods[opnum];
        Identifier methodName = method.getName();
        Type methodType = method.getType();
        Type[] paramTypes = methodType.getArgumentTypes();
        String[] paramNames = RMIGenerator.nameParameters(paramTypes);
        Type returnType = methodType.getReturnType();
        ClassDeclaration[] exceptions = method.getExceptions();
        p.pln("// implementation of " + methodType.typeString(methodName.toString(), true, false));
        p.p("public " + returnType + " " + methodName + "(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(paramTypes[i] + " " + paramNames[i]);
        }
        p.plnI(")");
        if (exceptions.length > 0) {
            p.p("throws ");
            for (i = 0; i < exceptions.length; ++i) {
                if (i > 0) {
                    p.p(", ");
                }
                p.p(exceptions[i].getName().toString());
            }
            p.pln();
        }
        p.pOlnI("{");
        Vector<ClassDefinition> catchList = this.computeUniqueCatchList(exceptions);
        if (catchList.size() > 0) {
            p.plnI("try {");
        }
        if (this.version == 2) {
            p.plnI("if (useNewInvoke) {");
        }
        if (this.version == 2 || this.version == 3) {
            if (!returnType.isType(11)) {
                p.p("Object $result = ");
            }
            p.p("ref.invoke(this, " + this.methodFieldNames[opnum] + ", ");
            if (paramTypes.length > 0) {
                p.p("new java.lang.Object[] {");
                for (int i2 = 0; i2 < paramTypes.length; ++i2) {
                    if (i2 > 0) {
                        p.p(", ");
                    }
                    p.p(RMIGenerator.wrapArgumentCode(paramTypes[i2], paramNames[i2]));
                }
                p.p("}");
            } else {
                p.p("null");
            }
            p.pln(", " + method.getMethodHash() + "L);");
            if (!returnType.isType(11)) {
                p.pln("return " + RMIGenerator.unwrapArgumentCode(returnType, "$result") + ";");
            }
        }
        if (this.version == 2) {
            p.pOlnI("} else {");
        }
        if (this.version == 1 || this.version == 2) {
            p.pln(idRemoteCall + " call = ref.newCall((" + idRemoteObject + ") this, operations, " + opnum + ", interfaceHash);");
            if (paramTypes.length > 0) {
                p.plnI("try {");
                p.pln("java.io.ObjectOutput out = call.getOutputStream();");
                RMIGenerator.writeMarshalArguments(p, "out", paramTypes, paramNames);
                p.pOlnI("} catch (java.io.IOException e) {");
                p.pln("throw new " + idMarshalException + "(\"error marshalling arguments\", e);");
                p.pOln("}");
            }
            p.pln("ref.invoke(call);");
            if (returnType.isType(11)) {
                p.pln("ref.done(call);");
            } else {
                p.pln(returnType + " $result;");
                p.plnI("try {");
                p.pln("java.io.ObjectInput in = call.getInputStream();");
                boolean objectRead = RMIGenerator.writeUnmarshalArgument(p, "in", returnType, "$result");
                p.pln(";");
                p.pOlnI("} catch (java.io.IOException e) {");
                p.pln("throw new " + idUnmarshalException + "(\"error unmarshalling return\", e);");
                if (objectRead) {
                    p.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                    p.pln("throw new " + idUnmarshalException + "(\"error unmarshalling return\", e);");
                }
                p.pOlnI("} finally {");
                p.pln("ref.done(call);");
                p.pOln("}");
                p.pln("return $result;");
            }
        }
        if (this.version == 2) {
            p.pOln("}");
        }
        if (catchList.size() > 0) {
            Enumeration<ClassDefinition> enumeration = catchList.elements();
            while (enumeration.hasMoreElements()) {
                ClassDefinition def = enumeration.nextElement();
                p.pOlnI("} catch (" + def.getName() + " e) {");
                p.pln("throw e;");
            }
            p.pOlnI("} catch (java.lang.Exception e) {");
            p.pln("throw new " + idUnexpectedException + "(\"undeclared checked exception\", e);");
            p.pOln("}");
        }
        p.pOln("}");
    }

    private Vector<ClassDefinition> computeUniqueCatchList(ClassDeclaration[] exceptions) {
        Vector<ClassDefinition> uniqueList = new Vector<ClassDefinition>();
        uniqueList.addElement(this.defRuntimeException);
        uniqueList.addElement(this.defRemoteException);
        block2: for (int i = 0; i < exceptions.length; ++i) {
            ClassDeclaration decl = exceptions[i];
            try {
                if (this.defException.subClassOf(this.env, decl)) {
                    uniqueList.clear();
                    break;
                }
                if (!this.defException.superClassOf(this.env, decl)) continue;
                int j = 0;
                while (j < uniqueList.size()) {
                    ClassDefinition def = uniqueList.elementAt(j);
                    if (def.superClassOf(this.env, decl)) continue block2;
                    if (def.subClassOf(this.env, decl)) {
                        uniqueList.removeElementAt(j);
                        continue;
                    }
                    ++j;
                }
                uniqueList.addElement(decl.getClassDefinition(this.env));
                continue;
            }
            catch (ClassNotFound e) {
                this.env.error(0L, "class.not.found", e.name, decl.getName());
            }
        }
        return uniqueList;
    }

    private void writeSkeleton(IndentingWriter p) throws IOException {
        int opnum;
        if (this.version == 3) {
            throw new Error("should not generate skeleton for version");
        }
        p.pln("// Skeleton class generated by rmic, do not edit.");
        p.pln("// Contents subject to change without notice.");
        p.pln();
        if (this.remoteClassName.isQualified()) {
            p.pln("package " + this.remoteClassName.getQualifier() + ";");
            p.pln();
        }
        p.plnI("public final class " + Names.mangleClass(this.skeletonClassName.getName()));
        p.pln("implements " + idSkeleton);
        p.pOlnI("{");
        this.writeOperationsArray(p);
        p.pln();
        this.writeInterfaceHash(p);
        p.pln();
        p.plnI("public " + idOperation + "[] getOperations() {");
        p.pln("return (" + idOperation + "[]) operations.clone();");
        p.pOln("}");
        p.pln();
        p.plnI("public void dispatch(" + idRemote + " obj, " + idRemoteCall + " call, int opnum, long hash)");
        p.pln("throws java.lang.Exception");
        p.pOlnI("{");
        if (this.version == 2) {
            p.plnI("if (opnum < 0) {");
            if (this.remoteMethods.length > 0) {
                for (opnum = 0; opnum < this.remoteMethods.length; ++opnum) {
                    if (opnum > 0) {
                        p.pO("} else ");
                    }
                    p.plnI("if (hash == " + this.remoteMethods[opnum].getMethodHash() + "L) {");
                    p.pln("opnum = " + opnum + ";");
                }
                p.pOlnI("} else {");
            }
            p.pln("throw new " + idUnmarshalException + "(\"invalid method hash\");");
            if (this.remoteMethods.length > 0) {
                p.pOln("}");
            }
            p.pOlnI("} else {");
        }
        p.plnI("if (hash != interfaceHash)");
        p.pln("throw new " + idSkeletonMismatchException + "(\"interface hash mismatch\");");
        p.pO();
        if (this.version == 2) {
            p.pOln("}");
        }
        p.pln();
        p.pln(this.remoteClassName + " server = (" + this.remoteClassName + ") obj;");
        p.plnI("switch (opnum) {");
        for (opnum = 0; opnum < this.remoteMethods.length; ++opnum) {
            this.writeSkeletonDispatchCase(p, opnum);
        }
        p.pOlnI("default:");
        p.pln("throw new " + idUnmarshalException + "(\"invalid method number\");");
        p.pOln("}");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeSkeletonDispatchCase(IndentingWriter p, int opnum) throws IOException {
        int i;
        RemoteClass.Method method = this.remoteMethods[opnum];
        Identifier methodName = method.getName();
        Type methodType = method.getType();
        Type[] paramTypes = methodType.getArgumentTypes();
        String[] paramNames = RMIGenerator.nameParameters(paramTypes);
        Type returnType = methodType.getReturnType();
        p.pOlnI("case " + opnum + ": // " + methodType.typeString(methodName.toString(), true, false));
        p.pOlnI("{");
        if (paramTypes.length > 0) {
            for (i = 0; i < paramTypes.length; ++i) {
                p.pln(paramTypes[i] + " " + paramNames[i] + ";");
            }
            p.plnI("try {");
            p.pln("java.io.ObjectInput in = call.getInputStream();");
            boolean objectsRead = RMIGenerator.writeUnmarshalArguments(p, "in", paramTypes, paramNames);
            p.pOlnI("} catch (java.io.IOException e) {");
            p.pln("throw new " + idUnmarshalException + "(\"error unmarshalling arguments\", e);");
            if (objectsRead) {
                p.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                p.pln("throw new " + idUnmarshalException + "(\"error unmarshalling arguments\", e);");
            }
            p.pOlnI("} finally {");
            p.pln("call.releaseInputStream();");
            p.pOln("}");
        } else {
            p.pln("call.releaseInputStream();");
        }
        if (!returnType.isType(11)) {
            p.p(returnType + " $result = ");
        }
        p.p("server." + methodName + "(");
        for (i = 0; i < paramNames.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(paramNames[i]);
        }
        p.pln(");");
        p.plnI("try {");
        if (!returnType.isType(11)) {
            p.p("java.io.ObjectOutput out = ");
        }
        p.pln("call.getResultStream(true);");
        if (!returnType.isType(11)) {
            RMIGenerator.writeMarshalArgument(p, "out", returnType, "$result");
            p.pln(";");
        }
        p.pOlnI("} catch (java.io.IOException e) {");
        p.pln("throw new " + idMarshalException + "(\"error marshalling return\", e);");
        p.pOln("}");
        p.pln("break;");
        p.pOlnI("}");
        p.pln();
    }

    private void writeOperationsArray(IndentingWriter p) throws IOException {
        p.plnI("private static final " + idOperation + "[] operations = {");
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            if (i > 0) {
                p.pln(",");
            }
            p.p("new " + idOperation + "(\"" + this.remoteMethods[i].getOperationString() + "\")");
        }
        p.pln();
        p.pOln("};");
    }

    private void writeInterfaceHash(IndentingWriter p) throws IOException {
        p.pln("private static final long interfaceHash = " + this.remoteClass.getInterfaceHash() + "L;");
    }

    private void writeMethodFieldDeclarations(IndentingWriter p) throws IOException {
        for (int i = 0; i < this.methodFieldNames.length; ++i) {
            p.pln("private static java.lang.reflect.Method " + this.methodFieldNames[i] + ";");
        }
    }

    private void writeMethodFieldInitializers(IndentingWriter p) throws IOException {
        for (int i = 0; i < this.methodFieldNames.length; ++i) {
            p.p(this.methodFieldNames[i] + " = ");
            RemoteClass.Method method = this.remoteMethods[i];
            MemberDefinition def = method.getMemberDefinition();
            Identifier methodName = method.getName();
            Type methodType = method.getType();
            Type[] paramTypes = methodType.getArgumentTypes();
            p.p(def.getClassDefinition().getName() + ".class.getMethod(\"" + methodName + "\", new java.lang.Class[] {");
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    p.p(", ");
                }
                p.p(paramTypes[j] + ".class");
            }
            p.pln("});");
        }
    }

    private static String[] nameMethodFields(RemoteClass.Method[] methods) {
        String[] names = new String[methods.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "$method_" + methods[i].getName() + "_" + i;
        }
        return names;
    }

    private static String[] nameParameters(Type[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "$param_" + RMIGenerator.generateNameFromType(types[i]) + "_" + (i + 1);
        }
        return names;
    }

    private static String generateNameFromType(Type type) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf_" + RMIGenerator.generateNameFromType(type.getElementType());
            }
            case 10: {
                return Names.mangleClass(type.getClassName().getName()).toString();
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    private static void writeMarshalArgument(IndentingWriter p, String streamName, Type type, String name) throws IOException {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: {
                p.p(streamName + ".writeBoolean(" + name + ")");
                break;
            }
            case 1: {
                p.p(streamName + ".writeByte(" + name + ")");
                break;
            }
            case 2: {
                p.p(streamName + ".writeChar(" + name + ")");
                break;
            }
            case 3: {
                p.p(streamName + ".writeShort(" + name + ")");
                break;
            }
            case 4: {
                p.p(streamName + ".writeInt(" + name + ")");
                break;
            }
            case 5: {
                p.p(streamName + ".writeLong(" + name + ")");
                break;
            }
            case 6: {
                p.p(streamName + ".writeFloat(" + name + ")");
                break;
            }
            case 7: {
                p.p(streamName + ".writeDouble(" + name + ")");
                break;
            }
            case 9: 
            case 10: {
                p.p(streamName + ".writeObject(" + name + ")");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
    }

    private static void writeMarshalArguments(IndentingWriter p, String streamName, Type[] types, String[] names) throws IOException {
        if (types.length != names.length) {
            throw new Error("parameter type and name arrays different sizes");
        }
        for (int i = 0; i < types.length; ++i) {
            RMIGenerator.writeMarshalArgument(p, streamName, types[i], names[i]);
            p.pln(";");
        }
    }

    private static boolean writeUnmarshalArgument(IndentingWriter p, String streamName, Type type, String name) throws IOException {
        boolean readObject = false;
        if (name != null) {
            p.p(name + " = ");
        }
        int typeCode = type.getTypeCode();
        switch (type.getTypeCode()) {
            case 0: {
                p.p(streamName + ".readBoolean()");
                break;
            }
            case 1: {
                p.p(streamName + ".readByte()");
                break;
            }
            case 2: {
                p.p(streamName + ".readChar()");
                break;
            }
            case 3: {
                p.p(streamName + ".readShort()");
                break;
            }
            case 4: {
                p.p(streamName + ".readInt()");
                break;
            }
            case 5: {
                p.p(streamName + ".readLong()");
                break;
            }
            case 6: {
                p.p(streamName + ".readFloat()");
                break;
            }
            case 7: {
                p.p(streamName + ".readDouble()");
                break;
            }
            case 9: 
            case 10: {
                p.p("(" + type + ") " + streamName + ".readObject()");
                readObject = true;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
        return readObject;
    }

    private static boolean writeUnmarshalArguments(IndentingWriter p, String streamName, Type[] types, String[] names) throws IOException {
        if (types.length != names.length) {
            throw new Error("parameter type and name arrays different sizes");
        }
        boolean readObject = false;
        for (int i = 0; i < types.length; ++i) {
            if (RMIGenerator.writeUnmarshalArgument(p, streamName, types[i], names[i])) {
                readObject = true;
            }
            p.pln(";");
        }
        return readObject;
    }

    private static String wrapArgumentCode(Type type, String name) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: {
                return "(" + name + " ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE)";
            }
            case 1: {
                return "new java.lang.Byte(" + name + ")";
            }
            case 2: {
                return "new java.lang.Character(" + name + ")";
            }
            case 3: {
                return "new java.lang.Short(" + name + ")";
            }
            case 4: {
                return "new java.lang.Integer(" + name + ")";
            }
            case 5: {
                return "new java.lang.Long(" + name + ")";
            }
            case 6: {
                return "new java.lang.Float(" + name + ")";
            }
            case 7: {
                return "new java.lang.Double(" + name + ")";
            }
            case 9: 
            case 10: {
                return name;
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    private static String unwrapArgumentCode(Type type, String name) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: {
                return "((java.lang.Boolean) " + name + ").booleanValue()";
            }
            case 1: {
                return "((java.lang.Byte) " + name + ").byteValue()";
            }
            case 2: {
                return "((java.lang.Character) " + name + ").charValue()";
            }
            case 3: {
                return "((java.lang.Short) " + name + ").shortValue()";
            }
            case 4: {
                return "((java.lang.Integer) " + name + ").intValue()";
            }
            case 5: {
                return "((java.lang.Long) " + name + ").longValue()";
            }
            case 6: {
                return "((java.lang.Float) " + name + ").floatValue()";
            }
            case 7: {
                return "((java.lang.Double) " + name + ").doubleValue()";
            }
            case 9: 
            case 10: {
                return "((" + type + ") " + name + ")";
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    static {
        versionOptions.put("-v1.1", 1);
        versionOptions.put("-vcompat", 2);
        versionOptions.put("-v1.2", 3);
    }
}

