/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import sun.tools.java.BinaryAttribute;
import sun.tools.java.BinaryClass;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.BooleanExpression;
import sun.tools.tree.DoubleExpression;
import sun.tools.tree.Expression;
import sun.tools.tree.FloatExpression;
import sun.tools.tree.IntExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.LongExpression;
import sun.tools.tree.Node;
import sun.tools.tree.StringExpression;

public final class BinaryMember
extends MemberDefinition {
    Expression value;
    BinaryAttribute atts;
    private boolean isConstantCache = false;
    private boolean isConstantCached = false;

    public BinaryMember(ClassDefinition clazz, int modifiers, Type type, Identifier name, BinaryAttribute atts) {
        super(0L, clazz, modifiers, type, name, null, null);
        this.atts = atts;
        if (this.getAttribute(idDeprecated) != null) {
            this.modifiers |= 0x40000;
        }
        if (this.getAttribute(idSynthetic) != null) {
            this.modifiers |= 0x80000;
        }
    }

    public BinaryMember(ClassDefinition innerClass) {
        super(innerClass);
    }

    @Override
    public boolean isInlineable(Environment env, boolean fromFinal) {
        return this.isConstructor() && this.getClassDefinition().getSuperClass() == null;
    }

    @Override
    public Vector<MemberDefinition> getArguments() {
        if (this.isConstructor() && this.getClassDefinition().getSuperClass() == null) {
            Vector<MemberDefinition> v = new Vector<MemberDefinition>();
            v.addElement(new LocalMember(0L, this.getClassDefinition(), 0, this.getClassDefinition().getType(), idThis));
            return v;
        }
        return null;
    }

    @Override
    public ClassDeclaration[] getExceptions(Environment env) {
        if (!this.isMethod() || this.exp != null) {
            return this.exp;
        }
        byte[] data = this.getAttribute(idExceptions);
        if (data == null) {
            return new ClassDeclaration[0];
        }
        try {
            BinaryConstantPool cpool = ((BinaryClass)this.getClassDefinition()).getConstants();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            int n = in.readUnsignedShort();
            this.exp = new ClassDeclaration[n];
            for (int i = 0; i < n; ++i) {
                this.exp[i] = cpool.getDeclaration(env, in.readUnsignedShort());
            }
            return this.exp;
        }
        catch (IOException e) {
            throw new CompilerError(e);
        }
    }

    @Override
    public String getDocumentation() {
        if (this.documentation != null) {
            return this.documentation;
        }
        byte[] data = this.getAttribute(idDocumentation);
        if (data == null) {
            return null;
        }
        try {
            this.documentation = new DataInputStream(new ByteArrayInputStream(data)).readUTF();
            return this.documentation;
        }
        catch (IOException e) {
            throw new CompilerError(e);
        }
    }

    @Override
    public boolean isConstant() {
        if (!this.isConstantCached) {
            this.isConstantCache = this.isFinal() && this.isVariable() && this.getAttribute(idConstantValue) != null;
            this.isConstantCached = true;
        }
        return this.isConstantCache;
    }

    @Override
    public Node getValue(Environment env) {
        if (this.isMethod()) {
            return null;
        }
        if (!this.isFinal()) {
            return null;
        }
        if (this.getValue() != null) {
            return (Expression)this.getValue();
        }
        byte[] data = this.getAttribute(idConstantValue);
        if (data == null) {
            return null;
        }
        try {
            BinaryConstantPool cpool = ((BinaryClass)this.getClassDefinition()).getConstants();
            Object obj = cpool.getValue(new DataInputStream(new ByteArrayInputStream(data)).readUnsignedShort());
            switch (this.getType().getTypeCode()) {
                case 0: {
                    this.setValue(new BooleanExpression(0L, ((Number)obj).intValue() != 0));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.setValue(new IntExpression(0L, ((Number)obj).intValue()));
                    break;
                }
                case 5: {
                    this.setValue(new LongExpression(0L, ((Number)obj).longValue()));
                    break;
                }
                case 6: {
                    this.setValue(new FloatExpression(0L, ((Number)obj).floatValue()));
                    break;
                }
                case 7: {
                    this.setValue(new DoubleExpression(0L, ((Number)obj).doubleValue()));
                    break;
                }
                case 10: {
                    this.setValue(new StringExpression(0L, (String)cpool.getValue(((Number)obj).intValue())));
                }
            }
            return (Expression)this.getValue();
        }
        catch (IOException e) {
            throw new CompilerError(e);
        }
    }

    public byte[] getAttribute(Identifier name) {
        BinaryAttribute att = this.atts;
        while (att != null) {
            if (att.name.equals(name)) {
                return att.data;
            }
            att = att.next;
        }
        return null;
    }

    public boolean deleteAttribute(Identifier name) {
        BinaryAttribute walker = null;
        BinaryAttribute next = null;
        boolean succeed = false;
        while (this.atts.name.equals(name)) {
            this.atts = this.atts.next;
            succeed = true;
        }
        walker = this.atts;
        while (walker != null) {
            next = walker.next;
            if (next != null && next.name.equals(name)) {
                walker.next = next.next;
                next = next.next;
                succeed = true;
            }
            walker = next;
        }
        walker = this.atts;
        while (walker != null) {
            if (walker.name.equals(name)) {
                throw new InternalError("Found attribute " + name);
            }
            walker = walker.next;
        }
        return succeed;
    }

    public void addAttribute(Identifier name, byte[] data, Environment env) {
        this.atts = new BinaryAttribute(name, data, this.atts);
        ((BinaryClass)this.clazz).cpool.indexString(name.toString(), env);
    }
}

