/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;
import sun.tools.java.Type;

public class Package {
    ClassPath sourcePath;
    ClassPath binaryPath;
    String pkg;

    public Package(ClassPath path, Identifier pkg) throws IOException {
        this(path, path, pkg);
    }

    public Package(ClassPath sourcePath, ClassPath binaryPath, Identifier pkg) throws IOException {
        if (pkg.isInner()) {
            pkg = Identifier.lookup(pkg.getQualifier(), pkg.getFlatName());
        }
        this.sourcePath = sourcePath;
        this.binaryPath = binaryPath;
        this.pkg = pkg.toString().replace('.', File.separatorChar);
    }

    public boolean classExists(Identifier className) {
        return this.getBinaryFile(className) != null || !className.isInner() && this.getSourceFile(className) != null;
    }

    public boolean exists() {
        ClassFile dir = this.binaryPath.getDirectory(this.pkg);
        if (dir != null && dir.isDirectory()) {
            return true;
        }
        if (this.sourcePath != this.binaryPath && (dir = this.sourcePath.getDirectory(this.pkg)) != null && dir.isDirectory()) {
            return true;
        }
        String prefix = this.pkg + File.separator;
        return this.binaryPath.getFiles(prefix, ".class").hasMoreElements() || this.sourcePath.getFiles(prefix, ".java").hasMoreElements();
    }

    private String makeName(String fileName) {
        return this.pkg.equals("") ? fileName : this.pkg + File.separator + fileName;
    }

    public ClassFile getBinaryFile(Identifier className) {
        className = Type.mangleInnerType(className);
        String fileName = className.toString() + ".class";
        return this.binaryPath.getFile(this.makeName(fileName));
    }

    public ClassFile getSourceFile(Identifier className) {
        className = className.getTopName();
        String fileName = className.toString() + ".java";
        return this.sourcePath.getFile(this.makeName(fileName));
    }

    public ClassFile getSourceFile(String fileName) {
        if (fileName.endsWith(".java")) {
            return this.sourcePath.getFile(this.makeName(fileName));
        }
        return null;
    }

    public Enumeration<ClassFile> getSourceFiles() {
        return this.sourcePath.getFiles(this.pkg, ".java");
    }

    public Enumeration<ClassFile> getBinaryFiles() {
        return this.binaryPath.getFiles(this.pkg, ".class");
    }

    public String toString() {
        if (this.pkg.equals("")) {
            return "unnamed package";
        }
        return "package " + this.pkg;
    }
}

