/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.tools.java.ClassFile;

final class ZipClassFile
extends ClassFile {
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;

    public ZipClassFile(ZipFile zf, ZipEntry ze) {
        this.zipFile = zf;
        this.zipEntry = ze;
    }

    @Override
    public boolean isZipped() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.zipEntry.getName().endsWith("/");
    }

    @Override
    public long lastModified() {
        return this.zipEntry.getTime();
    }

    @Override
    public String getPath() {
        return this.zipFile.getName() + "(" + this.zipEntry.getName() + ")";
    }

    @Override
    public String getName() {
        return this.zipEntry.getName();
    }

    @Override
    public String getAbsoluteName() {
        return this.zipFile.getName() + "(" + this.zipEntry.getName() + ")";
    }

    @Override
    public long length() {
        return this.zipEntry.getSize();
    }

    public String toString() {
        return this.zipEntry.toString();
    }
}

