/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.AssignExpression;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.ConditionalExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldUpdater;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.LengthExpression;
import sun.tools.tree.MethodExpression;
import sun.tools.tree.NotEqualExpression;
import sun.tools.tree.NullExpression;
import sun.tools.tree.StringExpression;
import sun.tools.tree.SuperExpression;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.Vset;

public class FieldExpression
extends UnaryExpression {
    Identifier id;
    MemberDefinition field;
    Expression implementation;
    ClassDefinition clazz;
    private ClassDefinition superBase;

    public FieldExpression(long where, Expression right, Identifier id) {
        super(46, where, Type.tError, right);
        this.id = id;
    }

    public FieldExpression(long where, Expression right, MemberDefinition field) {
        super(46, where, field.getType(), right);
        this.id = field.getName();
        this.field = field;
    }

    @Override
    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    private boolean isQualSuper() {
        return this.superBase != null;
    }

    public static Identifier toIdentifier(Expression e) {
        StringBuilder sb = new StringBuilder();
        while (e.op == 46) {
            FieldExpression fe = (FieldExpression)e;
            if (fe.id == idThis || fe.id == idClass) {
                return null;
            }
            sb.insert(0, fe.id);
            sb.insert(0, '.');
            e = fe.right;
        }
        if (e.op != 60) {
            return null;
        }
        sb.insert(0, ((IdentifierExpression)e).id);
        return Identifier.lookup(sb.toString());
    }

    @Override
    Type toType(Environment env, Context ctx) {
        Identifier id = FieldExpression.toIdentifier(this);
        if (id == null) {
            env.error(this.where, "invalid.type.expr");
            return Type.tError;
        }
        Type t = Type.tClass(ctx.resolveName(env, id));
        if (env.resolve(this.where, ctx.field.getClassDefinition(), t)) {
            return t;
        }
        return Type.tError;
    }

    @Override
    public Vset checkAmbigName(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, UnaryExpression loc) {
        if (this.id == idThis || this.id == idClass) {
            loc = null;
        }
        return this.checkCommon(env, ctx, vset, exp, loc, false);
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.checkCommon(env, ctx, vset, exp, null, false);
        if (this.id == idSuper && this.type != Type.tError) {
            env.error(this.where, "undef.var.super", idSuper);
        }
        return vset;
    }

    static void reportFailedPackagePrefix(Environment env, Expression right) {
        FieldExpression.reportFailedPackagePrefix(env, right, false);
    }

    static void reportFailedPackagePrefix(Environment env, Expression right, boolean mustBeType) {
        Expression idp = right;
        while (idp instanceof UnaryExpression) {
            idp = ((UnaryExpression)idp).right;
        }
        IdentifierExpression ie = (IdentifierExpression)idp;
        try {
            env.resolve(ie.id);
        }
        catch (AmbiguousClass e) {
            env.error(right.where, "ambig.class", e.name1, e.name2);
            return;
        }
        catch (ClassNotFound e) {
            // empty catch block
        }
        if (idp == right) {
            if (mustBeType) {
                env.error(ie.where, "undef.class", ie.id);
            } else {
                env.error(ie.where, "undef.var.or.class", ie.id);
            }
        } else if (mustBeType) {
            env.error(ie.where, "undef.class.or.package", ie.id);
        } else {
            env.error(ie.where, "undef.var.class.or.package", ie.id);
        }
    }

    private Expression implementFieldAccess(Environment env, Context ctx, Expression base, boolean isLHS) {
        ClassDefinition abase = this.accessBase(env, ctx);
        if (abase != null) {
            Expression e;
            if (this.field.isFinal() && (e = (Expression)this.field.getValue()) != null && e.isConstant() && !isLHS) {
                return e.copyInline(ctx);
            }
            MemberDefinition af = abase.getAccessMember(env, ctx, this.field, this.isQualSuper());
            if (!isLHS) {
                if (this.field.isStatic()) {
                    Expression[] args = new Expression[]{};
                    MethodExpression call = new MethodExpression(this.where, null, af, args);
                    return new CommaExpression(this.where, base, call);
                }
                Expression[] args = new Expression[]{base};
                return new MethodExpression(this.where, null, af, args);
            }
        }
        return null;
    }

    private ClassDefinition accessBase(Environment env, Context ctx) {
        if (this.field.isPrivate()) {
            ClassDefinition ctxClass;
            ClassDefinition cdef = this.field.getClassDefinition();
            if (cdef == (ctxClass = ctx.field.getClassDefinition())) {
                return null;
            }
            return cdef;
        }
        if (this.field.isProtected()) {
            ClassDefinition ctxClass;
            if (this.superBase == null) {
                return null;
            }
            ClassDefinition cdef = this.field.getClassDefinition();
            if (cdef.inSamePackage(ctxClass = ctx.field.getClassDefinition())) {
                return null;
            }
            return this.superBase;
        }
        return null;
    }

    static boolean isTypeAccessible(long where, Environment env, Type t, ClassDefinition c) {
        switch (t.getTypeCode()) {
            case 10: {
                try {
                    Identifier nm = t.getClassName();
                    ClassDefinition def = env.getClassDefinition(t);
                    return c.canAccess(env, def.getClassDeclaration());
                }
                catch (ClassNotFound e) {
                    return true;
                }
            }
            case 9: {
                return FieldExpression.isTypeAccessible(where, env, t.getElementType(), c);
            }
        }
        return true;
    }

    private Vset checkCommon(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, UnaryExpression loc, boolean isLHS) {
        if (this.id == idClass) {
            Type t = this.right.toType(env, ctx);
            if (!t.isType(10) && !t.isType(9)) {
                if (t.isType(13)) {
                    this.type = Type.tClassDesc;
                    return vset;
                }
                String wrc = null;
                switch (t.getTypeCode()) {
                    case 11: {
                        wrc = "Void";
                        break;
                    }
                    case 0: {
                        wrc = "Boolean";
                        break;
                    }
                    case 1: {
                        wrc = "Byte";
                        break;
                    }
                    case 2: {
                        wrc = "Character";
                        break;
                    }
                    case 3: {
                        wrc = "Short";
                        break;
                    }
                    case 4: {
                        wrc = "Integer";
                        break;
                    }
                    case 6: {
                        wrc = "Float";
                        break;
                    }
                    case 5: {
                        wrc = "Long";
                        break;
                    }
                    case 7: {
                        wrc = "Double";
                        break;
                    }
                    default: {
                        env.error(this.right.where, "invalid.type.expr");
                        return vset;
                    }
                }
                Identifier wid = Identifier.lookup(idJavaLang + "." + wrc);
                TypeExpression wcls = new TypeExpression(this.where, Type.tClass(wid));
                this.implementation = new FieldExpression(this.where, (Expression)wcls, idTYPE);
                vset = this.implementation.checkValue(env, ctx, vset, exp);
                this.type = this.implementation.type;
                return vset;
            }
            if (t.isVoidArray()) {
                this.type = Type.tClassDesc;
                env.error(this.right.where, "void.array");
                return vset;
            }
            long fwhere = ctx.field.getWhere();
            ClassDefinition fcls = ctx.field.getClassDefinition();
            MemberDefinition lookup = fcls.getClassLiteralLookup(fwhere);
            String sig = t.getTypeSignature();
            String className = t.isType(10) ? sig.substring(1, sig.length() - 1).replace('/', '.') : sig.replace('/', '.');
            if (fcls.isInterface()) {
                this.implementation = this.makeClassLiteralInlineRef(env, ctx, lookup, className);
            } else {
                ClassDefinition inClass = lookup.getClassDefinition();
                MemberDefinition cfld = FieldExpression.getClassLiteralCache(env, ctx, className, inClass);
                this.implementation = this.makeClassLiteralCacheRef(env, ctx, lookup, cfld, className);
            }
            vset = this.implementation.checkValue(env, ctx, vset, exp);
            this.type = this.implementation.type;
            return vset;
        }
        if (this.field != null) {
            this.implementation = this.implementFieldAccess(env, ctx, this.right, isLHS);
            return this.right == null ? vset : this.right.checkAmbigName(env, ctx, vset, exp, this);
        }
        vset = this.right.checkAmbigName(env, ctx, vset, exp, this);
        if (this.right.type == Type.tPackage) {
            if (loc == null) {
                FieldExpression.reportFailedPackagePrefix(env, this.right);
                return vset;
            }
            Identifier nm = FieldExpression.toIdentifier(this);
            if (nm != null && env.classExists(nm)) {
                loc.right = new TypeExpression(this.where, Type.tClass(nm));
                ClassDefinition ctxClass = ctx.field.getClassDefinition();
                env.resolve(this.where, ctxClass, loc.right.type);
                return vset;
            }
            this.type = Type.tPackage;
            return vset;
        }
        ClassDefinition ctxClass = ctx.field.getClassDefinition();
        boolean staticRef = this.right instanceof TypeExpression;
        try {
            ClassDefinition declarer;
            if (!this.right.type.isType(10)) {
                if (this.right.type.isType(9) && this.id.equals(idLength)) {
                    if (!FieldExpression.isTypeAccessible(this.where, env, this.right.type, ctxClass)) {
                        ClassDeclaration cdecl = ctxClass.getClassDeclaration();
                        if (staticRef) {
                            env.error(this.where, "no.type.access", this.id, this.right.type.toString(), cdecl);
                        } else {
                            env.error(this.where, "cant.access.member.type", this.id, this.right.type.toString(), cdecl);
                        }
                    }
                    this.type = Type.tInt;
                    this.implementation = new LengthExpression(this.where, this.right);
                    return vset;
                }
                if (!this.right.type.isType(13)) {
                    env.error(this.where, "invalid.field.reference", this.id, this.right.type);
                }
                return vset;
            }
            ClassDefinition sourceClass = ctxClass;
            if (this.right instanceof FieldExpression) {
                Identifier id = ((FieldExpression)this.right).id;
                if (id == idThis) {
                    sourceClass = ((FieldExpression)this.right).clazz;
                } else if (id == idSuper) {
                    this.superBase = sourceClass = ((FieldExpression)this.right).clazz;
                }
            }
            this.clazz = env.getClassDefinition(this.right.type);
            if (this.id == idThis || this.id == idSuper) {
                if (!staticRef) {
                    env.error(this.right.where, "invalid.type.expr");
                }
                if (ctx.field.isSynthetic()) {
                    throw new CompilerError("synthetic qualified this");
                }
                this.implementation = ctx.findOuterLink(env, this.where, this.clazz, null, true);
                vset = this.implementation.checkValue(env, ctx, vset, exp);
                this.type = this.id == idSuper ? this.clazz.getSuperClass().getType() : this.clazz.getType();
                return vset;
            }
            this.field = this.clazz.getVariable(env, this.id, sourceClass);
            if (this.field == null && staticRef && loc != null) {
                this.field = this.clazz.getInnerClass(env, this.id);
                if (this.field != null) {
                    return this.checkInnerClass(env, ctx, vset, exp, loc);
                }
            }
            if (this.field == null) {
                this.field = this.clazz.findAnyMethod(env, this.id);
                if (this.field != null) {
                    env.error(this.where, "invalid.field", this.id, this.field.getClassDeclaration());
                } else {
                    env.error(this.where, "no.such.field", this.id, this.clazz);
                }
                return vset;
            }
            if (!FieldExpression.isTypeAccessible(this.where, env, this.right.type, sourceClass)) {
                ClassDeclaration cdecl = sourceClass.getClassDeclaration();
                if (staticRef) {
                    env.error(this.where, "no.type.access", this.id, this.right.type.toString(), cdecl);
                } else {
                    env.error(this.where, "cant.access.member.type", this.id, this.right.type.toString(), cdecl);
                }
            }
            this.type = this.field.getType();
            if (!sourceClass.canAccess(env, this.field)) {
                env.error(this.where, "no.field.access", this.id, this.clazz, sourceClass.getClassDeclaration());
                return vset;
            }
            if (staticRef && !this.field.isStatic()) {
                env.error(this.where, "no.static.field.access", this.id, this.clazz);
                return vset;
            }
            this.implementation = this.implementFieldAccess(env, ctx, this.right, isLHS);
            if (!(!this.field.isProtected() || this.right instanceof SuperExpression || this.right instanceof FieldExpression && ((FieldExpression)this.right).id == idSuper || sourceClass.protectedAccess(env, this.field, this.right.type))) {
                env.error(this.where, "invalid.protected.field.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            if (!this.field.isStatic() && this.right.op == 82 && !vset.testVar(ctx.getThisNumber())) {
                env.error(this.where, "access.inst.before.super", this.id);
            }
            if (this.field.reportDeprecated(env)) {
                env.error(this.where, "warn.field.is.deprecated", this.id, this.field.getClassDefinition());
            }
            if (sourceClass == ctxClass && (declarer = this.field.getClassDefinition()).isPackagePrivate() && !declarer.getName().getQualifier().equals(sourceClass.getName().getQualifier())) {
                this.field = MemberDefinition.makeProxyMember(this.field, this.clazz, env);
            }
            sourceClass.addDependency(this.field.getClassDeclaration());
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, ctx.field);
        }
        catch (AmbiguousMember e) {
            env.error(this.where, "ambig.field", this.id, e.field1.getClassDeclaration(), e.field2.getClassDeclaration());
        }
        return vset;
    }

    @Override
    public FieldUpdater getAssigner(Environment env, Context ctx) {
        if (this.field == null) {
            return null;
        }
        ClassDefinition abase = this.accessBase(env, ctx);
        if (abase != null) {
            MemberDefinition setter = abase.getUpdateMember(env, ctx, this.field, this.isQualSuper());
            Expression base = this.right == null ? null : this.right.copyInline(ctx);
            return new FieldUpdater(this.where, this.field, base, null, setter);
        }
        return null;
    }

    @Override
    public FieldUpdater getUpdater(Environment env, Context ctx) {
        if (this.field == null) {
            return null;
        }
        ClassDefinition abase = this.accessBase(env, ctx);
        if (abase != null) {
            MemberDefinition getter = abase.getAccessMember(env, ctx, this.field, this.isQualSuper());
            MemberDefinition setter = abase.getUpdateMember(env, ctx, this.field, this.isQualSuper());
            Expression base = this.right == null ? null : this.right.copyInline(ctx);
            return new FieldUpdater(this.where, this.field, base, getter, setter);
        }
        return null;
    }

    private Vset checkInnerClass(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, UnaryExpression loc) {
        ClassDefinition inner = this.field.getInnerClass();
        this.type = inner.getType();
        if (!inner.isTopLevel()) {
            env.error(this.where, "inner.static.ref", inner.getName());
        }
        TypeExpression te = new TypeExpression(this.where, this.type);
        ClassDefinition ctxClass = ctx.field.getClassDefinition();
        try {
            if (!ctxClass.canAccess(env, this.field)) {
                ClassDefinition clazz = env.getClassDefinition(this.right.type);
                env.error(this.where, "no.type.access", this.id, clazz, ctxClass.getClassDeclaration());
                return vset;
            }
            if (!(!this.field.isProtected() || this.right instanceof SuperExpression || this.right instanceof FieldExpression && ((FieldExpression)this.right).id == idSuper || ctxClass.protectedAccess(env, this.field, this.right.type))) {
                env.error(this.where, "invalid.protected.field.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            inner.noteUsedBy(ctxClass, this.where, env);
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, ctx.field);
        }
        ctxClass.addDependency(this.field.getClassDeclaration());
        if (loc == null) {
            return ((Expression)te).checkValue(env, ctx, vset, exp);
        }
        loc.right = te;
        return vset;
    }

    @Override
    public Vset checkLHS(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        boolean hadField = this.field != null;
        this.checkCommon(env, ctx, vset, exp, null, true);
        if (this.implementation != null) {
            return super.checkLHS(env, ctx, vset, exp);
        }
        if (this.field != null && this.field.isFinal() && !hadField) {
            if (this.field.isBlankFinal()) {
                if (this.field.isStatic()) {
                    if (this.right != null) {
                        env.error(this.where, "qualified.static.final.assign");
                    }
                } else if (this.right != null && this.right.op != 82) {
                    env.error(this.where, "bad.qualified.final.assign", this.field.getName());
                    return vset;
                }
                vset = FieldExpression.checkFinalAssign(env, ctx, vset, this.where, this.field);
            } else {
                env.error(this.where, "assign.to.final", this.id);
            }
        }
        return vset;
    }

    @Override
    public Vset checkAssignOp(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, Expression outside) {
        this.checkCommon(env, ctx, vset, exp, null, true);
        if (this.implementation != null) {
            return super.checkLHS(env, ctx, vset, exp);
        }
        if (this.field != null && this.field.isFinal()) {
            env.error(this.where, "assign.to.final", this.id);
        }
        return vset;
    }

    public static Vset checkFinalAssign(Environment env, Context ctx, Vset vset, long where, MemberDefinition field) {
        if (field.isBlankFinal() && field.getClassDefinition() == ctx.field.getClassDefinition()) {
            int number = ctx.getFieldNumber(field);
            if (number >= 0 && vset.testVarUnassigned(number)) {
                vset = vset.addVar(number);
            } else {
                Identifier id = field.getName();
                env.error(where, "assign.to.blank.final", id);
            }
        } else {
            Identifier id = field.getName();
            env.error(where, "assign.to.final", id);
        }
        return vset;
    }

    private static MemberDefinition getClassLiteralCache(Environment env, Context ctx, String className, ClassDefinition c) {
        MemberDefinition cfld;
        String lname;
        if (!className.startsWith("[")) {
            lname = "class$" + className.replace('.', '$');
        } else {
            lname = "array$" + className.substring(1);
            lname = lname.replace('[', '$');
            if (className.endsWith(";")) {
                lname = lname.substring(0, lname.length() - 1);
                lname = lname.replace('.', '$');
            }
        }
        Identifier fname = Identifier.lookup(lname);
        try {
            cfld = c.getVariable(env, fname, c);
        }
        catch (ClassNotFound ee) {
            return null;
        }
        catch (AmbiguousMember ee) {
            return null;
        }
        if (cfld != null && cfld.getClassDefinition() == c) {
            return cfld;
        }
        return env.makeMemberDefinition(env, c.getWhere(), c, null, 524296, Type.tClassDesc, fname, null, null, null);
    }

    private Expression makeClassLiteralCacheRef(Environment env, Context ctx, MemberDefinition lookup, MemberDefinition cfld, String className) {
        TypeExpression ccls = new TypeExpression(this.where, cfld.getClassDefinition().getType());
        FieldExpression cache = new FieldExpression(this.where, (Expression)ccls, cfld);
        NotEqualExpression cacheOK = new NotEqualExpression(this.where, ((Expression)cache).copyInline(ctx), new NullExpression(this.where));
        TypeExpression lcls = new TypeExpression(this.where, lookup.getClassDefinition().getType());
        StringExpression name = new StringExpression(this.where, className);
        Expression[] namearg = new Expression[]{name};
        UnaryExpression setCache = new MethodExpression(this.where, (Expression)lcls, lookup, namearg);
        setCache = new AssignExpression(this.where, ((Expression)cache).copyInline(ctx), setCache);
        return new ConditionalExpression(this.where, cacheOK, cache, (Expression)setCache);
    }

    private Expression makeClassLiteralInlineRef(Environment env, Context ctx, MemberDefinition lookup, String className) {
        TypeExpression lcls = new TypeExpression(this.where, lookup.getClassDefinition().getType());
        StringExpression name = new StringExpression(this.where, className);
        Expression[] namearg = new Expression[]{name};
        MethodExpression getClass = new MethodExpression(this.where, (Expression)lcls, lookup, namearg);
        return getClass;
    }

    @Override
    public boolean isConstant() {
        if (this.implementation != null) {
            return this.implementation.isConstant();
        }
        if (this.field != null && (this.right == null || this.right instanceof TypeExpression || this.right.op == 82 && this.right.where == this.where)) {
            return this.field.isConstant();
        }
        return false;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inline(env, ctx);
        }
        Expression e = this.inlineValue(env, ctx);
        if (e instanceof FieldExpression) {
            FieldExpression fe = (FieldExpression)e;
            if (fe.right != null && fe.right.op == 82) {
                return null;
            }
        }
        return e;
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(env, ctx);
        }
        try {
            Expression e;
            if (this.field == null) {
                return this;
            }
            if (this.field.isFinal() && (e = (Expression)this.field.getValue(env)) != null && e.isConstant()) {
                e = e.copyInline(ctx);
                e.where = this.where;
                return new CommaExpression(this.where, this.right, e).inlineValue(env, ctx);
            }
            if (this.right != null) {
                if (this.field.isStatic()) {
                    e = this.right.inline(env, ctx);
                    this.right = null;
                    if (e != null) {
                        return new CommaExpression(this.where, e, this);
                    }
                } else {
                    this.right = this.right.inlineValue(env, ctx);
                }
            }
            return this;
        }
        catch (ClassNotFound e) {
            throw new CompilerError(e);
        }
    }

    @Override
    public Expression inlineLHS(Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.inlineLHS(env, ctx);
        }
        if (this.right != null) {
            if (this.field.isStatic()) {
                Expression e = this.right.inline(env, ctx);
                this.right = null;
                if (e != null) {
                    return new CommaExpression(this.where, e, this);
                }
            } else {
                this.right = this.right.inlineValue(env, ctx);
            }
        }
        return this;
    }

    @Override
    public Expression copyInline(Context ctx) {
        if (this.implementation != null) {
            return this.implementation.copyInline(ctx);
        }
        return super.copyInline(ctx);
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (this.implementation != null) {
            return this.implementation.costInline(thresh, env, ctx);
        }
        if (ctx == null) {
            return 3 + (this.right == null ? 0 : this.right.costInline(thresh, env, ctx));
        }
        ClassDefinition ctxClass = ctx.field.getClassDefinition();
        try {
            if (ctxClass.permitInlinedAccess(env, this.field.getClassDeclaration()) && ctxClass.permitInlinedAccess(env, this.field)) {
                if (this.right == null) {
                    return 3;
                }
                ClassDeclaration rt = env.getClassDeclaration(this.right.type);
                if (ctxClass.permitInlinedAccess(env, rt)) {
                    return 3 + this.right.costInline(thresh, env, ctx);
                }
            }
        }
        catch (ClassNotFound e) {
            // empty catch block
        }
        return thresh;
    }

    @Override
    int codeLValue(Environment env, Context ctx, Assembler asm) {
        if (this.implementation != null) {
            throw new CompilerError("codeLValue");
        }
        if (this.field.isStatic()) {
            if (this.right != null) {
                this.right.code(env, ctx, asm);
                return 1;
            }
            return 0;
        }
        this.right.codeValue(env, ctx, asm);
        return 1;
    }

    @Override
    void codeLoad(Environment env, Context ctx, Assembler asm) {
        if (this.field == null) {
            throw new CompilerError("should not be null");
        }
        if (this.field.isStatic()) {
            asm.add(this.where, 178, this.field);
        } else {
            asm.add(this.where, 180, this.field);
        }
    }

    @Override
    void codeStore(Environment env, Context ctx, Assembler asm) {
        if (this.field.isStatic()) {
            asm.add(this.where, 179, this.field);
        } else {
            asm.add(this.where, 181, this.field);
        }
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.codeLValue(env, ctx, asm);
        this.codeLoad(env, ctx, asm);
    }

    @Override
    public void print(PrintStream out) {
        out.print("(");
        if (this.right != null) {
            this.right.print(out);
        } else {
            out.print("<empty>");
        }
        out.print("." + this.id + ")");
        if (this.implementation != null) {
            out.print("/IMPL=");
            this.implementation.print(out);
        }
    }
}

