/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.CompoundStatement;
import sun.tools.tree.ConditionVars;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class ForStatement
extends Statement {
    Statement init;
    Expression cond;
    Expression inc;
    Statement body;

    public ForStatement(long where, Statement init, Expression cond, Expression inc, Statement body) {
        super(92, where);
        this.init = init;
        this.cond = cond;
        this.inc = inc;
        this.body = body;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        ConditionVars cvars;
        this.checkLabel(env, ctx);
        vset = this.reach(env, vset);
        Context initctx = new Context(ctx, this);
        if (this.init != null) {
            vset = this.init.checkBlockStatement(env, initctx, vset, exp);
        }
        CheckContext newctx = new CheckContext(initctx, this);
        Vset vsEntry = vset.copy();
        if (this.cond != null) {
            cvars = this.cond.checkCondition(env, newctx, vset, exp);
            this.cond = this.convert(env, newctx, Type.tBoolean, this.cond);
        } else {
            cvars = new ConditionVars();
            cvars.vsFalse = Vset.DEAD_END;
            cvars.vsTrue = vset;
        }
        vset = this.body.check(env, newctx, cvars.vsTrue, exp);
        vset = vset.join(newctx.vsContinue);
        if (this.inc != null) {
            vset = this.inc.check(env, newctx, vset, exp);
        }
        initctx.checkBackBranch(env, this, vsEntry, vset);
        vset = newctx.vsBreak.join(cvars.vsFalse);
        return ctx.removeAdditionalVars(vset);
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        ctx = new Context(ctx, this);
        if (this.init != null) {
            Statement[] body = new Statement[]{this.init, this};
            this.init = null;
            return new CompoundStatement(this.where, body).inline(env, ctx);
        }
        if (this.cond != null) {
            this.cond = this.cond.inlineValue(env, ctx);
        }
        if (this.body != null) {
            this.body = this.body.inline(env, ctx);
        }
        if (this.inc != null) {
            this.inc = this.inc.inline(env, ctx);
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        ForStatement s = (ForStatement)this.clone();
        if (this.init != null) {
            s.init = this.init.copyInline(ctx, valNeeded);
        }
        if (this.cond != null) {
            s.cond = this.cond.copyInline(ctx);
        }
        if (this.body != null) {
            s.body = this.body.copyInline(ctx, valNeeded);
        }
        if (this.inc != null) {
            s.inc = this.inc.copyInline(ctx);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 2;
        if (this.init != null) {
            cost += this.init.costInline(thresh, env, ctx);
        }
        if (this.cond != null) {
            cost += this.cond.costInline(thresh, env, ctx);
        }
        if (this.body != null) {
            cost += this.body.costInline(thresh, env, ctx);
        }
        if (this.inc != null) {
            cost += this.inc.costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext newctx = new CodeContext(ctx, this);
        if (this.init != null) {
            this.init.code(env, newctx, asm);
        }
        Label l1 = new Label();
        Label l2 = new Label();
        asm.add(this.where, 167, l2);
        asm.add(l1);
        if (this.body != null) {
            this.body.code(env, newctx, asm);
        }
        asm.add(newctx.contLabel);
        if (this.inc != null) {
            this.inc.code(env, newctx, asm);
        }
        asm.add(l2);
        if (this.cond != null) {
            this.cond.codeBranch(env, newctx, asm, l1, true);
        } else {
            asm.add(this.where, 167, l1);
        }
        asm.add(newctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("for (");
        if (this.init != null) {
            this.init.print(out, indent);
            out.print(" ");
        } else {
            out.print("; ");
        }
        if (this.cond != null) {
            this.cond.print(out);
            out.print(" ");
        }
        out.print("; ");
        if (this.inc != null) {
            this.inc.print(out);
        }
        out.print(") ");
        if (this.body != null) {
            this.body.print(out, indent);
        } else {
            out.print(";");
        }
    }
}

