/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.UnaryExpression;

public class NaryExpression
extends UnaryExpression {
    Expression[] args;

    NaryExpression(int op, long where, Type type, Expression right, Expression[] args) {
        super(op, where, type, right);
        this.args = args;
    }

    @Override
    public Expression copyInline(Context ctx) {
        NaryExpression e = (NaryExpression)this.clone();
        if (this.right != null) {
            e.right = this.right.copyInline(ctx);
        }
        e.args = new Expression[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            e.args[i] = this.args[i].copyInline(ctx);
        }
        return e;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 3;
        if (this.right != null) {
            cost += this.right.costInline(thresh, env, ctx);
        }
        for (int i = 0; i < this.args.length && cost < thresh; ++i) {
            if (this.args[i] == null) continue;
            cost += this.args[i].costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + "#" + this.hashCode());
        if (this.right != null) {
            out.print(" ");
            this.right.print(out);
        }
        for (int i = 0; i < this.args.length; ++i) {
            out.print(" ");
            if (this.args[i] != null) {
                this.args[i].print(out);
                continue;
            }
            out.print("<null>");
        }
        out.print(")");
    }
}

