/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.util;

import java.lang.reflect.Modifier;
import sun.tools.java.ClassDefinition;
import sun.tools.java.MemberDefinition;

public class ModifierFilter
extends Modifier {
    public static final long PACKAGE = Long.MIN_VALUE;
    public static final long ALL_ACCESS = -9223372036854775801L;
    private long oneOf;
    private long must;
    private long cannot;
    private static final int ACCESS_BITS = 7;

    public ModifierFilter(long oneOf) {
        this(oneOf, 0L, 0L);
    }

    public ModifierFilter(long oneOf, long must, long cannot) {
        this.oneOf = oneOf;
        this.must = must;
        this.cannot = cannot;
    }

    public boolean checkModifier(int modifierBits) {
        long fmod = (modifierBits & 7) == 0 ? (long)modifierBits | Long.MIN_VALUE : (long)modifierBits;
        return (this.oneOf == 0L || (this.oneOf & fmod) != 0L) && (this.must & fmod) == this.must && (this.cannot & fmod) == 0L;
    }

    public boolean checkMember(MemberDefinition field) {
        return this.checkModifier(field.getModifiers());
    }

    public boolean checkClass(ClassDefinition cdef) {
        return this.checkModifier(cdef.getModifiers());
    }
}

