/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.glassfish.rmic.BatchEnvironment;
import org.glassfish.rmic.Constants;
import org.glassfish.rmic.Generator;
import org.glassfish.rmic.Names;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassFile;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.ClassPath;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.javac.SourceClass;
import org.glassfish.rmic.tools.util.CommandLine;

public class Main
implements Constants {
    String sourcePathArg;
    String sysClassPathArg;
    String classPathString;
    File destDir;
    int flags;
    long tm;
    Vector<String> classes;
    boolean nowrite;
    boolean nocompile;
    boolean keepGenerated;
    boolean status;
    String[] generatorArgs;
    Vector<Generator> generators;
    Class<? extends BatchEnvironment> environmentClass = BatchEnvironment.class;
    boolean iiopGeneration = false;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;
    private static ResourceBundle resourcesExt;

    public Main(OutputStream out, String program) {
        this.out = out;
        this.program = program;
    }

    public void output(String msg) {
        PrintStream out = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        out.println(msg);
    }

    public void error(String msg) {
        this.output(Main.getText(msg));
    }

    public void error(String msg, String arg1) {
        this.output(Main.getText(msg, arg1));
    }

    public void error(String msg, String arg1, String arg2) {
        this.output(Main.getText(msg, arg1, arg2));
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }

    public synchronized boolean compile(String[] argv) {
        if (!this.parseArgs(argv)) {
            return false;
        }
        if (this.classes.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    public File getDestinationDir() {
        return this.destDir;
    }

    public boolean parseArgs(String ... argv) {
        int i;
        this.sourcePathArg = null;
        this.sysClassPathArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.flags = 4;
        this.tm = System.currentTimeMillis();
        this.classes = new Vector();
        this.nowrite = false;
        this.nocompile = false;
        this.keepGenerated = false;
        this.generatorArgs = this.getArray("generator.args", true);
        if (this.generatorArgs == null) {
            return false;
        }
        this.generators = new Vector();
        try {
            argv = CommandLine.parse(argv);
        }
        catch (FileNotFoundException e) {
            this.error("rmic.cant.read", e.getMessage());
            return false;
        }
        catch (IOException e) {
            e.printStackTrace(this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true));
            return false;
        }
        for (i = 0; i < argv.length; ++i) {
            if (argv[i] == null) continue;
            if (argv[i].equals("-g")) {
                this.flags &= 0xFFFFBFFF;
                this.flags |= 0x3000;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-O")) {
                this.flags &= 0xFFFFEFFF;
                this.flags &= 0xFFFFDFFF;
                this.flags |= 0x4020;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-nowarn")) {
                this.flags &= 0xFFFFFFFB;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-debug")) {
                this.flags |= 2;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-depend")) {
                this.flags |= 0x20;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-verbose")) {
                this.flags |= 1;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-nowrite")) {
                this.nowrite = true;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-Xnocompile")) {
                this.nocompile = true;
                this.keepGenerated = true;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-keep") || argv[i].equals("-keepgenerated")) {
                this.keepGenerated = true;
                argv[i] = null;
                continue;
            }
            if (argv[i].equals("-show")) {
                this.error("rmic.option.unsupported", "-show");
                this.usage();
                return false;
            }
            if (argv[i].equals("-classpath")) {
                if (i + 1 < argv.length) {
                    if (this.classPathString != null) {
                        this.error("rmic.option.already.seen", "-classpath");
                        this.usage();
                        return false;
                    }
                    argv[i] = null;
                    this.classPathString = argv[++i];
                    argv[i] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-classpath");
                this.usage();
                return false;
            }
            if (argv[i].equals("-sourcepath")) {
                if (i + 1 < argv.length) {
                    if (this.sourcePathArg != null) {
                        this.error("rmic.option.already.seen", "-sourcepath");
                        this.usage();
                        return false;
                    }
                    argv[i] = null;
                    this.sourcePathArg = argv[++i];
                    argv[i] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-sourcepath");
                this.usage();
                return false;
            }
            if (argv[i].equals("-bootclasspath")) {
                if (i + 1 < argv.length) {
                    if (this.sysClassPathArg != null) {
                        this.error("rmic.option.already.seen", "-bootclasspath");
                        this.usage();
                        return false;
                    }
                    argv[i] = null;
                    this.sysClassPathArg = argv[++i];
                    argv[i] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-bootclasspath");
                this.usage();
                return false;
            }
            if (argv[i].equals("-d")) {
                if (i + 1 < argv.length) {
                    if (this.destDir != null) {
                        this.error("rmic.option.already.seen", "-d");
                        this.usage();
                        return false;
                    }
                    argv[i] = null;
                    this.destDir = new File(argv[++i]);
                    argv[i] = null;
                    if (this.destDir.exists()) continue;
                    this.error("rmic.no.such.directory", this.destDir.getPath());
                    this.usage();
                    return false;
                }
                this.error("rmic.option.requires.argument", "-d");
                this.usage();
                return false;
            }
            if (this.checkGeneratorArg(argv, i)) continue;
            this.usage();
            return false;
        }
        for (i = 0; i < argv.length; ++i) {
            if (argv[i] == null) continue;
            if (argv[i].startsWith("-")) {
                this.error("rmic.no.such.option", argv[i]);
                this.usage();
                return false;
            }
            this.classes.addElement(argv[i]);
        }
        if (this.generators.size() == 0) {
            this.addGenerator("default");
        }
        return true;
    }

    protected boolean checkGeneratorArg(String[] argv, int currentIndex) {
        boolean result = true;
        if (argv[currentIndex].startsWith("-")) {
            String arg = argv[currentIndex].substring(1).toLowerCase();
            for (int i = 0; i < this.generatorArgs.length; ++i) {
                if (!arg.equalsIgnoreCase(this.generatorArgs[i])) continue;
                Generator gen = this.addGenerator(arg);
                if (gen == null) {
                    return false;
                }
                result = gen.parseArgs(argv, this);
                break;
            }
        }
        return result;
    }

    protected Generator addGenerator(String arg) {
        Generator gen;
        String className = Main.getString("generator.class." + arg);
        if (className == null) {
            this.error("rmic.missing.property", arg);
            return null;
        }
        try {
            gen = (Generator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            this.error("rmic.cannot.instantiate", className);
            return null;
        }
        this.generators.addElement(gen);
        Class envClass = BatchEnvironment.class;
        String env = Main.getString("generator.env." + arg);
        if (env != null) {
            try {
                envClass = Class.forName(env);
                if (this.environmentClass.isAssignableFrom(envClass)) {
                    this.environmentClass = envClass.asSubclass(BatchEnvironment.class);
                } else if (!envClass.isAssignableFrom(this.environmentClass)) {
                    this.error("rmic.cannot.use.both", this.environmentClass.getName(), envClass.getName());
                    return null;
                }
            }
            catch (ClassNotFoundException e) {
                this.error("rmic.class.not.found", env);
                return null;
            }
        }
        if (arg.equals("iiop")) {
            this.iiopGeneration = true;
        }
        return gen;
    }

    protected String[] getArray(String name, boolean mustExist) {
        String[] result = null;
        String value = Main.getString(name);
        if (value == null) {
            if (mustExist) {
                this.error("rmic.resource.not.found", name);
                return null;
            }
            return new String[0];
        }
        StringTokenizer parser = new StringTokenizer(value, ", \t\n\r", false);
        int count = parser.countTokens();
        result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = parser.nextToken();
        }
        return result;
    }

    public BatchEnvironment getEnv() {
        ClassPath classPath = BatchEnvironment.createClassPath(this.classPathString, this.sysClassPathArg);
        BatchEnvironment result = null;
        try {
            Class[] ctorArgTypes = new Class[]{OutputStream.class, ClassPath.class, File.class};
            Object[] ctorArgs = new Object[]{this.out, classPath, this.getDestinationDir()};
            Constructor<? extends BatchEnvironment> constructor = this.environmentClass.getConstructor(ctorArgTypes);
            result = constructor.newInstance(ctorArgs);
            result.reset();
        }
        catch (Exception e) {
            this.error("rmic.cannot.instantiate", this.environmentClass.getName());
        }
        return result;
    }

    private boolean doCompile() {
        BatchEnvironment env;
        block9: {
            env = this.getEnv();
            env.flags |= this.flags;
            env.majorVersion = (short)45;
            env.minorVersion = (short)3;
            String noMemoryErrorString = Main.getText("rmic.no.memory");
            String stackOverflowErrorString = Main.getText("rmic.stack.overflow");
            try {
                this.generateClasses(env);
                if (!this.nocompile) {
                    this.compileAllClasses(env);
                }
            }
            catch (OutOfMemoryError ee) {
                env.output(noMemoryErrorString);
                return false;
            }
            catch (StackOverflowError ee) {
                env.output(stackOverflowErrorString);
                return false;
            }
            catch (Error ee) {
                if (env.nerrors == 0 || env.dump()) {
                    env.error(0L, "fatal.error");
                    ee.printStackTrace(this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true));
                }
            }
            catch (Exception ee) {
                if (env.nerrors != 0 && !env.dump()) break block9;
                env.error(0L, "fatal.exception");
                ee.printStackTrace(this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true));
            }
        }
        env.flushErrors();
        boolean status = this.displayErrors(env);
        if (!this.keepGenerated) {
            env.deleteGeneratedFiles();
        }
        if (env.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(Main.getText("rmic.done_in", Long.toString(this.tm)));
        }
        env.shutdown();
        this.sourcePathArg = null;
        this.sysClassPathArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.classes = null;
        this.generatorArgs = null;
        this.generators = null;
        this.environmentClass = null;
        this.program = null;
        this.out = null;
        return status;
    }

    private void generateClasses(BatchEnvironment env) {
        for (String className : this.classes) {
            this.generateClass(env, Main.getClassIdentifier(env, className));
        }
    }

    void generateClass(BatchEnvironment env, Identifier implClassName) {
        ClassDeclaration decl = env.getClassDeclaration(implClassName);
        try {
            for (Generator gen : this.generators) {
                gen.generate(env, this.destDir, decl.getClassDefinition(env));
            }
        }
        catch (ClassNotFound ex) {
            env.error(0L, "rmic.class.not.found", implClassName);
        }
    }

    boolean displayErrors(BatchEnvironment env) {
        ArrayList<String> summary = new ArrayList<String>();
        if (env.nerrors > 0) {
            summary.add(this.getErrorSummary(env));
        }
        if (env.nwarnings > 0) {
            summary.add(this.getWarningSummary(env));
        }
        if (!summary.isEmpty()) {
            this.output(String.join((CharSequence)", ", summary));
        }
        return env.nerrors == 0;
    }

    private String getErrorSummary(BatchEnvironment env) {
        return env.nerrors == 1 ? Main.getText("rmic.1error") : Main.getText("rmic.errors", env.nerrors);
    }

    private String getWarningSummary(BatchEnvironment env) {
        return env.nwarnings == 1 ? Main.getText("rmic.1warning") : Main.getText("rmic.warnings", env.nwarnings);
    }

    static Identifier getClassIdentifier(BatchEnvironment env, String className) {
        Identifier implClassName = Identifier.lookup(className);
        implClassName = env.resolvePackageQualifiedName(implClassName);
        implClassName = Names.mangleClass(implClassName);
        return implClassName;
    }

    public void compileAllClasses(BatchEnvironment env) throws ClassNotFound, IOException, InterruptedException {
        boolean done;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4096);
        do {
            done = true;
            Enumeration<ClassDeclaration> e = env.getClasses();
            while (e.hasMoreElements()) {
                ClassDeclaration c = e.nextElement();
                done = this.compileClass(c, buf, env);
            }
        } while (!done);
    }

    public boolean compileClass(ClassDeclaration c, ByteArrayOutputStream buf, BatchEnvironment env) throws ClassNotFound, IOException, InterruptedException {
        boolean done = true;
        env.flushErrors();
        switch (c.getStatus()) {
            case 0: {
                if (!env.dependencies()) break;
            }
            case 3: {
                done = false;
                env.loadDefinition(c);
                if (c.getStatus() != 4) break;
            }
            case 4: {
                if (c.getClassDefinition().isInsideLocal()) break;
                if (this.nocompile) {
                    throw new IOException("Compilation required, but -Xnocompile option in effect");
                }
                done = false;
                SourceClass src = (SourceClass)c.getClassDefinition(env);
                src.check(env);
                c.setDefinition(src, 5);
            }
            case 5: {
                File file;
                SourceClass src = (SourceClass)c.getClassDefinition(env);
                if (src.getError()) {
                    c.setDefinition(src, 6);
                    break;
                }
                done = false;
                buf.reset();
                src.compile(buf);
                c.setDefinition(src, 6);
                src.cleanup(env);
                if (src.getError() || this.nowrite) break;
                String pkgName = c.getName().getQualifier().toString().replace('.', File.separatorChar);
                String className = c.getName().getFlatName().toString().replace('.', '$') + ".class";
                if (this.destDir != null) {
                    if (pkgName.length() > 0) {
                        file = new File(this.destDir, pkgName);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        file = new File(file, className);
                    } else {
                        file = new File(this.destDir, className);
                    }
                } else {
                    ClassFile classfile = (ClassFile)src.getSource();
                    if (classfile.isZipped()) {
                        env.error(0L, "cant.write", classfile.getPath());
                        break;
                    }
                    file = new File(classfile.getPath());
                    file = new File(file.getParent(), className);
                }
                try {
                    FileOutputStream out = new FileOutputStream(file.getPath());
                    buf.writeTo(out);
                    out.close();
                    if (!env.verbose()) break;
                    this.output(Main.getText("rmic.wrote", file.getPath()));
                    break;
                }
                catch (IOException ee) {
                    env.error(0L, "cant.write", file.getPath());
                }
            }
        }
        return done;
    }

    public static void main(String[] argv) {
        Main compiler = new Main(System.out, "rmic");
        System.exit(compiler.compile(argv) ? 0 : 1);
    }

    public static String getString(String key) {
        if (!resourcesInitialized) {
            Main.initResources();
        }
        if (resourcesExt != null) {
            try {
                return resourcesExt.getString(key);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("org.glassfish.rmic.resources.rmic");
            resourcesInitialized = true;
            try {
                resourcesExt = ResourceBundle.getBundle("org.glassfish.rmic.resources.rmicext");
            }
            catch (MissingResourceException e) {}
        }
        catch (MissingResourceException e) {
            throw new Error("fatal: missing resource bundle: " + e.getClassName());
        }
    }

    public static String getText(String key) {
        String message = Main.getString(key);
        if (message == null) {
            message = "no text found: \"" + key + "\"";
        }
        return message;
    }

    public static String getText(String key, int num) {
        return Main.getText(key, Integer.toString(num), null, null);
    }

    public static String getText(String key, String arg0) {
        return Main.getText(key, arg0, null, null);
    }

    public static String getText(String key, String arg0, String arg1) {
        return Main.getText(key, arg0, arg1, null);
    }

    public static String getText(String key, String arg0, String arg1, String arg2) {
        String format = Main.getString(key);
        if (format == null) {
            format = "no text found: key = \"" + key + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        String[] args = new String[]{arg0 != null ? arg0 : "null", arg1 != null ? arg1 : "null", arg2 != null ? arg2 : "null"};
        return MessageFormat.format(format, args);
    }

    String[] getGeneratedClassNames(BatchEnvironment environment) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassDeclaration declaration : environment.getGeneratedClasses()) {
            result.add(declaration.getName().toString());
        }
        return result.toArray(new String[result.size()]);
    }

    static {
        resourcesExt = null;
    }
}

