/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.glassfish.rmic.IndentingWriter;
import org.glassfish.rmic.Main;
import org.glassfish.rmic.iiop.ArrayType;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.ClassType;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.Generator;
import org.glassfish.rmic.iiop.ImplementationType;
import org.glassfish.rmic.iiop.InterfaceType;
import org.glassfish.rmic.iiop.RemoteType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.iiop.Util;
import org.glassfish.rmic.iiop.ValueType;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Identifier;

public class IDLGenerator
extends Generator {
    private boolean valueMethods = true;
    private boolean factory = true;
    private Hashtable ifHash = new Hashtable();
    private Hashtable imHash = new Hashtable();
    private boolean isThrown = true;
    private boolean isException = true;
    private boolean isForward = true;
    private boolean forValuetype = true;

    @Override
    protected File getOutputDirectory(File destinationDir, Identifier id, BatchEnvironment environment) {
        return Util.getOutputDirectoryForIDL(id, destinationDir, environment);
    }

    @Override
    protected boolean requireNewInstance() {
        return false;
    }

    @Override
    protected boolean parseNonConforming(ContextStack stack) {
        return this.valueMethods;
    }

    @Override
    protected CompoundType getTopType(ClassDefinition cdef, ContextStack stack) {
        return CompoundType.forCompound(cdef, stack);
    }

    @Override
    protected Identifier getOutputId(Generator.OutputType ot) {
        Identifier id = super.getOutputId(ot);
        Type t = ot.getType();
        String fName = ot.getName();
        if (id == idJavaLangClass) {
            if (t.isArray()) {
                return Identifier.lookup("org.omg.boxedRMI.javax.rmi.CORBA." + fName);
            }
            return idClassDesc;
        }
        if (id == idJavaLangString && t.isArray()) {
            return Identifier.lookup("org.omg.boxedRMI.CORBA." + fName);
        }
        if ("org.omg.CORBA.Object".equals(t.getQualifiedName()) && t.isArray()) {
            return Identifier.lookup("org.omg.boxedRMI." + fName);
        }
        if (t.isArray()) {
            ArrayType at = (ArrayType)t;
            Type et = at.getElementType();
            if (et.isCompound()) {
                CompoundType ct = (CompoundType)et;
                String qName = ct.getQualifiedName();
                if (ct.isIDLEntity()) {
                    return Identifier.lookup(this.getQualifiedName(at));
                }
            }
            return Identifier.lookup(idBoxedRMI, id);
        }
        if (t.isCompound()) {
            CompoundType ct = (CompoundType)t;
            String qName = ct.getQualifiedName();
            if (ct.isBoxed()) {
                return Identifier.lookup(this.getQualifiedName(ct));
            }
        }
        return id;
    }

    @Override
    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".idl";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean parseArgs(String[] argv, Main main) {
        boolean result = super.parseArgs(argv, main);
        if (result) {
            for (int i = 0; i < argv.length; ++i) {
                String idlTo;
                String idlFrom;
                if (argv[i] == null) continue;
                if (argv[i].equalsIgnoreCase("-idl")) {
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-valueMethods")) {
                    this.valueMethods = true;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-noValueMethods")) {
                    this.valueMethods = false;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-init")) {
                    this.factory = false;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-factory")) {
                    this.factory = true;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-idlfile")) {
                    argv[i] = null;
                    if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                        idlFrom = argv[i];
                        argv[i] = null;
                        if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                            idlTo = argv[i];
                            argv[i] = null;
                            this.ifHash.put(idlFrom, idlTo);
                            continue;
                        }
                    }
                    main.error("rmic.option.requires.argument", "-idlfile");
                    result = false;
                    continue;
                }
                if (!argv[i].equalsIgnoreCase("-idlmodule")) continue;
                argv[i] = null;
                if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                    idlFrom = argv[i];
                    argv[i] = null;
                    if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                        void var4_5;
                        idlTo = argv[i];
                        argv[i] = null;
                        this.imHash.put(var4_5, idlTo);
                        continue;
                    }
                }
                main.error("rmic.option.requires.argument", "-idlmodule");
                result = false;
            }
        }
        return result;
    }

    @Override
    protected Generator.OutputType[] getOutputTypesFor(CompoundType topType, HashSet alreadyChecked) {
        Vector refVec = this.getAllReferencesFor(topType);
        Vector<Generator.OutputType> outVec = new Vector<Generator.OutputType>();
        for (int i1 = 0; i1 < refVec.size(); ++i1) {
            ClassType ct;
            Type t = (Type)refVec.elementAt(i1);
            if (t.isArray()) {
                ArrayType at = (ArrayType)t;
                int dim = at.getArrayDimension();
                Type et = at.getElementType();
                String fName = this.unEsc(et.getIDLName()).replace(' ', '_');
                for (int i2 = 0; i2 < dim; ++i2) {
                    String fileName = "seq" + (i2 + 1) + "_" + fName;
                    outVec.addElement(new Generator.OutputType(this, fileName, at));
                }
                continue;
            }
            if (!t.isCompound()) continue;
            String fName = this.unEsc(t.getIDLName());
            outVec.addElement(new Generator.OutputType(this, fName.replace(' ', '_'), t));
            if (!t.isClass() || !(ct = (ClassType)t).isException()) continue;
            fName = this.unEsc(ct.getIDLExceptionName());
            outVec.addElement(new Generator.OutputType(this, fName.replace(' ', '_'), t));
        }
        Object[] outArr = new Generator.OutputType[outVec.size()];
        outVec.copyInto(outArr);
        return outArr;
    }

    protected Vector getAllReferencesFor(CompoundType ct) {
        CompoundType t;
        int refSize;
        Hashtable<String, CompoundType> refHash = new Hashtable<String, CompoundType>();
        Hashtable spcHash = new Hashtable();
        Hashtable arrHash = new Hashtable();
        refHash.put(ct.getQualifiedName(), ct);
        this.accumulateReferences(refHash, spcHash, arrHash);
        do {
            refSize = refHash.size();
            this.accumulateReferences(refHash, spcHash, arrHash);
        } while (refSize < refHash.size());
        Vector<Type> outVec = new Vector<Type>();
        Enumeration e = refHash.elements();
        while (e.hasMoreElements()) {
            t = (CompoundType)e.nextElement();
            outVec.addElement(t);
        }
        e = spcHash.elements();
        while (e.hasMoreElements()) {
            t = (CompoundType)e.nextElement();
            outVec.addElement(t);
        }
        e = arrHash.elements();
        block3: while (e.hasMoreElements()) {
            ArrayType at = (ArrayType)e.nextElement();
            int dim = at.getArrayDimension();
            Type et = at.getElementType();
            Enumeration e2 = arrHash.elements();
            while (e2.hasMoreElements()) {
                ArrayType at2 = (ArrayType)e2.nextElement();
                if (et != at2.getElementType() || dim >= at2.getArrayDimension()) continue;
                continue block3;
            }
            outVec.addElement(at);
        }
        return outVec;
    }

    protected void accumulateReferences(Hashtable refHash, Hashtable spcHash, Hashtable arrHash) {
        CompoundType t;
        Enumeration e = refHash.elements();
        while (e.hasMoreElements()) {
            t = (CompoundType)e.nextElement();
            Vector datVec = this.getData(t);
            Vector mthVec = this.getMethods(t);
            this.getInterfaces(t, refHash);
            this.getInheritance(t, refHash);
            this.getMethodReferences(mthVec, refHash, spcHash, arrHash, refHash);
            this.getMemberReferences(datVec, refHash, spcHash, arrHash);
        }
        e = arrHash.elements();
        while (e.hasMoreElements()) {
            ArrayType at = (ArrayType)e.nextElement();
            Type et = at.getElementType();
            this.addReference(et, refHash, spcHash, arrHash);
        }
        e = refHash.elements();
        while (e.hasMoreElements()) {
            t = (CompoundType)e.nextElement();
            if (this.isIDLGeneratedFor(t)) continue;
            refHash.remove(t.getQualifiedName());
        }
    }

    protected boolean isIDLGeneratedFor(CompoundType t) {
        if (t.isCORBAObject()) {
            return false;
        }
        if (t.isIDLEntity()) {
            if (t.isBoxed()) {
                return true;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(t.getQualifiedName())) {
                return true;
            }
            return t.isCORBAUserException();
        }
        Hashtable inhHash = new Hashtable();
        this.getInterfaces(t, inhHash);
        if (t.getTypeCode() == 65536) {
            return inhHash.size() >= 2;
        }
        return true;
    }

    @Override
    protected void writeOutputFor(Generator.OutputType ot, HashSet alreadyChecked, IndentingWriter p) throws IOException {
        CompoundType ct;
        Type t = ot.getType();
        if (t.isArray()) {
            this.writeSequence(ot, p);
            return;
        }
        if (this.isSpecialReference(t)) {
            this.writeSpecial(t, p);
            return;
        }
        if (t.isCompound() && (ct = (CompoundType)t).isIDLEntity() && ct.isBoxed()) {
            this.writeBoxedIDL(ct, p);
            return;
        }
        if (t.isClass() && (ct = (ClassType)t).isException()) {
            String eName = this.unEsc(ct.getIDLExceptionName());
            String fName = ot.getName();
            if (fName.equals(eName.replace(' ', '_'))) {
                this.writeException((ClassType)ct, p);
                return;
            }
        }
        switch (t.getTypeCode()) {
            case 65536: {
                this.writeImplementation((ImplementationType)t, p);
                break;
            }
            case 16384: 
            case 131072: {
                this.writeNCType((CompoundType)t, p);
                break;
            }
            case 4096: 
            case 8192: {
                this.writeRemote((RemoteType)t, p);
                break;
            }
            case 32768: {
                this.writeValue((ValueType)t, p);
                break;
            }
            default: {
                throw new CompilerError("IDLGenerator got unexpected type code: " + t.getTypeCode());
            }
        }
    }

    protected void writeImplementation(ImplementationType t, IndentingWriter p) throws IOException {
        Hashtable inhHash = new Hashtable();
        Hashtable refHash = new Hashtable();
        this.getInterfaces(t, inhHash);
        this.writeBanner(t, 0, !this.isException, p);
        this.writeInheritedIncludes(inhHash, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeIncOrb(p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.p("interface " + t.getIDLName());
        this.writeInherits(inhHash, !this.forValuetype, p);
        p.pln(" {");
        p.pln("};");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEpilog(t, refHash, p);
    }

    protected void writeNCType(CompoundType t, IndentingWriter p) throws IOException {
        Vector conVec = this.getConstants(t);
        Vector mthVec = this.getMethods(t);
        Hashtable inhHash = new Hashtable();
        Hashtable refHash = new Hashtable();
        Hashtable spcHash = new Hashtable();
        Hashtable arrHash = new Hashtable();
        Hashtable excHash = new Hashtable();
        this.getInterfaces(t, inhHash);
        this.getInheritance(t, inhHash);
        this.getMethodReferences(mthVec, refHash, spcHash, arrHash, excHash);
        this.writeProlog(t, refHash, spcHash, arrHash, excHash, inhHash, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.p("abstract valuetype " + t.getIDLName());
        this.writeInherits(inhHash, !this.forValuetype, p);
        p.pln(" {");
        if (conVec.size() + mthVec.size() > 0) {
            int i1;
            p.pln();
            p.pI();
            for (i1 = 0; i1 < conVec.size(); ++i1) {
                this.writeConstant((CompoundType.Member)conVec.elementAt(i1), p);
            }
            for (i1 = 0; i1 < mthVec.size(); ++i1) {
                this.writeMethod((CompoundType.Method)mthVec.elementAt(i1), p);
            }
            p.pO();
            p.pln();
        }
        p.pln("};");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEpilog(t, refHash, p);
    }

    protected void writeRemote(RemoteType t, IndentingWriter p) throws IOException {
        Vector conVec = this.getConstants(t);
        Vector mthVec = this.getMethods(t);
        Hashtable inhHash = new Hashtable();
        Hashtable refHash = new Hashtable();
        Hashtable spcHash = new Hashtable();
        Hashtable arrHash = new Hashtable();
        Hashtable excHash = new Hashtable();
        this.getInterfaces(t, inhHash);
        this.getMethodReferences(mthVec, refHash, spcHash, arrHash, excHash);
        this.writeProlog(t, refHash, spcHash, arrHash, excHash, inhHash, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        if (t.getTypeCode() == 8192) {
            p.p("abstract ");
        }
        p.p("interface " + t.getIDLName());
        this.writeInherits(inhHash, !this.forValuetype, p);
        p.pln(" {");
        if (conVec.size() + mthVec.size() > 0) {
            int i1;
            p.pln();
            p.pI();
            for (i1 = 0; i1 < conVec.size(); ++i1) {
                this.writeConstant((CompoundType.Member)conVec.elementAt(i1), p);
            }
            for (i1 = 0; i1 < mthVec.size(); ++i1) {
                this.writeMethod((CompoundType.Method)mthVec.elementAt(i1), p);
            }
            p.pO();
            p.pln();
        }
        p.pln("};");
        p.pO();
        p.pln();
        this.writeRepositoryID(t, p);
        p.pln();
        this.writeModule2(t, p);
        this.writeEpilog(t, refHash, p);
    }

    protected void writeValue(ValueType t, IndentingWriter p) throws IOException {
        Vector datVec = this.getData(t);
        Vector conVec = this.getConstants(t);
        Vector mthVec = this.getMethods(t);
        Hashtable inhHash = new Hashtable();
        Hashtable refHash = new Hashtable();
        Hashtable spcHash = new Hashtable();
        Hashtable arrHash = new Hashtable();
        Hashtable excHash = new Hashtable();
        this.getInterfaces(t, inhHash);
        this.getInheritance(t, inhHash);
        this.getMethodReferences(mthVec, refHash, spcHash, arrHash, excHash);
        this.getMemberReferences(datVec, refHash, spcHash, arrHash);
        this.writeProlog(t, refHash, spcHash, arrHash, excHash, inhHash, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        if (t.isCustom()) {
            p.p("custom ");
        }
        p.p("valuetype " + t.getIDLName());
        this.writeInherits(inhHash, this.forValuetype, p);
        p.pln(" {");
        if (conVec.size() + datVec.size() + mthVec.size() > 0) {
            CompoundType.Member mem;
            int i1;
            p.pln();
            p.pI();
            for (i1 = 0; i1 < conVec.size(); ++i1) {
                this.writeConstant((CompoundType.Member)conVec.elementAt(i1), p);
            }
            for (i1 = 0; i1 < datVec.size(); ++i1) {
                mem = (CompoundType.Member)datVec.elementAt(i1);
                if (!mem.getType().isPrimitive()) continue;
                this.writeData(mem, p);
            }
            for (i1 = 0; i1 < datVec.size(); ++i1) {
                mem = (CompoundType.Member)datVec.elementAt(i1);
                if (mem.getType().isPrimitive()) continue;
                this.writeData(mem, p);
            }
            for (i1 = 0; i1 < mthVec.size(); ++i1) {
                this.writeMethod((CompoundType.Method)mthVec.elementAt(i1), p);
            }
            p.pO();
            p.pln();
        }
        p.pln("};");
        p.pO();
        p.pln();
        this.writeRepositoryID(t, p);
        p.pln();
        this.writeModule2(t, p);
        this.writeEpilog(t, refHash, p);
    }

    protected void writeProlog(CompoundType t, Hashtable refHash, Hashtable spcHash, Hashtable arrHash, Hashtable excHash, Hashtable inhHash, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, !this.isException, p);
        this.writeForwardReferences(refHash, p);
        this.writeIncludes(excHash, this.isThrown, p);
        this.writeInheritedIncludes(inhHash, p);
        this.writeIncludes(spcHash, !this.isThrown, p);
        this.writeBoxedRMIIncludes(arrHash, p);
        this.writeIDLEntityIncludes(refHash, p);
        this.writeIncOrb(p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
    }

    protected void writeEpilog(CompoundType t, Hashtable refHash, IndentingWriter p) throws IOException {
        this.writeIncludes(refHash, !this.isThrown, p);
        this.writeEndif(p);
    }

    protected void writeSpecial(Type t, IndentingWriter p) throws IOException {
        String spcName = t.getQualifiedName();
        if ("java.io.Serializable".equals(spcName)) {
            this.writeJavaIoSerializable(t, p);
        } else if ("java.io.Externalizable".equals(spcName)) {
            this.writeJavaIoExternalizable(t, p);
        } else if ("java.lang.Object".equals(spcName)) {
            this.writeJavaLangObject(t, p);
        } else if ("java.rmi.Remote".equals(spcName)) {
            this.writeJavaRmiRemote(t, p);
        } else if ("org.omg.CORBA.portable.IDLEntity".equals(spcName)) {
            this.writeIDLEntity(t, p);
        }
    }

    protected void writeJavaIoSerializable(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, !this.isException, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any Serializable;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeJavaIoExternalizable(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, !this.isException, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any Externalizable;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeJavaLangObject(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, !this.isException, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any _Object;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeJavaRmiRemote(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, !this.isException, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef Object Remote;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeIDLEntity(Type t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, !this.isException, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("typedef any IDLEntity;");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void getInterfaces(CompoundType ct, Hashtable inhHash) {
        InterfaceType[] infs = ct.getInterfaces();
        block3: for (int i1 = 0; i1 < infs.length; ++i1) {
            String inhName = infs[i1].getQualifiedName();
            switch (ct.getTypeCode()) {
                case 32768: 
                case 131072: {
                    if (!"java.io.Externalizable".equals(inhName) && !"java.io.Serializable".equals(inhName) && !"org.omg.CORBA.portable.IDLEntity".equals(inhName)) break;
                    continue block3;
                }
                default: {
                    if ("java.rmi.Remote".equals(inhName)) continue block3;
                }
            }
            inhHash.put(inhName, infs[i1]);
        }
    }

    protected void getInheritance(CompoundType ct, Hashtable inhHash) {
        ClassType par = ct.getSuperclass();
        if (par == null) {
            return;
        }
        String parName = par.getQualifiedName();
        switch (ct.getTypeCode()) {
            case 32768: 
            case 131072: {
                if (!"java.lang.Object".equals(parName)) break;
                return;
            }
            default: {
                return;
            }
        }
        inhHash.put(parName, par);
    }

    protected void getMethodReferences(Vector mthVec, Hashtable refHash, Hashtable spcHash, Hashtable arrHash, Hashtable excHash) {
        for (int i1 = 0; i1 < mthVec.size(); ++i1) {
            CompoundType.Method mth = (CompoundType.Method)mthVec.elementAt(i1);
            Type[] args = mth.getArguments();
            Type ret = mth.getReturnType();
            this.getExceptions(mth, excHash);
            for (int i2 = 0; i2 < args.length; ++i2) {
                this.addReference(args[i2], refHash, spcHash, arrHash);
            }
            this.addReference(ret, refHash, spcHash, arrHash);
        }
    }

    protected void getMemberReferences(Vector datVec, Hashtable refHash, Hashtable spcHash, Hashtable arrHash) {
        for (int i1 = 0; i1 < datVec.size(); ++i1) {
            CompoundType.Member mem = (CompoundType.Member)datVec.elementAt(i1);
            Type dat = mem.getType();
            this.addReference(dat, refHash, spcHash, arrHash);
        }
    }

    protected void addReference(Type ref, Hashtable refHash, Hashtable spcHash, Hashtable arrHash) {
        String rName = ref.getQualifiedName();
        switch (ref.getTypeCode()) {
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 131072: {
                refHash.put(rName, ref);
                return;
            }
            case 2048: {
                if ("org.omg.CORBA.Object".equals(rName)) {
                    return;
                }
                refHash.put(rName, ref);
                return;
            }
            case 262144: {
                arrHash.put(rName + ref.getArrayDimension(), ref);
                return;
            }
        }
        if (this.isSpecialReference(ref)) {
            spcHash.put(rName, ref);
        }
    }

    protected boolean isSpecialReference(Type ref) {
        String rName = ref.getQualifiedName();
        if ("java.io.Serializable".equals(rName)) {
            return true;
        }
        if ("java.io.Externalizable".equals(rName)) {
            return true;
        }
        if ("java.lang.Object".equals(rName)) {
            return true;
        }
        if ("java.rmi.Remote".equals(rName)) {
            return true;
        }
        return "org.omg.CORBA.portable.IDLEntity".equals(rName);
    }

    protected void getExceptions(CompoundType.Method mth, Hashtable excHash) {
        ValueType[] excs = mth.getExceptions();
        for (int i1 = 0; i1 < excs.length; ++i1) {
            ValueType exc = excs[i1];
            if (!exc.isCheckedException() || exc.isRemoteExceptionOrSubclass()) continue;
            excHash.put(exc.getQualifiedName(), exc);
        }
    }

    protected Vector getMethods(CompoundType ct) {
        Vector<CompoundType.Method> vec = new Vector<CompoundType.Method>();
        int ctType = ct.getTypeCode();
        switch (ctType) {
            case 4096: 
            case 8192: {
                break;
            }
            case 16384: 
            case 32768: 
            case 131072: {
                if (this.valueMethods) break;
            }
            default: {
                return vec;
            }
        }
        Identifier ctId = ct.getIdentifier();
        CompoundType.Method[] mths = ct.getMethods();
        for (int i1 = 0; i1 < mths.length; ++i1) {
            String mthName;
            if (mths[i1].isPrivate() || mths[i1].isInherited() || ctType == 32768 && ("readObject".equals(mthName = mths[i1].getName()) || "writeObject".equals(mthName) || "readExternal".equals(mthName) || "writeExternal".equals(mthName)) || (ctType == 131072 || ctType == 16384) && mths[i1].isConstructor()) continue;
            vec.addElement(mths[i1]);
        }
        return vec;
    }

    protected Vector getConstants(CompoundType ct) {
        Vector<CompoundType.Member> vec = new Vector<CompoundType.Member>();
        CompoundType.Member[] mems = ct.getMembers();
        for (int i1 = 0; i1 < mems.length; ++i1) {
            Type memType = mems[i1].getType();
            String memValue = mems[i1].getValue();
            if (!mems[i1].isPublic() || !mems[i1].isFinal() || !mems[i1].isStatic() || !memType.isPrimitive() && !"String".equals(memType.getName()) || memValue == null) continue;
            vec.addElement(mems[i1]);
        }
        return vec;
    }

    protected Vector getData(CompoundType t) {
        Vector<CompoundType.Member> vec = new Vector<CompoundType.Member>();
        if (t.getTypeCode() != 32768) {
            return vec;
        }
        ValueType vt = (ValueType)t;
        CompoundType.Member[] mems = vt.getMembers();
        boolean notCust = !vt.isCustom();
        for (int i1 = 0; i1 < mems.length; ++i1) {
            CompoundType.Member aMem;
            int i2;
            if (mems[i1].isStatic() || mems[i1].isTransient() || !mems[i1].isPublic() && !notCust) continue;
            String memName = mems[i1].getName();
            for (i2 = 0; i2 < vec.size() && memName.compareTo((aMem = (CompoundType.Member)vec.elementAt(i2)).getName()) >= 0; ++i2) {
            }
            vec.insertElementAt(mems[i1], i2);
        }
        return vec;
    }

    protected void writeForwardReferences(Hashtable refHash, IndentingWriter p) throws IOException {
        Enumeration refEnum = refHash.elements();
        while (refEnum.hasMoreElements()) {
            CompoundType ct;
            Type t = (Type)refEnum.nextElement();
            if (t.isCompound() && (ct = (CompoundType)t).isIDLEntity()) continue;
            this.writeForwardReference(t, p);
        }
    }

    protected void writeForwardReference(Type t, IndentingWriter p) throws IOException {
        String qName = t.getQualifiedName();
        if (!"java.lang.String".equals(qName) && "org.omg.CORBA.Object".equals(qName)) {
            return;
        }
        this.writeIfndef(t, 0, !this.isException, this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        switch (t.getTypeCode()) {
            case 16384: 
            case 131072: {
                p.p("abstract valuetype ");
                break;
            }
            case 8192: {
                p.p("abstract interface ");
                break;
            }
            case 32768: {
                p.p("valuetype ");
                break;
            }
            case 2048: 
            case 4096: {
                p.p("interface ");
                break;
            }
        }
        p.pln(t.getIDLName() + ";");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeForwardReference(ArrayType at, int dim, IndentingWriter p) throws IOException {
        Type et = at.getElementType();
        if (dim < 1) {
            if (et.isCompound()) {
                CompoundType ct = (CompoundType)et;
                this.writeForwardReference(et, p);
            }
            return;
        }
        String fName = this.unEsc(et.getIDLName()).replace(' ', '_');
        this.writeIfndef(at, dim, !this.isException, this.isForward, p);
        this.writeModule1(at, p);
        p.pln();
        p.pI();
        switch (et.getTypeCode()) {
            case 16384: 
            case 131072: {
                p.p("abstract valuetype ");
                break;
            }
            case 8192: {
                p.p("abstract interface ");
                break;
            }
            case 32768: {
                p.p("valuetype ");
                break;
            }
            case 2048: 
            case 4096: {
                p.p("interface ");
                break;
            }
        }
        p.pln("seq" + dim + "_" + fName + ";");
        p.pO();
        p.pln();
        this.writeModule2(at, p);
        this.writeEndif(p);
    }

    protected void writeIDLEntityIncludes(Hashtable refHash, IndentingWriter p) throws IOException {
        Enumeration refEnum = refHash.elements();
        while (refEnum.hasMoreElements()) {
            CompoundType ct;
            Type t = (Type)refEnum.nextElement();
            if (!t.isCompound() || !(ct = (CompoundType)t).isIDLEntity()) continue;
            this.writeInclude((Type)ct, 0, !this.isThrown, p);
            refHash.remove(ct.getQualifiedName());
        }
    }

    protected void writeIncludes(Hashtable incHash, boolean isThrown, IndentingWriter p) throws IOException {
        Enumeration incEnum = incHash.elements();
        while (incEnum.hasMoreElements()) {
            CompoundType t = (CompoundType)incEnum.nextElement();
            this.writeInclude((Type)t, 0, isThrown, p);
        }
    }

    protected void writeBoxedRMIIncludes(Hashtable arrHash, IndentingWriter p) throws IOException {
        Enumeration e1 = arrHash.elements();
        block0: while (e1.hasMoreElements()) {
            ArrayType at = (ArrayType)e1.nextElement();
            int dim = at.getArrayDimension();
            Type et = at.getElementType();
            Enumeration e2 = arrHash.elements();
            while (e2.hasMoreElements()) {
                ArrayType at2 = (ArrayType)e2.nextElement();
                if (et != at2.getElementType() || dim >= at2.getArrayDimension()) continue;
                continue block0;
            }
            this.writeInclude((Type)at, dim, !this.isThrown, p);
        }
    }

    protected void writeInheritedIncludes(Hashtable inhHash, IndentingWriter p) throws IOException {
        Enumeration inhEnum = inhHash.elements();
        while (inhEnum.hasMoreElements()) {
            CompoundType t = (CompoundType)inhEnum.nextElement();
            this.writeInclude((Type)t, 0, !this.isThrown, p);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeInclude(Type t, int dim, boolean isThrown, IndentingWriter p) throws IOException {
        String tName;
        String[] modNames;
        if (t.isCompound()) {
            CompoundType ct = (CompoundType)t;
            String qName = ct.getQualifiedName();
            if ("java.lang.String".equals(qName)) {
                this.writeIncOrb(p);
                return;
            }
            if ("org.omg.CORBA.Object".equals(qName)) {
                return;
            }
            modNames = this.getIDLModuleNames(ct);
            tName = this.unEsc(ct.getIDLName());
            if (ct.isException()) {
                if (ct.isIDLEntityException()) {
                    if (ct.isCORBAUserException()) {
                        if (isThrown) {
                            tName = this.unEsc(ct.getIDLExceptionName());
                        }
                    } else {
                        tName = ct.getName();
                    }
                } else if (isThrown) {
                    tName = this.unEsc(ct.getIDLExceptionName());
                }
            }
        } else {
            if (!t.isArray()) return;
            Type et = t.getElementType();
            if (dim > 0) {
                modNames = this.getIDLModuleNames(t);
                tName = "seq" + dim + "_" + this.unEsc(et.getIDLName().replace(' ', '_'));
            } else {
                if (!et.isCompound()) {
                    return;
                }
                CompoundType ct = (CompoundType)et;
                String[] modNames2 = this.getIDLModuleNames(ct);
                String tName2 = this.unEsc(ct.getIDLName());
                this.writeInclude((Type)ct, modNames2, tName2, p);
                return;
            }
        }
        this.writeInclude(t, modNames, tName, p);
    }

    protected void writeInclude(Type t, String[] modNames, String tName, IndentingWriter p) throws IOException {
        if (t.isCompound()) {
            CompoundType it = (CompoundType)t;
            if (this.ifHash.size() > 0 && it.isIDLEntity()) {
                String qName = t.getQualifiedName();
                Enumeration k = this.ifHash.keys();
                while (k.hasMoreElements()) {
                    String from = (String)k.nextElement();
                    if (!qName.startsWith(from)) continue;
                    String to = (String)this.ifHash.get(from);
                    p.pln("#include \"" + to + "\"");
                    return;
                }
            }
        } else if (!t.isArray()) {
            return;
        }
        p.p("#include \"");
        for (int i1 = 0; i1 < modNames.length; ++i1) {
            p.p(modNames[i1] + "/");
        }
        p.p(tName + ".idl\"");
        p.pln();
    }

    protected String getQualifiedName(Type t) {
        String[] modNames = this.getIDLModuleNames(t);
        int len = modNames.length;
        StringBuffer buf = new StringBuffer();
        for (int i1 = 0; i1 < len; ++i1) {
            buf.append(modNames[i1] + ".");
        }
        buf.append(t.getIDLName());
        return buf.toString();
    }

    protected String getQualifiedIDLName(Type t) {
        if (t.isPrimitive()) {
            return t.getIDLName();
        }
        if (!t.isArray() && "org.omg.CORBA.Object".equals(t.getQualifiedName())) {
            return t.getIDLName();
        }
        String[] modNames = this.getIDLModuleNames(t);
        int len = modNames.length;
        if (len > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i1 = 0; i1 < len; ++i1) {
                buf.append("::" + modNames[i1]);
            }
            buf.append("::" + t.getIDLName());
            return buf.toString();
        }
        return t.getIDLName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] getIDLModuleNames(Type t) {
        Vector<String> mVec;
        CompoundType ct;
        String[] modNames = t.getIDLModuleNames();
        if (t.isCompound()) {
            ct = (CompoundType)t;
            if (!ct.isIDLEntity) {
                return modNames;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(t.getQualifiedName())) {
                return modNames;
            }
        } else {
            if (!t.isArray()) return modNames;
            Type et = t.getElementType();
            if (!et.isCompound()) return modNames;
            ct = (CompoundType)et;
            if (!ct.isIDLEntity) {
                return modNames;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(t.getQualifiedName())) {
                return modNames;
            }
        }
        if (!this.translateJavaPackage(ct, mVec = new Vector<String>())) {
            this.stripJavaPackage(ct, mVec);
        }
        if (ct.isBoxed()) {
            mVec.insertElementAt("org", 0);
            mVec.insertElementAt("omg", 1);
            mVec.insertElementAt("boxedIDL", 2);
        }
        if (t.isArray()) {
            mVec.insertElementAt("org", 0);
            mVec.insertElementAt("omg", 1);
            mVec.insertElementAt("boxedRMI", 2);
        }
        Object[] outArr = new String[mVec.size()];
        mVec.copyInto(outArr);
        return outArr;
    }

    protected boolean translateJavaPackage(CompoundType ct, Vector vec) {
        vec.removeAllElements();
        boolean ret = false;
        String fc = null;
        if (!ct.isIDLEntity()) {
            return ret;
        }
        String pName = ct.getPackageName();
        if (pName == null) {
            return ret;
        }
        StringTokenizer pt = new StringTokenizer(pName, ".");
        while (pt.hasMoreTokens()) {
            vec.addElement(pt.nextToken());
        }
        if (this.imHash.size() > 0) {
            Enumeration k = this.imHash.keys();
            block1: while (k.hasMoreElements()) {
                int ifr;
                String from = (String)k.nextElement();
                StringTokenizer ft = new StringTokenizer(from, ".");
                int vecLen = vec.size();
                for (ifr = 0; ifr < vecLen && ft.hasMoreTokens(); ++ifr) {
                    if (!vec.elementAt(ifr).equals(ft.nextToken())) continue block1;
                }
                if (ft.hasMoreTokens()) {
                    fc = ft.nextToken();
                    if (!ct.getName().equals(fc) || ft.hasMoreTokens()) continue;
                }
                ret = true;
                for (int i4 = 0; i4 < ifr; ++i4) {
                    vec.removeElementAt(0);
                }
                String to = (String)this.imHash.get(from);
                StringTokenizer tt = new StringTokenizer(to, "::");
                int itoco = tt.countTokens();
                int ito = 0;
                if (fc != null) {
                    --itoco;
                }
                for (ito = 0; ito < itoco; ++ito) {
                    vec.insertElementAt(tt.nextToken(), ito);
                }
                if (fc == null) continue;
                String tc = tt.nextToken();
                if (ct.getName().equals(tc)) continue;
                vec.insertElementAt(tc, ito);
            }
        }
        return ret;
    }

    protected void stripJavaPackage(CompoundType ct, Vector vec) {
        vec.removeAllElements();
        if (!ct.isIDLEntity()) {
            return;
        }
        String repID = ct.getRepositoryID().substring(4);
        StringTokenizer rept = new StringTokenizer(repID, "/");
        if (rept.countTokens() < 2) {
            return;
        }
        while (rept.hasMoreTokens()) {
            vec.addElement(rept.nextToken());
        }
        vec.removeElementAt(vec.size() - 1);
        String pName = ct.getPackageName();
        if (pName == null) {
            return;
        }
        Vector<String> pVec = new Vector<String>();
        StringTokenizer pt = new StringTokenizer(pName, ".");
        while (pt.hasMoreTokens()) {
            pVec.addElement(pt.nextToken());
        }
        int i1 = vec.size() - 1;
        for (int i2 = pVec.size() - 1; i1 >= 0 && i2 >= 0; --i1, --i2) {
            String rep = (String)vec.elementAt(i1);
            String pkg = (String)pVec.elementAt(i2);
            if (!pkg.equals(rep)) break;
        }
        for (int i3 = 0; i3 <= i1; ++i3) {
            vec.removeElementAt(0);
        }
    }

    protected void writeSequence(Generator.OutputType ot, IndentingWriter p) throws IOException {
        ArrayType at = (ArrayType)ot.getType();
        Type et = at.getElementType();
        String fName = ot.getName();
        int dim = Integer.parseInt(fName.substring(3, fName.indexOf("_")));
        String idlName = this.unEsc(et.getIDLName()).replace(' ', '_');
        String qIdlName = this.getQualifiedIDLName(et);
        String qName = et.getQualifiedName();
        String repID = at.getRepositoryID();
        int rix1 = repID.indexOf(91);
        int rix2 = repID.lastIndexOf(91) + 1;
        StringBuffer rid = new StringBuffer(repID.substring(0, rix1) + repID.substring(rix2));
        for (int i1 = 0; i1 < dim; ++i1) {
            rid.insert(rix1, '[');
        }
        String vtName = "seq" + dim + "_" + idlName;
        boolean isFromIDL = false;
        if (et.isCompound()) {
            CompoundType ct = (CompoundType)et;
            isFromIDL = ct.isIDLEntity() || ct.isCORBAObject();
        }
        boolean isForwardInclude = et.isCompound() && !this.isSpecialReference(et) && dim == 1 && !isFromIDL && !"org.omg.CORBA.Object".equals(qName) && !"java.lang.String".equals(qName);
        this.writeBanner(at, dim, !this.isException, p);
        if (dim == 1 && "java.lang.String".equals(qName)) {
            this.writeIncOrb(p);
        }
        if (!(dim == 1 && "org.omg.CORBA.Object".equals(qName) || !this.isSpecialReference(et) && dim <= 1 && !isFromIDL)) {
            this.writeInclude((Type)at, dim - 1, !this.isThrown, p);
        }
        this.writeIfndef(at, dim, !this.isException, !this.isForward, p);
        if (isForwardInclude) {
            this.writeForwardReference(at, dim - 1, p);
        }
        this.writeModule1(at, p);
        p.pln();
        p.pI();
        p.p("valuetype " + vtName);
        p.p(" sequence<");
        if (dim == 1) {
            p.p(qIdlName);
        } else {
            p.p("seq" + (dim - 1) + "_");
            p.p(idlName);
        }
        p.pln(">;");
        p.pO();
        p.pln();
        p.pln("#pragma ID " + vtName + " \"" + rid + "\"");
        p.pln();
        this.writeModule2(at, p);
        if (isForwardInclude) {
            this.writeInclude((Type)at, dim - 1, !this.isThrown, p);
        }
        this.writeEndif(p);
    }

    protected void writeBoxedIDL(CompoundType t, IndentingWriter p) throws IOException {
        String[] boxNames = this.getIDLModuleNames(t);
        int len = boxNames.length;
        String[] modNames = new String[len - 3];
        for (int i1 = 0; i1 < len - 3; ++i1) {
            modNames[i1] = boxNames[i1 + 3];
        }
        String tName = this.unEsc(t.getIDLName());
        this.writeBanner(t, 0, !this.isException, p);
        this.writeInclude((Type)t, modNames, tName, p);
        this.writeIfndef(t, 0, !this.isException, !this.isForward, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.p("valuetype " + tName + " ");
        for (int i1 = 0; i1 < modNames.length; ++i1) {
            p.p("::" + modNames[i1]);
        }
        p.pln("::" + tName + ";");
        p.pO();
        p.pln();
        this.writeRepositoryID(t, p);
        p.pln();
        this.writeModule2(t, p);
        this.writeEndif(p);
    }

    protected void writeException(ClassType t, IndentingWriter p) throws IOException {
        this.writeBanner(t, 0, this.isException, p);
        this.writeIfndef(t, 0, this.isException, !this.isForward, p);
        this.writeForwardReference(t, p);
        this.writeModule1(t, p);
        p.pln();
        p.pI();
        p.pln("exception " + t.getIDLExceptionName() + " {");
        p.pln();
        p.pI();
        p.pln(t.getIDLName() + " value;");
        p.pO();
        p.pln();
        p.pln("};");
        p.pO();
        p.pln();
        this.writeModule2(t, p);
        this.writeInclude((Type)t, 0, !this.isThrown, p);
        this.writeEndif(p);
    }

    protected void writeRepositoryID(Type t, IndentingWriter p) throws IOException {
        CompoundType ct;
        String repid = t.getRepositoryID();
        if (t.isCompound() && (ct = (CompoundType)t).isBoxed()) {
            repid = ct.getBoxedRepositoryID();
        }
        p.pln("#pragma ID " + t.getIDLName() + " \"" + repid + "\"");
    }

    protected void writeInherits(Hashtable inhHash, boolean forValuetype, IndentingWriter p) throws IOException {
        int i;
        CompoundType ct;
        int itot = inhHash.size();
        int iinh = 0;
        int isup = 0;
        if (itot < 1) {
            return;
        }
        Enumeration inhEnum = inhHash.elements();
        if (forValuetype) {
            while (inhEnum.hasMoreElements()) {
                ct = (CompoundType)inhEnum.nextElement();
                if (ct.getTypeCode() != 8192) continue;
                ++isup;
            }
        }
        if ((iinh = itot - isup) > 0) {
            p.p(": ");
            inhEnum = inhHash.elements();
            while (inhEnum.hasMoreElements()) {
                ct = (CompoundType)inhEnum.nextElement();
                if (!ct.isClass()) continue;
                p.p(this.getQualifiedIDLName(ct));
                if (iinh > 1) {
                    p.p(", ");
                    break;
                }
                if (itot <= 1) break;
                p.p(" ");
                break;
            }
            i = 0;
            inhEnum = inhHash.elements();
            while (inhEnum.hasMoreElements()) {
                ct = (CompoundType)inhEnum.nextElement();
                if (ct.isClass() || ct.getTypeCode() == 8192) continue;
                if (i++ > 0) {
                    p.p(", ");
                }
                p.p(this.getQualifiedIDLName(ct));
            }
        }
        if (isup > 0) {
            p.p(" supports ");
            i = 0;
            inhEnum = inhHash.elements();
            while (inhEnum.hasMoreElements()) {
                ct = (CompoundType)inhEnum.nextElement();
                if (ct.getTypeCode() != 8192) continue;
                if (i++ > 0) {
                    p.p(", ");
                }
                p.p(this.getQualifiedIDLName(ct));
            }
        }
    }

    protected void writeConstant(CompoundType.Member constant, IndentingWriter p) throws IOException {
        Type t = constant.getType();
        p.p("const ");
        p.p(this.getQualifiedIDLName(t));
        p.p(" " + constant.getIDLName() + " = " + constant.getValue());
        p.pln(";");
    }

    protected void writeData(CompoundType.Member data, IndentingWriter p) throws IOException {
        if (data.isInnerClassDeclaration()) {
            return;
        }
        Type t = data.getType();
        if (data.isPublic()) {
            p.p("public ");
        } else {
            p.p("private ");
        }
        p.pln(this.getQualifiedIDLName(t) + " " + data.getIDLName() + ";");
    }

    protected void writeAttribute(CompoundType.Method attr, IndentingWriter p) throws IOException {
        if (attr.getAttributeKind() == 5) {
            return;
        }
        Type t = attr.getReturnType();
        if (!attr.isReadWriteAttribute()) {
            p.p("readonly ");
        }
        p.p("attribute " + this.getQualifiedIDLName(t) + " ");
        p.pln(attr.getAttributeName() + ";");
    }

    protected void writeMethod(CompoundType.Method method, IndentingWriter p) throws IOException {
        int i;
        if (method.isAttribute()) {
            this.writeAttribute(method, p);
            return;
        }
        Type[] pts = method.getArguments();
        String[] paramNames = method.getArgumentNames();
        Type rt = method.getReturnType();
        Hashtable excHash = new Hashtable();
        this.getExceptions(method, excHash);
        if (method.isConstructor()) {
            if (this.factory) {
                p.p("factory " + method.getIDLName() + "(");
            } else {
                p.p("init(");
            }
        } else {
            p.p(this.getQualifiedIDLName(rt));
            p.p(" " + method.getIDLName() + "(");
        }
        p.pI();
        for (i = 0; i < pts.length; ++i) {
            if (i > 0) {
                p.pln(",");
            } else {
                p.pln();
            }
            p.p("in ");
            p.p(this.getQualifiedIDLName(pts[i]));
            p.p(" " + paramNames[i]);
        }
        p.pO();
        p.p(" )");
        if (excHash.size() > 0) {
            p.pln(" raises (");
            p.pI();
            i = 0;
            Enumeration excEnum = excHash.elements();
            while (excEnum.hasMoreElements()) {
                ValueType exc = (ValueType)excEnum.nextElement();
                if (i > 0) {
                    p.pln(",");
                }
                if (exc.isIDLEntityException()) {
                    if (exc.isCORBAUserException()) {
                        p.p("::org::omg::CORBA::UserEx");
                    } else {
                        String[] modNames = this.getIDLModuleNames(exc);
                        for (int i2 = 0; i2 < modNames.length; ++i2) {
                            p.p("::" + modNames[i2]);
                        }
                        p.p("::" + exc.getName());
                    }
                } else {
                    p.p(exc.getQualifiedIDLExceptionName(true));
                }
                ++i;
            }
            p.pO();
            p.p(" )");
        }
        p.pln(";");
    }

    protected String unEsc(String name) {
        if (name.startsWith("_")) {
            return name.substring(1);
        }
        return name;
    }

    protected void writeBanner(Type t, int dim, boolean isException, IndentingWriter p) throws IOException {
        String[] modNames = this.getIDLModuleNames(t);
        String fName = this.unEsc(t.getIDLName());
        if (isException && t.isClass()) {
            ClassType ct = (ClassType)t;
            fName = this.unEsc(ct.getIDLExceptionName());
        }
        if (dim > 0 && t.isArray()) {
            Type et = t.getElementType();
            fName = "seq" + dim + "_" + this.unEsc(et.getIDLName().replace(' ', '_'));
        }
        p.pln("/**");
        p.p(" * ");
        for (int i1 = 0; i1 < modNames.length; ++i1) {
            p.p(modNames[i1] + "/");
        }
        p.pln(fName + ".idl");
        p.pln(" * Generated by rmic -idl. Do not edit");
        String d = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault()).format(new Date());
        String ocStr = "o'clock";
        int ocx = d.indexOf(ocStr);
        p.p(" * ");
        if (ocx > -1) {
            p.pln(d.substring(0, ocx) + d.substring(ocx + ocStr.length()));
        } else {
            p.pln(d);
        }
        p.pln(" */");
        p.pln();
    }

    protected void writeIncOrb(IndentingWriter p) throws IOException {
        p.pln("#include \"orb.idl\"");
    }

    protected void writeIfndef(Type t, int dim, boolean isException, boolean isForward, IndentingWriter p) throws IOException {
        int i;
        String[] modNames = this.getIDLModuleNames(t);
        String fName = this.unEsc(t.getIDLName());
        if (isException && t.isClass()) {
            ClassType ct = (ClassType)t;
            fName = this.unEsc(ct.getIDLExceptionName());
        }
        if (dim > 0 && t.isArray()) {
            Type et = t.getElementType();
            fName = "seq" + dim + "_" + this.unEsc(et.getIDLName().replace(' ', '_'));
        }
        p.pln();
        p.p("#ifndef __");
        for (i = 0; i < modNames.length; ++i) {
            p.p(modNames[i] + "_");
        }
        p.pln(fName + "__");
        if (!isForward) {
            p.p("#define __");
            for (i = 0; i < modNames.length; ++i) {
                p.p(modNames[i] + "_");
            }
            p.pln(fName + "__");
            p.pln();
        }
    }

    protected void writeEndif(IndentingWriter p) throws IOException {
        p.pln("#endif");
        p.pln();
    }

    protected void writeModule1(Type t, IndentingWriter p) throws IOException {
        String[] modNames = this.getIDLModuleNames(t);
        p.pln();
        for (int i = 0; i < modNames.length; ++i) {
            p.pln("module " + modNames[i] + " {");
        }
    }

    protected void writeModule2(Type t, IndentingWriter p) throws IOException {
        String[] modNames = this.getIDLModuleNames(t);
        for (int i = 0; i < modNames.length; ++i) {
            p.pln("};");
        }
        p.pln();
    }
}

