/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.rmic.Names;
import org.glassfish.rmic.asm.AsmClass;
import org.glassfish.rmic.asm.AsmMemberDefinition;
import org.glassfish.rmic.asm.TypeFactory;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassDefinitionFactory;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.Type;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class AsmClassFactory
implements ClassDefinitionFactory {
    private static final Boolean simulateMissingASM = false;
    private Map<Identifier, Identifier> outerClasses = new HashMap<Identifier, Identifier>();

    public AsmClassFactory() {
        if (simulateMissingASM.booleanValue()) {
            throw new NoClassDefFoundError();
        }
    }

    static int getLatestVersion() {
        try {
            int latest = 0;
            for (Field field : Opcodes.class.getDeclaredFields()) {
                if (!field.getName().startsWith("ASM") || !field.getType().equals(Integer.TYPE)) continue;
                latest = Math.max(latest, field.getInt(Opcodes.class));
            }
            return latest;
        }
        catch (IllegalAccessException e) {
            return 393216;
        }
    }

    Identifier getOuterClassName(Identifier className) {
        if (this.isResolvedInnerClassName(className)) {
            className = Names.mangleClass(className);
        }
        return this.outerClasses.get(className);
    }

    private boolean isResolvedInnerClassName(Identifier className) {
        return className.toString().contains(". ");
    }

    @Override
    public ClassDefinition loadDefinition(InputStream is, Environment env) throws IOException {
        ClassDefinitionVisitor visitor = new ClassDefinitionVisitor(env);
        ClassReader classReader = new ClassReader(is);
        classReader.accept((ClassVisitor)visitor, 3);
        return visitor.getDefinition();
    }

    class ClassDefinitionVisitor
    extends ClassVisitor {
        private Environment env;
        private AsmClass asmClass;

        ClassDefinitionVisitor(Environment env) {
            super(AsmClassFactory.getLatestVersion());
            this.env = env;
        }

        ClassDefinition getDefinition() {
            return this.asmClass;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.asmClass = new AsmClass(AsmClassFactory.this, this.toSourceFileName(name), access, this.toClassDeclaration(name), this.toClassDeclaration(superName), this.toClassDeclarations(interfaces));
        }

        private String toSourceFileName(String name) {
            String className = this.toClassName(name);
            if (className.contains("$")) {
                className = className.substring(0, className.indexOf("$"));
            }
            return className + ".java";
        }

        private String toClassName(String name) {
            return name.substring(name.lastIndexOf(47) + 1);
        }

        private ClassDeclaration[] toClassDeclarations(String ... names) {
            ClassDeclaration[] result = new ClassDeclaration[names.length];
            for (int i = 0; i < names.length; ++i) {
                result[i] = new ClassDeclaration(this.getIdentifier(names[i]));
            }
            return result;
        }

        private ClassDeclaration toClassDeclaration(String name) {
            return name == null ? null : new ClassDeclaration(this.getIdentifier(name));
        }

        private Identifier getIdentifier(String name) {
            return Identifier.lookup(name.replace('/', '.'));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (outerName != null) {
                AsmClassFactory.this.outerClasses.put(this.getIdentifier(name), this.getIdentifier(outerName));
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            AsmMemberDefinition definition = new AsmMemberDefinition(0L, (ClassDefinition)this.asmClass, access, TypeFactory.createType(desc), this.getIdentifier(name), value);
            this.asmClass.addMember(this.env, definition);
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            AsmMemberDefinition definition = new AsmMemberDefinition(0L, (ClassDefinition)this.asmClass, access, this.createType(desc), this.getIdentifier(name), exceptions);
            this.asmClass.addMember(this.env, definition);
            return null;
        }

        private Type createType(String desc) {
            return TypeFactory.createMethodType(desc);
        }
    }
}

