/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.glassfish.rmic.tools.java.AmbiguousMember;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.IdentifierToken;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.MethodSet;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.javac.SourceClass;
import org.glassfish.rmic.tools.javac.SourceMember;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.LocalMember;
import org.glassfish.rmic.tools.tree.UplevelReference;
import org.glassfish.rmic.tools.tree.Vset;

public abstract class ClassDefinition
implements Constants {
    protected Object source;
    protected long where;
    protected int modifiers;
    protected Identifier localName;
    protected ClassDeclaration declaration;
    protected IdentifierToken superClassId;
    protected IdentifierToken[] interfaceIds;
    protected ClassDeclaration superClass;
    protected ClassDeclaration[] interfaces;
    protected ClassDefinition outerClass;
    protected MemberDefinition outerMember;
    protected MemberDefinition innerClassMember;
    protected MemberDefinition firstMember;
    protected MemberDefinition lastMember;
    protected boolean resolved;
    protected String documentation;
    protected boolean error;
    protected boolean nestError;
    protected UplevelReference references;
    protected boolean referencesFrozen;
    private Hashtable<Identifier, MemberDefinition> fieldHash = new Hashtable(31);
    private Hashtable<String, ClassDefinition> localClasses = null;
    private final int LOCAL_CLASSES_SIZE = 31;
    protected Context classContext;
    protected boolean supersCheckStarted = !(this instanceof SourceClass);
    MethodSet allMethods = null;
    private List<MemberDefinition> permanentlyAbstractMethods = new ArrayList<MemberDefinition>();
    protected static boolean doInheritanceChecks = true;

    public Context getClassContext() {
        return this.classContext;
    }

    protected ClassDefinition(Object source, long where, ClassDeclaration declaration, int modifiers, IdentifierToken superClass, IdentifierToken[] interfaces) {
        this.source = source;
        this.where = where;
        this.declaration = declaration;
        this.modifiers = modifiers;
        this.superClassId = superClass;
        this.interfaceIds = interfaces;
    }

    public final Object getSource() {
        return this.source;
    }

    public final boolean getError() {
        return this.error;
    }

    public final void setError() {
        this.error = true;
        this.setNestError();
    }

    protected final boolean getNestError() {
        return this.nestError || this.outerClass != null && this.outerClass.getNestError();
    }

    private void setNestError() {
        this.nestError = true;
        if (this.outerClass != null) {
            this.outerClass.setNestError();
        }
    }

    public final long getWhere() {
        return this.where;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.declaration;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void subModifiers(int mod) {
        this.modifiers &= ~mod;
    }

    public final void addModifiers(int mod) {
        this.modifiers |= mod;
    }

    public final ClassDeclaration getSuperClass() {
        if (!this.supersCheckStarted) {
            throw new CompilerError("unresolved super");
        }
        return this.superClass;
    }

    public ClassDeclaration getSuperClass(Environment env) {
        return this.getSuperClass();
    }

    public final ClassDeclaration[] getInterfaces() {
        if (this.interfaces == null) {
            throw new CompilerError("getInterfaces");
        }
        return this.interfaces;
    }

    public final ClassDefinition getOuterClass() {
        return this.outerClass;
    }

    protected final void setOuterClass(ClassDefinition outerClass) {
        if (this.outerClass != null) {
            throw new CompilerError("setOuterClass");
        }
        this.outerClass = outerClass;
    }

    protected final void setOuterMember(MemberDefinition outerMember) {
        if (this.isStatic() || !this.isInnerClass()) {
            throw new CompilerError("setOuterField");
        }
        if (this.outerMember != null) {
            throw new CompilerError("setOuterField");
        }
        this.outerMember = outerMember;
    }

    public final boolean isInnerClass() {
        return this.outerClass != null;
    }

    public final boolean isMember() {
        return this.outerClass != null && !this.isLocal();
    }

    public final boolean isTopLevel() {
        return this.outerClass == null || this.isStatic() || this.isInterface();
    }

    public final boolean isInsideLocal() {
        return this.isLocal() || this.outerClass != null && this.outerClass.isInsideLocal();
    }

    public Identifier getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        return this.getName().getFlatName().getName();
    }

    protected void setLocalName(Identifier name) {
        if (this.isLocal()) {
            this.localName = name;
        }
    }

    public final MemberDefinition getInnerClassMember() {
        if (this.outerClass == null) {
            return null;
        }
        if (this.innerClassMember == null) {
            Identifier nm = this.getName().getFlatName().getName();
            for (MemberDefinition field = this.outerClass.getFirstMatch(nm); field != null; field = field.getNextMatch()) {
                if (!field.isInnerClass()) continue;
                this.innerClassMember = field;
                break;
            }
            if (this.innerClassMember == null) {
                throw new CompilerError("getInnerClassField");
            }
        }
        return this.innerClassMember;
    }

    public final MemberDefinition findOuterMember() {
        return this.outerMember;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final ClassDefinition getTopClass() {
        ClassDefinition q;
        ClassDefinition p = this;
        while ((q = p.outerClass) != null) {
            p = q;
        }
        return p;
    }

    public final MemberDefinition getFirstMember() {
        return this.firstMember;
    }

    public final MemberDefinition getFirstMatch(Identifier name) {
        return this.fieldHash.get(name);
    }

    public final Identifier getName() {
        return this.declaration.getName();
    }

    public final Type getType() {
        return this.declaration.getType();
    }

    public static boolean containsDeprecated(String documentation) {
        if (documentation == null) {
            return false;
        }
        int scan = 0;
        while ((scan = documentation.indexOf("@deprecated", scan)) >= 0) {
            block5: {
                char ch;
                for (int beg = scan - 1; beg >= 0 && (ch = documentation.charAt(beg)) != '\n' && ch != '\r'; --beg) {
                    if (Character.isSpace(ch)) {
                        continue;
                    }
                    break block5;
                }
                int end = scan + "@deprecated".length();
                if (end >= documentation.length() || (ch = documentation.charAt(end)) == '\n' || ch == '\r' || Character.isSpace(ch)) {
                    return true;
                }
            }
            scan += "@deprecated".length();
        }
        return false;
    }

    private final boolean inSamePackage(ClassDeclaration c) {
        return this.inSamePackage(c.getName().getQualifier());
    }

    public final boolean inSamePackage(ClassDefinition c) {
        return this.inSamePackage(c.getName().getQualifier());
    }

    private boolean inSamePackage(Identifier packageName) {
        return this.getName().getQualifier().equals(packageName);
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final boolean isClass() {
        return (this.getModifiers() & 0x200) == 0;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public final boolean isSynthetic() {
        return (this.getModifiers() & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.getModifiers() & 0x40000) != 0;
    }

    public final boolean isAnonymous() {
        return (this.getModifiers() & 0x10000) != 0;
    }

    public final boolean isLocal() {
        return (this.getModifiers() & 0x20000) != 0;
    }

    public final boolean hasConstructor() {
        return this.getFirstMatch(idInit) != null;
    }

    public final boolean mustBeAbstract(Environment env) {
        if (this.isAbstract()) {
            return true;
        }
        this.collectInheritedMethods(env);
        Iterator<MemberDefinition> methods = this.getMethods();
        while (methods.hasNext()) {
            MemberDefinition method = methods.next();
            if (!method.isAbstract()) continue;
            return true;
        }
        return this.getPermanentlyAbstractMethods().hasNext();
    }

    public boolean superClassOf(Environment env, ClassDeclaration otherClass) throws ClassNotFound {
        while (otherClass != null) {
            if (this.getClassDeclaration().equals(otherClass)) {
                return true;
            }
            otherClass = otherClass.getClassDefinition(env).getSuperClass();
        }
        return false;
    }

    public boolean enclosingClassOf(ClassDefinition otherClass) {
        while ((otherClass = otherClass.getOuterClass()) != null) {
            if (this != otherClass) continue;
            return true;
        }
        return false;
    }

    public boolean subClassOf(Environment env, ClassDeclaration otherClass) throws ClassNotFound {
        ClassDeclaration c = this.getClassDeclaration();
        while (c != null) {
            if (c.equals(otherClass)) {
                return true;
            }
            c = c.getClassDefinition(env).getSuperClass();
        }
        return false;
    }

    public boolean implementedBy(Environment env, ClassDeclaration c) throws ClassNotFound {
        while (c != null) {
            if (this.getClassDeclaration().equals(c)) {
                return true;
            }
            ClassDeclaration[] intf = c.getClassDefinition(env).getInterfaces();
            for (int i = 0; i < intf.length; ++i) {
                if (!this.implementedBy(env, intf[i])) continue;
                return true;
            }
            c = c.getClassDefinition(env).getSuperClass();
        }
        return false;
    }

    boolean couldImplement(ClassDefinition intDef) {
        if (!doInheritanceChecks) {
            throw new CompilerError("couldImplement: no checks");
        }
        if (!this.isInterface() || !intDef.isInterface()) {
            throw new CompilerError("couldImplement: not interface");
        }
        if (this.allMethods == null) {
            throw new CompilerError("couldImplement: called early");
        }
        Iterator<MemberDefinition> otherMethods = intDef.getMethods();
        while (otherMethods.hasNext()) {
            Type type;
            MemberDefinition method = otherMethods.next();
            Identifier name = method.getName();
            MemberDefinition myMethod = this.allMethods.lookupSig(name, type = method.getType());
            if (myMethod == null || myMethod.sameReturnType(method)) continue;
            return false;
        }
        return true;
    }

    protected boolean extendsCanAccess(Environment env, ClassDeclaration c) throws ClassNotFound {
        if (this.outerClass != null) {
            return this.outerClass.canAccess(env, c);
        }
        ClassDefinition cdef = c.getClassDefinition(env);
        if (cdef.isLocal()) {
            throw new CompilerError("top local");
        }
        if (cdef.isInnerClass()) {
            MemberDefinition f = cdef.getInnerClassMember();
            if (f.isPublic()) {
                return true;
            }
            if (f.isPrivate()) {
                return this.getClassDeclaration().equals(f.getTopClass().getClassDeclaration());
            }
            return this.getName().getQualifier().equals(f.getClassDeclaration().getName().getQualifier());
        }
        if (cdef.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(c.getName().getQualifier());
    }

    public boolean canAccess(Environment env, ClassDeclaration c) throws ClassNotFound {
        ClassDefinition cdef = c.getClassDefinition(env);
        if (cdef.isLocal()) {
            return true;
        }
        if (cdef.isInnerClass()) {
            return this.canAccess(env, cdef.getInnerClassMember());
        }
        if (cdef.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(c.getName().getQualifier());
    }

    public boolean canAccess(Environment env, MemberDefinition f) throws ClassNotFound {
        if (f.isPublic()) {
            return true;
        }
        if (f.isProtected() && this.subClassOf(env, f.getClassDeclaration())) {
            return true;
        }
        if (f.isPrivate()) {
            return this.getTopClass().getClassDeclaration().equals(f.getTopClass().getClassDeclaration());
        }
        return this.getName().getQualifier().equals(f.getClassDeclaration().getName().getQualifier());
    }

    public boolean permitInlinedAccess(Environment env, ClassDeclaration c) throws ClassNotFound {
        return env.opt() && c.equals(this.declaration) || env.opt_interclass() && this.canAccess(env, c);
    }

    public boolean permitInlinedAccess(Environment env, MemberDefinition f) throws ClassNotFound {
        return env.opt() && f.clazz.getClassDeclaration().equals(this.declaration) || env.opt_interclass() && this.canAccess(env, f);
    }

    public boolean protectedAccess(Environment env, MemberDefinition f, Type accessorType) throws ClassNotFound {
        return f.isStatic() || accessorType.isType(9) && f.getName() == idClone && f.getType().getArgumentTypes().length == 0 || accessorType.isType(10) && env.getClassDefinition(accessorType.getClassName()).subClassOf(env, this.getClassDeclaration()) || this.getName().getQualifier().equals(f.getClassDeclaration().getName().getQualifier());
    }

    public MemberDefinition getAccessMember(Environment env, Context ctx, MemberDefinition field, boolean isSuper) {
        throw new CompilerError("binary getAccessMember");
    }

    public MemberDefinition getUpdateMember(Environment env, Context ctx, MemberDefinition field, boolean isSuper) {
        throw new CompilerError("binary getUpdateMember");
    }

    public MemberDefinition getVariable(Environment env, Identifier nm, ClassDefinition source) throws AmbiguousMember, ClassNotFound {
        return this.getVariable0(env, nm, source, true, true);
    }

    private MemberDefinition getVariable0(Environment env, Identifier nm, ClassDefinition source, boolean showPrivate, boolean showPackage) throws AmbiguousMember, ClassNotFound {
        for (MemberDefinition member = this.getFirstMatch(nm); member != null; member = member.getNextMatch()) {
            if (!member.isVariable()) continue;
            if (!(!showPrivate && member.isPrivate() || !showPackage && member.isPackagePrivate())) {
                return member;
            }
            return null;
        }
        ClassDeclaration sup = this.getSuperClass();
        MemberDefinition field = null;
        if (sup != null) {
            field = sup.getClassDefinition(env).getVariable0(env, nm, source, false, showPackage && this.inSamePackage(sup));
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            MemberDefinition field2 = this.interfaces[i].getClassDefinition(env).getVariable0(env, nm, source, true, true);
            if (field2 == null) continue;
            if (field != null && source.canAccess(env, field) && field2 != field) {
                throw new AmbiguousMember(field2, field);
            }
            field = field2;
        }
        return field;
    }

    public boolean reportDeprecated(Environment env) {
        return this.isDeprecated() || this.outerClass != null && this.outerClass.reportDeprecated(env);
    }

    public void noteUsedBy(ClassDefinition ref, long where, Environment env) {
        if (this.reportDeprecated(env)) {
            env.error(where, "warn.class.is.deprecated", this);
        }
    }

    public MemberDefinition getInnerClass(Environment env, Identifier nm) throws ClassNotFound {
        for (MemberDefinition field = this.getFirstMatch(nm); field != null; field = field.getNextMatch()) {
            if (!field.isInnerClass() || field.getInnerClass().isLocal()) continue;
            return field;
        }
        ClassDeclaration sup = this.getSuperClass(env);
        if (sup != null) {
            return sup.getClassDefinition(env).getInnerClass(env, nm);
        }
        return null;
    }

    private MemberDefinition matchMethod(Environment env, ClassDefinition accessor, Identifier methodName, Type[] argumentTypes, boolean isAnonConstCall, Identifier accessPackage) throws AmbiguousMember, ClassNotFound {
        if (this.allMethods == null || !this.allMethods.isFrozen()) {
            throw new CompilerError("matchMethod called early");
        }
        MemberDefinition tentative = null;
        ArrayList<MemberDefinition> candidateList = null;
        Iterator<MemberDefinition> methods = this.allMethods.lookupName(methodName);
        while (methods.hasNext()) {
            MemberDefinition method = methods.next();
            if (!env.isApplicable(method, argumentTypes) || (accessor == null ? isAnonConstCall && (method.isPrivate() || method.isPackagePrivate() && accessPackage != null && !this.inSamePackage(accessPackage)) : !accessor.canAccess(env, method))) continue;
            if (tentative == null) {
                tentative = method;
                continue;
            }
            if (env.isMoreSpecific(method, tentative)) {
                tentative = method;
                continue;
            }
            if (env.isMoreSpecific(tentative, method)) continue;
            if (candidateList == null) {
                candidateList = new ArrayList<MemberDefinition>();
            }
            candidateList.add(method);
        }
        if (tentative != null && candidateList != null) {
            for (MemberDefinition method : candidateList) {
                if (env.isMoreSpecific(tentative, method)) continue;
                throw new AmbiguousMember(tentative, method);
            }
        }
        return tentative;
    }

    public MemberDefinition matchMethod(Environment env, ClassDefinition accessor, Identifier methodName, Type[] argumentTypes) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(env, accessor, methodName, argumentTypes, false, null);
    }

    public MemberDefinition matchMethod(Environment env, ClassDefinition accessor, Identifier methodName) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(env, accessor, methodName, Type.noArgs, false, null);
    }

    public MemberDefinition matchAnonConstructor(Environment env, Identifier accessPackage, Type[] argumentTypes) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(env, null, idInit, argumentTypes, true, accessPackage);
    }

    public MemberDefinition findMethod(Environment env, Identifier nm, Type t) throws ClassNotFound {
        for (MemberDefinition f = this.getFirstMatch(nm); f != null; f = f.getNextMatch()) {
            if (!f.getType().equalArguments(t)) continue;
            return f;
        }
        if (nm.equals(idInit)) {
            return null;
        }
        ClassDeclaration sup = this.getSuperClass();
        if (sup == null) {
            return null;
        }
        return sup.getClassDefinition(env).findMethod(env, nm, t);
    }

    protected void basicCheck(Environment env) throws ClassNotFound {
        if (this.outerClass != null) {
            this.outerClass.basicCheck(env);
        }
    }

    public void check(Environment env) throws ClassNotFound {
    }

    public Vset checkLocalClass(Environment env, Context ctx, Vset vset, ClassDefinition sup, Expression[] args, Type[] argTypes) throws ClassNotFound {
        throw new CompilerError("checkLocalClass");
    }

    protected Iterator<MemberDefinition> getPermanentlyAbstractMethods() {
        if (this.allMethods == null) {
            throw new CompilerError("isPermanentlyAbstract() called early");
        }
        return this.permanentlyAbstractMethods.iterator();
    }

    public static void turnOffInheritanceChecks() {
        doInheritanceChecks = false;
    }

    private void collectOneClass(Environment env, ClassDeclaration parent, MethodSet myMethods, MethodSet allMethods, MethodSet mirandaMethods) {
        try {
            ClassDefinition pClass = parent.getClassDefinition(env);
            Iterator<MemberDefinition> methods = pClass.getMethods(env);
            while (methods.hasNext()) {
                MemberDefinition method = methods.next();
                if (method.isPrivate() || method.isConstructor() || pClass.isInterface() && !method.isAbstract()) continue;
                Identifier name = method.getName();
                Type type = method.getType();
                MemberDefinition override = myMethods.lookupSig(name, type);
                if (method.isPackagePrivate() && !this.inSamePackage(method.getClassDeclaration())) {
                    if (override != null && this instanceof SourceClass) {
                        env.error(method.getWhere(), "warn.no.override.access", override, override.getClassDeclaration(), method.getClassDeclaration());
                    }
                    if (!method.isAbstract()) continue;
                    this.permanentlyAbstractMethods.add(method);
                    continue;
                }
                if (override != null) {
                    override.checkOverride(env, method);
                    continue;
                }
                MemberDefinition formerMethod = allMethods.lookupSig(name, type);
                if (formerMethod == null) {
                    if (mirandaMethods != null && pClass.isInterface() && !this.isInterface()) {
                        method = new SourceMember(method, this, env);
                        mirandaMethods.add(method);
                    }
                    allMethods.add(method);
                    continue;
                }
                if (this.isInterface() && !formerMethod.isAbstract() && method.isAbstract()) {
                    allMethods.replace(method);
                    continue;
                }
                if (!formerMethod.checkMeet(env, method, this.getClassDeclaration()) || formerMethod.couldOverride(env, method)) continue;
                if (method.couldOverride(env, formerMethod)) {
                    if (mirandaMethods != null && pClass.isInterface() && !this.isInterface()) {
                        method = new SourceMember(method, this, env);
                        mirandaMethods.replace(method);
                    }
                    allMethods.replace(method);
                    continue;
                }
                env.error(this.where, "nontrivial.meet", method, formerMethod.getClassDefinition(), method.getClassDeclaration());
            }
        }
        catch (ClassNotFound ee) {
            env.error(this.getWhere(), "class.not.found", ee.name, this);
        }
    }

    protected void collectInheritedMethods(Environment env) {
        if (this.allMethods != null) {
            if (this.allMethods.isFrozen()) {
                return;
            }
            throw new CompilerError("collectInheritedMethods()");
        }
        MethodSet myMethods = new MethodSet();
        this.allMethods = new MethodSet();
        MethodSet mirandaMethods = env.version12() ? null : new MethodSet();
        MemberDefinition member = this.getFirstMember();
        while (member != null) {
            if (member.isMethod() && !member.isInitializer()) {
                ClassDefinition.methodSetAdd(env, myMethods, member);
                ClassDefinition.methodSetAdd(env, this.allMethods, member);
            }
            member = member.nextMember;
        }
        ClassDeclaration scDecl = this.getSuperClass(env);
        if (scDecl != null) {
            this.collectOneClass(env, scDecl, myMethods, this.allMethods, mirandaMethods);
            ClassDefinition sc = scDecl.getClassDefinition();
            Iterator<MemberDefinition> supIter = sc.getPermanentlyAbstractMethods();
            while (supIter.hasNext()) {
                this.permanentlyAbstractMethods.add(supIter.next());
            }
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.collectOneClass(env, this.interfaces[i], myMethods, this.allMethods, mirandaMethods);
        }
        this.allMethods.freeze();
        if (mirandaMethods != null && mirandaMethods.size() > 0) {
            this.addMirandaMethods(env, mirandaMethods.iterator());
        }
    }

    private static void methodSetAdd(Environment env, MethodSet methodSet, MemberDefinition newMethod) {
        MemberDefinition oldMethod = methodSet.lookupSig(newMethod.getName(), newMethod.getType());
        if (oldMethod != null) {
            Type oldReturnType = oldMethod.getType().getReturnType();
            Type newReturnType = newMethod.getType().getReturnType();
            try {
                if (env.isMoreSpecific(newReturnType, oldReturnType)) {
                    methodSet.replace(newMethod);
                }
            }
            catch (ClassNotFound ignore) {}
        } else {
            methodSet.add(newMethod);
        }
    }

    protected Iterator<MemberDefinition> getMethods(Environment env) {
        if (this.allMethods == null) {
            this.collectInheritedMethods(env);
        }
        return this.getMethods();
    }

    public Iterator<MemberDefinition> getMethods() {
        if (this.allMethods == null) {
            throw new CompilerError("getMethods: too early");
        }
        return this.allMethods.iterator();
    }

    protected void addMirandaMethods(Environment env, Iterator<MemberDefinition> mirandas) {
    }

    public void inlineLocalClass(Environment env) {
    }

    public void resolveTypeStructure(Environment env) {
    }

    public Identifier resolveName(Environment env, Identifier name) {
        env.dtEvent("ClassDefinition.resolveName: " + name);
        if (name.isQualified()) {
            Identifier rhead = this.resolveName(env, name.getHead());
            if (rhead.hasAmbigPrefix()) {
                return rhead;
            }
            if (!env.classExists(rhead)) {
                return env.resolvePackageQualifiedName(name);
            }
            try {
                return env.getClassDefinition(rhead).resolveInnerClass(env, name.getTail());
            }
            catch (ClassNotFound ee) {
                return Identifier.lookupInner(rhead, name.getTail());
            }
        }
        int ls = -2;
        LocalMember lf = null;
        if (this.classContext != null && (lf = this.classContext.getLocalClass(name)) != null) {
            ls = lf.getScopeNumber();
        }
        ClassDefinition c = this;
        while (c != null) {
            try {
                MemberDefinition f = c.getInnerClass(env, name);
                if (f != null && (lf == null || this.classContext.getScopeNumber(c) > ls)) {
                    return f.getInnerClass().getName();
                }
            }
            catch (ClassNotFound ee) {
                // empty catch block
            }
            c = c.outerClass;
        }
        if (lf != null) {
            return lf.getInnerClass().getName();
        }
        return env.resolveName(name);
    }

    public Identifier resolveInnerClass(Environment env, Identifier nm) {
        if (nm.isInner()) {
            throw new CompilerError("inner");
        }
        if (nm.isQualified()) {
            Identifier rhead = this.resolveInnerClass(env, nm.getHead());
            try {
                return env.getClassDefinition(rhead).resolveInnerClass(env, nm.getTail());
            }
            catch (ClassNotFound ee) {
                return Identifier.lookupInner(rhead, nm.getTail());
            }
        }
        try {
            MemberDefinition f = this.getInnerClass(env, nm);
            if (f != null) {
                return f.getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        return Identifier.lookupInner(this.getName(), nm);
    }

    boolean innerClassExists(Identifier nm) {
        for (MemberDefinition field = this.getFirstMatch(nm.getHead()); field != null; field = field.getNextMatch()) {
            if (!field.isInnerClass() || field.getInnerClass().isLocal()) continue;
            return !nm.isQualified() || field.getInnerClass().innerClassExists(nm.getTail());
        }
        return false;
    }

    public MemberDefinition findAnyMethod(Environment env, Identifier nm) throws ClassNotFound {
        for (MemberDefinition f = this.getFirstMatch(nm); f != null; f = f.getNextMatch()) {
            if (!f.isMethod()) continue;
            return f;
        }
        ClassDeclaration sup = this.getSuperClass();
        if (sup == null) {
            return null;
        }
        return sup.getClassDefinition(env).findAnyMethod(env, nm);
    }

    public int diagnoseMismatch(Environment env, Identifier nm, Type[] argTypes, int start, Type[] margTypeResult) throws ClassNotFound {
        int[] haveMatch = new int[argTypes.length];
        Type[] margType = new Type[argTypes.length];
        if (!this.diagnoseMismatch(env, nm, argTypes, start, haveMatch, margType)) {
            return -2;
        }
        for (int i = start; i < argTypes.length; ++i) {
            if (haveMatch[i] >= 4) continue;
            margTypeResult[0] = margType[i];
            return i << 2 | haveMatch[i];
        }
        return -1;
    }

    private boolean diagnoseMismatch(Environment env, Identifier nm, Type[] argTypes, int start, int[] haveMatch, Type[] margType) throws ClassNotFound {
        boolean haveOne = false;
        for (MemberDefinition f = this.getFirstMatch(nm); f != null; f = f.getNextMatch()) {
            Type[] fArgTypes;
            if (!f.isMethod() || (fArgTypes = f.getType().getArgumentTypes()).length != argTypes.length) continue;
            haveOne = true;
            for (int i = start; i < argTypes.length; ++i) {
                Type at = argTypes[i];
                Type ft = fArgTypes[i];
                if (env.implicitCast(at, ft)) {
                    haveMatch[i] = 4;
                    continue;
                }
                if (haveMatch[i] <= 2 && env.explicitCast(at, ft)) {
                    if (haveMatch[i] < 2) {
                        margType[i] = null;
                    }
                    haveMatch[i] = 2;
                } else if (haveMatch[i] > 0) continue;
                if (margType[i] == null) {
                    margType[i] = ft;
                    continue;
                }
                if (margType[i] == ft) continue;
                int n = i;
                haveMatch[n] = haveMatch[n] | 1;
            }
        }
        if (nm.equals(idInit)) {
            return haveOne;
        }
        ClassDeclaration sup = this.getSuperClass();
        if (sup != null && sup.getClassDefinition(env).diagnoseMismatch(env, nm, argTypes, start, haveMatch, margType)) {
            haveOne = true;
        }
        return haveOne;
    }

    protected void addMember(MemberDefinition field) {
        if (this.firstMember == null) {
            this.firstMember = this.lastMember = field;
        } else if (field.isSynthetic() && field.isFinal() && field.isVariable()) {
            field.nextMember = this.firstMember;
            this.firstMember = field;
            field.nextMatch = this.fieldHash.get(field.name);
        } else {
            this.lastMember.nextMember = field;
            this.lastMember = field;
            field.nextMatch = this.fieldHash.get(field.name);
        }
        this.fieldHash.put(field.name, field);
    }

    public void addMember(Environment env, MemberDefinition field) {
        this.addMember(field);
        if (this.resolved) {
            field.resolveTypeStructure(env);
        }
    }

    public UplevelReference getReference(LocalMember target) {
        for (UplevelReference r = this.references; r != null; r = r.getNext()) {
            if (r.getTarget() != target) continue;
            return r;
        }
        return this.addReference(target);
    }

    private UplevelReference addReference(LocalMember target) {
        if (target.getClassDefinition() == this) {
            throw new CompilerError("addReference " + target);
        }
        this.referencesMustNotBeFrozen();
        UplevelReference r = new UplevelReference(this, target);
        this.references = r.insertInto(this.references);
        return r;
    }

    public UplevelReference getReferences() {
        return this.references;
    }

    public UplevelReference getReferencesFrozen() {
        this.referencesFrozen = true;
        return this.references;
    }

    public final void referencesMustNotBeFrozen() {
        if (this.referencesFrozen) {
            throw new CompilerError("referencesMustNotBeFrozen " + this);
        }
    }

    public MemberDefinition getClassLiteralLookup(long fwhere) {
        throw new CompilerError("binary class");
    }

    public void loadNested(Environment env) {
        throw new CompilerError("loadNested");
    }

    public Iterator<ClassDeclaration> getDependencies() {
        throw new CompilerError("getDependencies");
    }

    public void addDependency(ClassDeclaration c) {
        throw new CompilerError("addDependency");
    }

    public ClassDefinition getLocalClass(String name) {
        if (this.localClasses == null) {
            return null;
        }
        return this.localClasses.get(name);
    }

    public void addLocalClass(ClassDefinition c, String name) {
        if (this.localClasses == null) {
            this.localClasses = new Hashtable(31);
        }
        this.localClasses.put(name, c);
    }

    public void print(PrintStream out) {
        if (this.isPublic()) {
            out.print("public ");
        }
        if (this.isInterface()) {
            out.print("interface ");
        } else {
            out.print("class ");
        }
        out.print(this.getName() + " ");
        if (this.getSuperClass() != null) {
            out.print("extends " + this.getSuperClass().getName() + " ");
        }
        if (this.interfaces.length > 0) {
            out.print("implements ");
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print(this.interfaces[i].getName());
                out.print(" ");
            }
        }
        out.println("{");
        for (MemberDefinition f = this.getFirstMember(); f != null; f = f.getNextMember()) {
            out.print("    ");
            f.print(out);
        }
        out.println("}");
    }

    public String toString() {
        return this.getClassDeclaration().toString();
    }

    public void cleanup(Environment env) {
        if (env.dump()) {
            env.output("[cleanup " + this.getName() + "]");
        }
        for (MemberDefinition f = this.getFirstMember(); f != null; f = f.getNextMember()) {
            f.cleanup(env);
        }
        this.documentation = null;
    }
}

