/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.binaryclass;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Type;

public final class BinaryConstantPool
implements Constants {
    private byte[] types;
    private Object[] cpool;
    Hashtable<Object, Integer> indexHashObject;
    Hashtable<Object, Integer> indexHashAscii;
    Vector<String> MoreStuff;

    BinaryConstantPool(DataInputStream in) throws IOException {
        this.types = new byte[in.readUnsignedShort()];
        this.cpool = new Object[this.types.length];
        block12: for (int i = 1; i < this.cpool.length; ++i) {
            int j = i;
            this.types[i] = in.readByte();
            switch (this.types[i]) {
                case 1: {
                    this.cpool[i] = in.readUTF();
                    continue block12;
                }
                case 3: {
                    this.cpool[i] = in.readInt();
                    continue block12;
                }
                case 4: {
                    this.cpool[i] = new Float(in.readFloat());
                    continue block12;
                }
                case 5: {
                    this.cpool[i++] = in.readLong();
                    continue block12;
                }
                case 6: {
                    this.cpool[i++] = new Double(in.readDouble());
                    continue block12;
                }
                case 7: 
                case 8: {
                    this.cpool[i] = in.readUnsignedShort();
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[i] = in.readUnsignedShort() << 16 | in.readUnsignedShort();
                    continue block12;
                }
                case 15: {
                    this.cpool[i] = this.readBytes(in, 3);
                    continue block12;
                }
                case 16: {
                    this.cpool[i] = this.readBytes(in, 2);
                    continue block12;
                }
                case 18: {
                    this.cpool[i] = this.readBytes(in, 4);
                    continue block12;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[i]);
                }
            }
        }
    }

    private byte[] readBytes(DataInputStream in, int cnt) throws IOException {
        byte[] b = new byte[cnt];
        in.readFully(b);
        return b;
    }

    public int getInteger(int n) {
        return n == 0 ? 0 : ((Number)this.cpool[n]).intValue();
    }

    public Object getValue(int n) {
        return n == 0 ? null : this.cpool[n];
    }

    public String getString(int n) {
        return n == 0 ? null : (String)this.cpool[n];
    }

    public Identifier getIdentifier(int n) {
        return n == 0 ? null : Identifier.lookup(this.getString(n));
    }

    public ClassDeclaration getDeclarationFromName(Environment env, int n) {
        return n == 0 ? null : env.getClassDeclaration(Identifier.lookup(this.getString(n).replace('/', '.')));
    }

    public ClassDeclaration getDeclaration(Environment env, int n) {
        return n == 0 ? null : this.getDeclarationFromName(env, this.getInteger(n));
    }

    public Type getType(int n) {
        return Type.tType(this.getString(n));
    }

    public int getConstantType(int n) {
        return this.types[n];
    }

    public Object getConstant(int n, Environment env) {
        int constant_type = this.getConstantType(n);
        switch (constant_type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 18: {
                return this.getValue(n);
            }
            case 7: {
                return this.getDeclaration(env, n);
            }
            case 8: {
                return this.getString(this.getInteger(n));
            }
            case 9: 
            case 10: 
            case 11: {
                try {
                    int key = this.getInteger(n);
                    ClassDefinition clazz = this.getDeclaration(env, key >> 16).getClassDefinition(env);
                    int name_and_type = this.getInteger(key & 0xFFFF);
                    Identifier id = this.getIdentifier(name_and_type >> 16);
                    Type type = this.getType(name_and_type & 0xFFFF);
                    for (MemberDefinition field = clazz.getFirstMatch(id); field != null; field = field.getNextMatch()) {
                        Type field_type = field.getType();
                        if (!(constant_type == 9 ? field_type == type : field_type.equalArguments(type))) continue;
                        return field;
                    }
                }
                catch (ClassNotFound e) {
                    // empty catch block
                }
                return null;
            }
        }
        throw new ClassFormatError("invalid constant type: " + constant_type);
    }

    public Vector<ClassDeclaration> getDependencies(Environment env) {
        Vector<ClassDeclaration> v = new Vector<ClassDeclaration>();
        for (int i = 1; i < this.cpool.length; ++i) {
            switch (this.types[i]) {
                case 7: {
                    v.addElement(this.getDeclarationFromName(env, this.getInteger(i)));
                }
            }
        }
        return v;
    }

    public int indexObject(Object obj, Environment env) {
        Integer result;
        if (this.indexHashObject == null) {
            this.createIndexHash(env);
        }
        if ((result = this.indexHashObject.get(obj)) == null) {
            throw new IndexOutOfBoundsException("Cannot find object " + obj + " of type " + obj.getClass() + " in constant pool");
        }
        return result;
    }

    public int indexString(String string, Environment env) {
        Integer result;
        if (this.indexHashObject == null) {
            this.createIndexHash(env);
        }
        if ((result = this.indexHashAscii.get(string)) == null) {
            if (this.MoreStuff == null) {
                this.MoreStuff = new Vector();
            }
            result = this.cpool.length + this.MoreStuff.size();
            this.MoreStuff.addElement(string);
            this.indexHashAscii.put(string, result);
        }
        return result;
    }

    public void createIndexHash(Environment env) {
        this.indexHashObject = new Hashtable();
        this.indexHashAscii = new Hashtable();
        for (int i = 1; i < this.cpool.length; ++i) {
            if (this.types[i] == 1) {
                this.indexHashAscii.put(this.cpool[i], i);
                continue;
            }
            try {
                this.indexHashObject.put(this.getConstant(i, env), i);
                continue;
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
        }
    }

    public void write(DataOutputStream out, Environment env) throws IOException {
        int i;
        int length = this.cpool.length;
        if (this.MoreStuff != null) {
            length += this.MoreStuff.size();
        }
        out.writeShort(length);
        block10: for (i = 1; i < this.cpool.length; ++i) {
            byte type = this.types[i];
            Object x = this.cpool[i];
            out.writeByte(type);
            switch (type) {
                case 1: {
                    out.writeUTF((String)x);
                    continue block10;
                }
                case 3: {
                    out.writeInt(((Number)x).intValue());
                    continue block10;
                }
                case 4: {
                    out.writeFloat(((Number)x).floatValue());
                    continue block10;
                }
                case 5: {
                    out.writeLong(((Number)x).longValue());
                    ++i;
                    continue block10;
                }
                case 6: {
                    out.writeDouble(((Number)x).doubleValue());
                    ++i;
                    continue block10;
                }
                case 7: 
                case 8: {
                    out.writeShort(((Number)x).intValue());
                    continue block10;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int value = ((Number)x).intValue();
                    out.writeShort(value >> 16);
                    out.writeShort(value & 0xFFFF);
                    continue block10;
                }
                case 15: 
                case 16: 
                case 18: {
                    out.write((byte[])x, 0, ((byte[])x).length);
                    continue block10;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[i]);
                }
            }
        }
        for (i = this.cpool.length; i < length; ++i) {
            String string = this.MoreStuff.elementAt(i - this.cpool.length);
            out.writeByte(1);
            out.writeUTF(string);
        }
    }
}

