/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.ProviderNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipFile;
import org.glassfish.rmic.tools.java.ClassFile;
import org.glassfish.rmic.tools.java.ClassPathEntry;
import org.glassfish.rmic.tools.java.DirClassPathEntry;
import org.glassfish.rmic.tools.java.JrtClassPathEntry;
import org.glassfish.rmic.tools.java.ZipClassPathEntry;

public class ClassPath {
    private static final char dirSeparator = File.pathSeparatorChar;
    private String pathstr;
    private ClassPathEntry[] path;
    private final String fileSeparatorChar = "" + File.separatorChar;

    private FileSystem getJrtFileSystem() {
        return FileSystems.getFileSystem(URI.create("jrt:/"));
    }

    ClassPath(String pathstr) {
        this.init(pathstr);
    }

    public ClassPath(String ... patharray) {
        this.init(patharray);
    }

    private void init(String pathstr) {
        this.pathstr = pathstr;
        if (pathstr.length() == 0) {
            this.path = new ClassPathEntry[0];
        }
        int n = 0;
        int i = 0;
        while ((i = pathstr.indexOf(dirSeparator, i)) != -1) {
            ++n;
            ++i;
        }
        ClassPathEntry[] path = new ClassPathEntry[n + 1];
        int len = pathstr.length();
        n = 0;
        i = 0;
        while (i < len) {
            int j = pathstr.indexOf(dirSeparator, i);
            if (j == -1) {
                j = len;
            }
            if (i == j) {
                path[n++] = new DirClassPathEntry(new File("."));
            } else {
                String filename = pathstr.substring(i, j);
                File file = new File(filename);
                if (file.isFile()) {
                    try {
                        ZipFile zip = new ZipFile(file);
                        path[n++] = new ZipClassPathEntry(zip);
                    }
                    catch (IOException ignored) {}
                } else {
                    path[n++] = new DirClassPathEntry(file);
                }
            }
            i = j + 1;
        }
        try {
            FileSystem fs = this.getJrtFileSystem();
            path[n++] = new JrtClassPathEntry(fs);
        }
        catch (ProviderNotFoundException ignored) {
            // empty catch block
        }
        this.path = new ClassPathEntry[n];
        System.arraycopy(path, 0, this.path, 0, n);
    }

    private void init(String[] patharray) {
        if (patharray.length == 0) {
            this.pathstr = "";
        } else {
            StringBuilder sb = new StringBuilder(patharray[0]);
            for (int i = 1; i < patharray.length; ++i) {
                sb.append(File.pathSeparatorChar);
                sb.append(patharray[i]);
            }
            this.pathstr = sb.toString();
        }
        ClassPathEntry[] path = new ClassPathEntry[patharray.length + 1];
        int n = 0;
        for (String name : patharray) {
            File file = new File(name);
            if (file.isFile()) {
                try {
                    ZipFile zip = new ZipFile(file);
                    path[n++] = new ZipClassPathEntry(zip);
                }
                catch (IOException ignored) {}
                continue;
            }
            path[n++] = new DirClassPathEntry(file);
        }
        try {
            FileSystem fs = this.getJrtFileSystem();
            path[n++] = new JrtClassPathEntry(fs);
        }
        catch (ProviderNotFoundException ignored) {
            // empty catch block
        }
        this.path = new ClassPathEntry[n];
        System.arraycopy(path, 0, this.path, 0, n);
    }

    ClassFile getDirectory(String name) {
        return this.getFile(name, true);
    }

    public ClassFile getFile(String name) {
        return this.getFile(name, false);
    }

    private ClassFile getFile(String name, boolean isDirectory) {
        int i;
        String subdir = name;
        String basename = "";
        if (!isDirectory) {
            i = name.lastIndexOf(File.separatorChar);
            subdir = name.substring(0, i + 1);
            basename = name.substring(i + 1);
        } else if (!subdir.equals("") && !subdir.endsWith(this.fileSeparatorChar)) {
            name = subdir = subdir + File.separatorChar;
        }
        for (i = 0; i < this.path.length; ++i) {
            ClassFile cf = this.path[i].getFile(name, subdir, basename, isDirectory);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    Enumeration<ClassFile> getFiles(String pkg, String ext) {
        Hashtable<String, ClassFile> files = new Hashtable<String, ClassFile>();
        int i = this.path.length;
        while (--i >= 0) {
            this.path[i].fillFiles(pkg, ext, files);
        }
        return files.elements();
    }

    public void close() throws IOException {
        int i = this.path.length;
        while (--i >= 0) {
            this.path[i].close();
        }
    }

    public String toString() {
        return this.pathstr;
    }
}

