/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.enterprise.v3.services.impl.ContainerStaticStreamAlgorithm;
import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpProtocolFilter;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Adapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyEmbeddedHttp
extends SelectorThread
implements EndpointMapper<Adapter> {
    private static final String ROOT = "/";
    protected volatile ProtocolFilter httpProtocolFilterWrapper;
    private AtomicBoolean algorithInitialized = new AtomicBoolean(false);
    protected volatile Collection<ProtocolFilter> defaultHttpFilters;
    protected boolean isHttpSecured = false;
    private UDPSelectorHandler udpSelectorHandler;
    protected GrizzlyService grizzlyService;

    public GrizzlyEmbeddedHttp(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
        this.adapter = new ContainerMapper(grizzlyService, this);
        this.setClassLoader(this.getClass().getClassLoader());
    }

    protected void initAlgorithm() {
        if (!this.algorithInitialized.getAndSet(true)) {
            this.algorithmClass = ContainerStaticStreamAlgorithm.class;
            defaultAlgorithmInstalled = true;
        }
    }

    protected void initController() {
        super.initController();
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
            private final ConcurrentLinkedQueue<ProtocolChain> chains = new ConcurrentLinkedQueue();

            public ProtocolChain poll() {
                Object protocolChain = this.chains.poll();
                if (protocolChain == null) {
                    protocolChain = new GlassfishProtocolChain();
                    ((GlassfishProtocolChain)((Object)protocolChain)).enableRCM(GrizzlyEmbeddedHttp.this.rcmSupport);
                    GrizzlyEmbeddedHttp.this.configureFilters(protocolChain);
                }
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return this.chains.offer(instance);
            }
        };
        this.controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)instanceHandler);
        this.controller.setReadThreadsCount(this.readThreadsCount);
        if (this.portUnificationFilter != null) {
            this.controller.addSelectorHandler((SelectorHandler)this.createUDPSelectorHandler());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                GrizzlyEmbeddedHttp.this.stopEndpoint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpoint() {
        try {
            super.stopEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unable to stop properly", t);
        }
        finally {
            try {
                if (this.selectorHandler != null && this.selectorHandler.getSelector() != null) {
                    this.selectorHandler.getSelector().close();
                }
            }
            catch (IOException ex) {}
            try {
                if (this.udpSelectorHandler != null && this.udpSelectorHandler.getSelector() != null) {
                    this.udpSelectorHandler.getSelector().close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ProtocolFilter> getDefaultHttpProtocolFilters() {
        if (this.defaultHttpFilters == null) {
            GrizzlyEmbeddedHttp grizzlyEmbeddedHttp = this;
            synchronized (grizzlyEmbeddedHttp) {
                if (this.defaultHttpFilters == null) {
                    ArrayList<ProtocolFilter> tmpList = new ArrayList<ProtocolFilter>(4);
                    if (this.rcmSupport) {
                        tmpList.add(this.createRaFilter());
                    }
                    tmpList.add(this.createHttpParserFilter());
                    this.defaultHttpFilters = tmpList;
                }
            }
        }
        return this.defaultHttpFilters;
    }

    protected ProtocolFilter createReadFilter() {
        ReadFilter readFilter = new ReadFilter();
        readFilter.setContinuousExecution(GlassfishProtocolChain.CONTINUOUS_EXECUTION);
        return readFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpProtocolFilter getHttpProtocolFilter() {
        if (this.httpProtocolFilterWrapper == null) {
            GrizzlyEmbeddedHttp grizzlyEmbeddedHttp = this;
            synchronized (grizzlyEmbeddedHttp) {
                if (this.httpProtocolFilterWrapper == null) {
                    this.initAlgorithm();
                    ProtocolFilter wrappedFilter = this.createHttpParserFilter();
                    this.httpProtocolFilterWrapper = new HttpProtocolFilter(wrappedFilter, this);
                }
            }
        }
        return (HttpProtocolFilter)this.httpProtocolFilterWrapper;
    }

    protected UDPSelectorHandler createUDPSelectorHandler() {
        if (this.udpSelectorHandler == null) {
            this.udpSelectorHandler = new UDPSelectorHandler();
            this.udpSelectorHandler.setPort(this.port);
            this.udpSelectorHandler.setThreadPool(this.threadPool);
        }
        return this.udpSelectorHandler;
    }

    protected void configureSelectorHandler(UDPSelectorHandler selectorHandler) {
        selectorHandler.setPort(this.port);
        selectorHandler.setReuseAddress(this.getReuseAddress());
        selectorHandler.setThreadPool(this.threadPool);
    }

    public boolean isHttpSecured() {
        return this.isHttpSecured;
    }

    public ContainerMapper getContainerMapper() {
        return (ContainerMapper)this.adapter;
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container) {
        ((ContainerMapper)this.getAdapter()).register(contextRoot, vs, adapter, null, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        ((ContainerMapper)this.getAdapter()).unregister(contextRoot);
    }
}

