/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Dom;

@Service(name="get")
@Scoped(value=PerLookup.class)
public class GetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(optional=true, defaultValue="false", shortName="m")
    Boolean monitor;
    @Param(primary=true)
    String pattern;
    @Inject(optional=true)
    private MonitoringRuntimeDataRegistry mrdr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.monitor.booleanValue()) {
            this.getMonitorAttributes(report);
            return;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!this.pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = this.pattern.substring(0, this.pattern.indexOf(parentNodes[0].relativeName));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        List<Map.Entry> matchingNodesSorted = this.sortNodesByDottedName(matchingNodes);
        for (Map.Entry node : matchingNodesSorted) {
            if (((Dom)node.getKey()).model.targetTypeName.equals("org.glassfish.api.admin.config.Property")) {
                if (!this.matches((String)node.getValue(), this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "=" + this.encode(((Dom)node.getKey()).attribute("value")));
                continue;
            }
            Map<String, String> attributes = this.getNodeAttributes((Dom)node.getKey(), this.pattern);
            TreeMap<String, String> attributesSorted = new TreeMap<String, String>(attributes);
            for (Map.Entry<String, String> name : attributesSorted.entrySet()) {
                String finalDottedName = (String)node.getValue() + "." + name.getKey();
                if (!this.matches(finalDottedName, this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "." + name.getKey() + "=" + name.getValue());
            }
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private void getMonitorAttributes(ActionReport report) {
        if (this.pattern == null || this.pattern.equals("")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("match pattern is invalid or null");
            return;
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("monitoring facility not installed");
            return;
        }
        TreeNode tn = this.mrdr.get("server");
        if (tn == null) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        List ltn = tn.getNodes(this.pattern);
        for (TreeNode tn1 : this.sortTreeNodesByCompletePathName(ltn)) {
            if (tn1.hasChildNodes()) continue;
            map.put(tn1.getCompletePathName(), tn1.getValue());
        }
        for (Object obj : map.keySet()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(obj + " = " + map.get(obj));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

