/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-system-properties")
@Scoped(value=PerLookup.class)
@I18n(value="create.system.properties")
public class CreateSystemProperties
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSystemProperties.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="name_value", primary=true)
    Properties properties;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server server = this.domain.getServerNamed(this.target);
        String sysPropName = "";
        try {
            for (Object key : this.properties.keySet()) {
                String propName;
                sysPropName = propName = (String)key;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                    public Object run(Server param) throws PropertyVetoException, TransactionFailure {
                        for (SystemProperty sysProperty : param.getSystemProperty()) {
                            if (!sysProperty.getName().equals(propName)) continue;
                            param.getSystemProperty().remove(sysProperty);
                            break;
                        }
                        SystemProperty newSysProp = (SystemProperty)param.createChild(SystemProperty.class);
                        newSysProp.setName(propName);
                        newSysProp.setValue(CreateSystemProperties.this.properties.getProperty(propName));
                        param.getSystemProperty().add(newSysProp);
                        return newSysProp;
                    }
                }, (ConfigBeanProxy)server);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.system.properties.failed", "System property {0} creation failed", new Object[]{sysPropName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.system.properties.failed", "System property {0} creation failed", new Object[]{sysPropName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

