/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ServiceInitializerThread;
import com.sun.grizzly.Controller;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.dom.NetworkListener;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

public class GrizzlyListener
extends GrizzlyServiceListener {
    protected static final Logger logger = Logger.getLogger(GrizzlyListener.class.getName());
    private boolean isGenericListener = false;
    private ServiceInitializerThread serviceInitializer;
    private NetworkListener listener;

    public GrizzlyListener(Controller cont) {
        super(cont);
    }

    public void configure(NetworkListener networkListener, boolean isWebProfile, Habitat habitat) {
        this.listener = networkListener;
        if ("light-weight-listener".equals(networkListener.getProtocol())) {
            this.isGenericListener = true;
        }
        if (!this.isGenericListener) {
            super.configure(networkListener, isWebProfile, habitat);
        } else {
            this.initializeListener(networkListener, habitat);
            this.setName(networkListener.getName());
        }
    }

    private void initializeListener(NetworkListener networkListener, Habitat habitat) {
        this.serviceInitializer = new ServiceInitializerThread(this, habitat);
        this.serviceInitializer.setController(this.getController());
        this.serviceInitializer.configure(networkListener);
    }

    public NetworkListener getListener() {
        return this.listener;
    }

    public void start() throws IOException, InstantiationException {
        if (this.isGenericListener) {
            this.serviceInitializer.initController();
            this.serviceInitializer.startEndpoint();
        } else {
            this.getEmbeddedHttp().initEndpoint();
            this.getEmbeddedHttp().startEndpoint();
        }
    }

    public void stop() {
        if (this.isGenericListener) {
            this.serviceInitializer.stopEndpoint();
        } else {
            this.getEmbeddedHttp().stopEndpoint();
        }
    }

    public void initEndpoint() throws IOException, InstantiationException {
        if (this.isGenericListener) {
            this.serviceInitializer.initEndpoint();
        } else {
            this.getEmbeddedHttp().initEndpoint();
        }
    }

    public Controller getController() {
        if (this.isGenericListener) {
            return this.serviceInitializer.getController();
        }
        return this.getEmbeddedHttp().getController();
    }

    public void startEndpoint() throws IOException, InstantiationException {
        if (this.isGenericListener) {
            this.serviceInitializer.startEndpoint();
        } else {
            this.getEmbeddedHttp().startEndpoint();
        }
    }

    public boolean isGenericListener() {
        return this.isGenericListener;
    }

    public int getPort() {
        if (this.isGenericListener) {
            return this.serviceInitializer.getPort();
        }
        return this.getEmbeddedHttp().getPort();
    }
}

