/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.server.logging.logviewer.backend.LogFile;
import com.sun.enterprise.server.logging.logviewer.backend.LogRecordTemplate;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;

public class LogFilter {
    private static final String RESULTS_ATTRIBUTE = "Results";
    private static final String NV_SEPARATOR = ";";
    protected static final String[] LOG_LEVELS = new String[]{"SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static String[] serverLogElements = new String[]{System.getProperty("com.sun.aas.instanceRoot"), "logs", "server.log"};
    private static String pL = System.getProperty("com.sun.aas.processLauncher");
    private static String verboseMode = System.getProperty("com.sun.aas.verboseMode", "false");
    private static String defaultLogFile = System.getProperty("com.sun.aas.defaultLogFile");
    private static LogFile _logFile = pL != null && !verboseMode.equals("true") && defaultLogFile != null ? new LogFile(defaultLogFile) : new LogFile(StringUtils.makeFilePath((String[])serverLogElements, (boolean)false));
    private static Hashtable logFileCache = new Hashtable();

    public static AttributeList getLogRecordsUsingQuery(String logFileName, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Date fromDate, Date toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap) {
        long startingRecord;
        long reqCount;
        LogFile logFile = null;
        logFile = logFileName != null && logFileName.length() != 0 ? LogFilter.getLogFile(logFileName) : LogFilter.getLogFile();
        boolean forwd = forward == null ? true : forward;
        boolean nxt = next == null ? true : next;
        long l = reqCount = requestedCount == null ? logFile.getIndexSize() : (long)requestedCount.intValue();
        if (fromRecord == null) {
            nxt = forwd;
            startingRecord = forwd ? -1L : (logFile.getLastIndexNumber() + 1L) * logFile.getIndexSize();
        } else {
            startingRecord = fromRecord;
            if (startingRecord < -1L) {
                throw new IllegalArgumentException("fromRecord must be greater than 0!");
            }
        }
        try {
            return LogFilter.fetchRecordsUsingQuery(logFile, startingRecord, nxt, forwd, reqCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap);
        }
        catch (Exception ex) {
            System.err.println("Exception in fetchRecordsUsingQuer.." + ex);
            throw new RuntimeException(ex);
        }
    }

    protected static AttributeList fetchRecordsUsingQuery(LogFile logFile, long startingRecord, boolean next, boolean forward, long requestedCount, Date fromDate, Date toDate, String logLevel, boolean onlyLevel, List listOfModules, Properties nameValueMap) {
        boolean origForward = forward;
        if (next) {
            ++startingRecord;
            forward = true;
        } else {
            forward = false;
        }
        int inc = 1;
        int start = 0;
        int end = -1;
        long searchChunkIncrement = requestedCount;
        if (!forward) {
            inc = -1;
            if ((startingRecord -= next ? searchChunkIncrement - 1L : searchChunkIncrement) < 0L) {
                searchChunkIncrement += startingRecord;
                startingRecord = 0L;
            }
        }
        ArrayList<LogFile.LogEntry> results = new ArrayList<LogFile.LogEntry>();
        List records = null;
        LogFile.LogEntry entry = null;
        while ((long)results.size() < requestedCount && (records = logFile.getLogEntries(startingRecord, searchChunkIncrement)) != null) {
            if (forward) {
                end = records.size();
            } else {
                start = records.size() - 1;
            }
            for (int count = start; count != end && (long)results.size() < requestedCount; count += inc) {
                entry = (LogFile.LogEntry)records.get(count);
                if (!LogFilter.allChecks(entry, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap)) continue;
                results.add(entry);
            }
            if (forward) {
                if ((long)records.size() < searchChunkIncrement) break;
                startingRecord += searchChunkIncrement * (long)inc;
                searchChunkIncrement = requestedCount - (long)results.size();
                continue;
            }
            if (startingRecord == 0L) break;
            searchChunkIncrement = requestedCount - (long)results.size();
            if ((startingRecord += searchChunkIncrement * (long)inc) >= 1L) continue;
            searchChunkIncrement += startingRecord;
            startingRecord = 0L;
        }
        if (next ^ origForward) {
            ArrayList reversedResults = new ArrayList();
            for (int count = results.size() - 1; count > -1; --count) {
                reversedResults.add(results.get(count));
            }
            results = reversedResults;
        }
        return LogFilter.convertResultsToTheStructure(results);
    }

    private static AttributeList convertResultsToTheStructure(List results) {
        if (results == null) {
            return null;
        }
        AttributeList resultsInTemplate = new AttributeList();
        resultsInTemplate.add(LogRecordTemplate.getHeader());
        Iterator iterator = results.iterator();
        ArrayList listOfResults = new ArrayList();
        Attribute resultsAttribute = new Attribute(RESULTS_ATTRIBUTE, listOfResults);
        resultsInTemplate.add(resultsAttribute);
        while (iterator.hasNext()) {
            LogFile.LogEntry entry = (LogFile.LogEntry)iterator.next();
            ArrayList<Object> logRecord = new ArrayList<Object>();
            logRecord.add(new Long(entry.getRecordNumber()));
            logRecord.add(entry.getLoggedDateTime());
            logRecord.add(entry.getLoggedLevel());
            logRecord.add(entry.getLoggedProduct());
            logRecord.add(entry.getLoggedLoggerName());
            logRecord.add(entry.getLoggedNameValuePairs());
            logRecord.add(entry.getMessageId());
            logRecord.add(entry.getLoggedMessage());
            listOfResults.add(logRecord);
        }
        return resultsInTemplate;
    }

    public static LogFile getLogFile() {
        return _logFile;
    }

    public static LogFile getLogFile(String fileName) {
        String logFileName = fileName.trim();
        LogFile logFile = (LogFile)logFileCache.get(fileName);
        String parent = null;
        if (logFile == null) {
            try {
                if (new File(fileName).exists()) {
                    logFile = new LogFile(fileName);
                    logFileCache.put(fileName, logFile);
                    return logFile;
                }
                if (LogFilter.getLogFile() != null) {
                    parent = new File(LogFilter.getLogFile().getLogFileName()).getParent();
                } else {
                    String[] logPath = new String[]{System.getProperty("com.sun.aas.instanceRoot"), "logs"};
                    parent = StringUtils.makeFilePath((String[])logPath, (boolean)false);
                }
            }
            catch (Exception e) {
                System.err.println("Exception " + e + "thrown in Logviewer backend");
            }
            if (parent != null) {
                String[] logFileNameParts = new String[]{parent, logFileName};
                logFileName = StringUtils.makeFilePath((String[])logFileNameParts, (boolean)false);
            }
            logFile = new LogFile(logFileName);
            logFileCache.put(fileName, logFile);
        }
        return logFile;
    }

    public static synchronized void setLogFile(LogFile logFile) {
        _logFile = logFile;
    }

    protected static void updateModuleList(List listOfModules) {
        if (listOfModules == null) {
            return;
        }
        Iterator iterator = listOfModules.iterator();
    }

    protected static boolean allChecks(LogFile.LogEntry entry, Date fromDate, Date toDate, String queryLevel, boolean onlyLevel, List listOfModules, Properties nameValueMap) {
        return LogFilter.dateTimeCheck(entry.getLoggedDateTime(), fromDate, toDate) && LogFilter.levelCheck(entry.getLoggedLevel(), queryLevel, onlyLevel) && LogFilter.moduleCheck(entry.getLoggedLoggerName(), listOfModules) && LogFilter.nameValueCheck(entry.getLoggedNameValuePairs(), nameValueMap);
    }

    protected static boolean dateTimeCheck(Date loggedDateTime, Date fromDateTime, Date toDateTime) {
        if (fromDateTime == null || toDateTime == null) {
            return true;
        }
        return !loggedDateTime.before(fromDateTime) && !loggedDateTime.after(toDateTime);
    }

    protected static boolean levelCheck(String loggedLevel, String queryLevelIn, boolean isOnlyLevelFlag) {
        if (queryLevelIn == null) {
            return true;
        }
        String queryLevel = queryLevelIn.trim();
        if (isOnlyLevelFlag) {
            if (loggedLevel.equals(queryLevel)) {
                return true;
            }
        } else {
            for (int idx = 0; idx < LOG_LEVELS.length; ++idx) {
                if (loggedLevel.equals(LOG_LEVELS[idx])) {
                    return true;
                }
                if (LOG_LEVELS[idx].equals(queryLevel)) break;
            }
        }
        return false;
    }

    protected static boolean moduleCheck(String loggerName, List modules) {
        if (modules == null || modules.size() == 0) {
            return true;
        }
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            if (!loggerName.startsWith((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected static boolean nameValueCheck(String loggedNameValuePairs, Properties queriedNameValueMap) {
        if (queriedNameValueMap == null) {
            return true;
        }
        if (loggedNameValuePairs == null) {
            return false;
        }
        StringTokenizer nvListTokenizer = new StringTokenizer(loggedNameValuePairs, NV_SEPARATOR);
        while (nvListTokenizer.hasMoreTokens()) {
            String nameandvalue = nvListTokenizer.nextToken();
            StringTokenizer nvToken = new StringTokenizer(nameandvalue, "=");
            if (nvToken.countTokens() < 2) continue;
            String loggedName = nvToken.nextToken();
            String loggedValue = nvToken.nextToken();
            for (Map.Entry<Object, Object> entry : queriedNameValueMap.entrySet()) {
                if (!entry.getKey().equals(loggedName)) continue;
                Object value = entry.getValue();
                Iterator iterator = ((List)value).iterator();
                while (iterator.hasNext()) {
                    if (!((String)iterator.next()).equals(loggedValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

