/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.util.Iterator;
import java.util.TreeSet;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

@Service(name="list-contracts", metadata="mode=debug")
public class ListContracts
implements AdminCommand {
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Habitat habitat;
    @Param(primary=true, optional=true)
    String contract = null;
    @Param(optional=true)
    String started = "false";

    public void execute(AdminCommandContext context) {
        StringBuilder sb = new StringBuilder();
        if (this.contract == null) {
            this.dumpContracts(sb);
        } else {
            this.dumpContract(this.contract, sb);
        }
        String msg = sb.toString();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (report instanceof PropsFileActionReporter) {
            msg = ManifestUtils.encode((String)msg);
        }
        report.setMessage(msg);
    }

    private void dumpContracts(StringBuilder sb) {
        sb.append("\n*********** Sorted List of all Registered Contracts in the Habitat **************\n");
        Iterator it = this.habitat.getAllContracts();
        if (it == null) {
            return;
        }
        TreeSet contracts = new TreeSet();
        while (it != null && it.hasNext()) {
            contracts.add(it.next());
        }
        it = contracts.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Contract-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }

    private void dumpContract(String name, StringBuilder sb) {
        sb.append("\n*********** List of all services for contract " + this.contract + " **************\n");
        for (Inhabitant i : this.habitat.getInhabitantsByContract(name)) {
            sb.append("Service-" + i.typeName());
            boolean isStarted = Boolean.parseBoolean(this.started);
            if (isStarted) {
                sb.append(i.isInstantiated() ? " started" : " not started");
            }
            sb.append("\n");
        }
    }
}

