/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.Server;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class EmbeddedDeployerImpl
implements EmbeddedDeployer {
    @Inject
    Deployment deployment;
    @Inject
    Server server;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Habitat habitat;
    @Inject
    ArchiveFactory factory;
    @Inject
    SnifferManager snifferMgr;
    @Inject
    ServerEnvironment env;
    @Inject
    DasConfig config;
    private static final Logger l = LogDomains.getLogger(EmbeddedDeployerImpl.class, (String)"javax.enterprise.system.tools.deployment");
    Map<String, ApplicationInfo> deployedApps = new HashMap<String, ApplicationInfo>();
    static final Logger logger = LogDomains.getLogger(EmbeddedDeployerImpl.class, (String)"javax.enterprise.system.core");

    public File getApplicationsDir() {
        return this.env.getApplicationRepositoryPath();
    }

    public void enableAutoDeploy() {
        this.changeAutoDeployState(true);
    }

    private void changeAutoDeployState(final boolean newState) {
        boolean active;
        String value = this.config.getAutodeployEnabled();
        boolean bl = active = value != null && Boolean.parseBoolean(this.config.getAutodeployEnabled());
        if (active != newState) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<DasConfig>(){

                    public Object run(DasConfig dasConfig) throws PropertyVetoException, TransactionFailure {
                        dasConfig.setAutodeployEnabled(Boolean.valueOf(newState).toString());
                        return null;
                    }
                }, (ConfigBeanProxy)this.config);
            }
            catch (TransactionFailure e) {
                logger.log(Level.SEVERE, "Exception while enabling or disabling the autodeployment of applications", e);
            }
        }
    }

    public void disableAutoDeploy() {
        this.changeAutoDeployState(false);
    }

    public String deploy(File archive, DeployCommandParameters params) {
        try {
            ReadableArchive r = this.factory.openArchive(archive);
            return this.deploy(r, params);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String deploy(ReadableArchive archive, DeployCommandParameters params) {
        PlainTextActionReporter report = new PlainTextActionReporter();
        ExtendedDeploymentContext context = null;
        try {
            context = this.deployment.getContext(logger, archive, (OpsParams)params, (ActionReport)report);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassLoader cl = context.getClassLoader();
        Collection sniffers = this.snifferMgr.getSniffers(archive, cl);
        ArrayList<Sniffer> finalSniffers = new ArrayList<Sniffer>();
        for (EmbeddedContainer container : this.server.getContainers()) {
            for (Sniffer sniffer : container.getSniffers()) {
                if (!sniffers.contains(sniffer)) continue;
                finalSniffers.add(sniffer);
            }
        }
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.deployment.deploy(finalSniffers, context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (appInfo != null) {
            this.deployedApps.put(appInfo.getName(), appInfo);
            return appInfo.getName();
        }
        return null;
    }

    public void undeploy(String name) {
        ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
        ApplicationInfo info = this.deployedApps.get(name);
        if (info == null) {
            info = this.deployment.get(name);
        }
        if (info == null) {
            report.setMessage("Cannot find deployed application of name " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive source = info.getSource();
        if (source == null) {
            report.setMessage("Cannot get source archive for undeployment");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        UndeployCommandParameters params = new UndeployCommandParameters(name);
        ExtendedDeploymentContext deploymentContext = null;
        try {
            deploymentContext = this.deployment.getContext(logger, source, (OpsParams)params, report);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (info != null) {
            this.deployment.undeploy(name, deploymentContext);
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            deploymentContext.clean();
        }
    }

    public void undeployAll() {
        for (String appName : this.deployedApps.keySet()) {
            this.undeploy(appName);
        }
    }
}

