/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.branding.Branding;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Init;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

@Service
public class AppServerStartup
implements ModuleStartup {
    StartupContext context;
    static final Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry systemRegistry;
    @Inject
    ExecutorService executor;
    @Inject
    Events events;
    @Inject
    Branding branding;
    @Inject
    ClassLoaderHierarchy cch;
    private Thread serverThread;

    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    public void start() {
        Thread.currentThread().setContextClassLoader(this.cch.getCommonClassLoader());
        this.run();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverThread = new Thread("GlassFish Kernel Main Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.logp(Level.INFO, "AppServerStartup", "run", "[{0}] started", new Object[]{this});
                latch.countDown();
                try {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                logger.logp(Level.INFO, "AppServerStartup", "run", "[{0}] exiting", new Object[]{this});
            }
        };
        this.serverThread.setDaemon(false);
        this.serverThread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void run() {
        String platform = System.getProperty("GlassFish_Platform");
        if (platform == null) {
            platform = "Embedded";
        }
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
            return;
        }
        long platformInitTime = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Startup class : " + this.getClass().getName());
        }
        this.habitat.addComponent(null, (Object)this);
        this.habitat.addComponent(null, (Object)this.systemRegistry);
        this.habitat.addComponent("javax.enterprise.system.core", (Object)logger);
        Inhabitant inh = this.habitat.getInhabitantByType(ProcessEnvironment.class);
        if (inh != null) {
            this.habitat.remove(inh);
        }
        this.habitat.removeAllByType(ProcessEnvironment.class);
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(ProcessEnvironment.class, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Server)));
        for (Inhabitant init : this.habitat.getInhabitants(Init.class)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(init.type() + " Init started in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
            }
            init.get();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine(init.type() + " Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        final Collection startups = this.habitat.getInhabitants(Startup.class);
        Future<?> result = this.executor.submit(new Runnable(){

            public void run() {
                for (Inhabitant i : startups) {
                    if (i.type().getAnnotation(Async.class) == null) continue;
                    i.get();
                }
            }
        });
        boolean shutdownRequested = false;
        ArrayList futures = new ArrayList();
        for (Inhabitant i : startups) {
            if (i.type().getAnnotation(Async.class) != null) continue;
            try {
                Startup startup;
                if (logger.isLoggable(Level.FINE)) {
                    logger.info(i.type() + " startup started at " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
                }
                if ((startup = (Startup)i.get()) instanceof FutureProvider) {
                    futures.addAll(((FutureProvider)startup).getFutures());
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                logger.info("Startup service failed to start : " + e.getMessage());
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine(i.type() + " startup done at " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
        }
        this.env.setStatus(ServerEnvironment.Status.starting);
        this.events.send(new EventListener.Event(EventTypes.SERVER_STARTUP), false);
        logger.info(this.branding.getVersion() + " startup time : " + platform + "(" + (platformInitTime - this.context.getCreationTime()) + "ms)" + " startup services(" + (System.currentTimeMillis() - platformInitTime) + "ms)" + " total(" + (System.currentTimeMillis() - this.context.getCreationTime()) + "ms)");
        try {
            long realstart = Long.parseLong(System.getProperty("WALL_CLOCK_START"));
            logger.info("TOTAL TIME INCLUDING CLI: " + (System.currentTimeMillis() - realstart));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            result.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (shutdownRequested) {
            this.shutdown();
        } else {
            for (Future future : futures) {
                try {
                    if (!((Result)future.get()).isFailure()) continue;
                    Throwable t = ((Result)future.get()).exception();
                    logger.log(Level.SEVERE, "Shutting down v3 due to startup exception : " + t.getMessage());
                    logger.log(Level.FINE, ((Result)future.get()).exception().getMessage(), t);
                    this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN));
                    this.shutdown();
                    return;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }
        this.env.setStatus(ServerEnvironment.Status.started);
        this.events.send(new EventListener.Event(EventTypes.SERVER_READY), false);
    }

    private final void shutdown() {
        CommandRunner runner = (CommandRunner)this.habitat.getByContract(CommandRunner.class);
        if (runner != null) {
            Properties params = new Properties();
            if (this.context.getArguments().containsKey("--noforcedshutdown")) {
                params.put("force", "false");
            }
            runner.doCommand("stop-domain", params, (ActionReport)new PlainTextActionReporter());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.env.setStatus(ServerEnvironment.Status.stopping);
        this.events.send(new EventListener.Event(EventTypes.PREPARE_SHUTDOWN), false);
        try {
            for (Inhabitant svc : this.habitat.getInhabitants(Startup.class)) {
                if (!svc.isInstantiated()) continue;
                try {
                    svc.release();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            for (Inhabitant svc : this.habitat.getInhabitants(Init.class)) {
                if (!svc.isInstantiated()) continue;
                try {
                    svc.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.env.setStatus(ServerEnvironment.Status.stopped);
            this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
        }
        catch (ComponentException e) {
            // empty catch block
        }
        Thread e = this.serverThread;
        synchronized (e) {
            this.serverThread.notify();
        }
        try {
            this.serverThread.join(0L);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

