/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.net.NetUtils;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SystemTasks
implements Init,
PostConstruct {
    @Inject(optional=true)
    JavaConfig javaConfig;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    Domain domain;
    Logger _logger = Logger.getAnonymousLogger();

    public void postConstruct() {
        this.setSystemPropertiesFromEnv();
        this.setSystemPropertiesFromDomainXml();
        this.resolveJavaConfig();
        this._logger.fine("SystemTasks: loaded server named: " + this.server.getName());
    }

    private void setSystemProperty(String name, String value) {
        System.setProperty(name, value);
    }

    private void setSystemPropertiesFromEnv() {
        String hostname;
        block3: {
            this.setSystemProperty("com.sun.aas.javaRoot", System.getProperty("java.home"));
            hostname = "localhost";
            try {
                hostname = NetUtils.getCanonicalHostName();
            }
            catch (Exception ex) {
                if (this._logger == null) break block3;
                this._logger.log(Level.SEVERE, "cannot determine host name, will use localhost exclusively", ex);
            }
        }
        if (this._logger != null) {
            this.setSystemProperty("com.sun.aas.hostName", hostname);
        }
    }

    private void setSystemPropertiesFromDomainXml() {
        List domainSPList = this.domain.getSystemProperty();
        List<SystemProperty> configSPList = this.getConfigSystemProperties();
        List serverSPList = this.server.getSystemProperty();
        this.setSystemProperties(domainSPList);
        this.setSystemProperties(configSPList);
        this.setSystemProperties(serverSPList);
    }

    private List<SystemProperty> getConfigSystemProperties() {
        try {
            String configName = this.server.getConfigRef();
            Configs configs = this.domain.getConfigs();
            List configsList = configs.getConfig();
            Config config = null;
            for (Config c : configsList) {
                if (!c.getName().equals(configName)) continue;
                config = c;
                break;
            }
            return config != null ? config.getSystemProperty() : Collections.emptyList();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private void resolveJavaConfig() {
        if (this.javaConfig != null) {
            Pattern p = Pattern.compile("-D([^=]*)=(.*)");
            for (String jvmOption : this.javaConfig.getJvmOptions()) {
                Matcher m = p.matcher(jvmOption);
                if (!m.matches()) continue;
                this.setSystemProperty(m.group(1), TranslatedConfigView.getTranslatedValue((Object)m.group(2)).toString());
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.fine("Setting " + m.group(1) + " = " + TranslatedConfigView.getTranslatedValue((Object)m.group(2)));
            }
        }
    }

    private void setSystemProperties(List<SystemProperty> spList) {
        for (SystemProperty sp : spList) {
            String name = sp.getName();
            String value = sp.getValue();
            if (!SystemTasks.ok(name)) continue;
            this.setSystemProperty(name, value);
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

