/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.probes.ConnectionsProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.probes.FileCacheProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.probes.KeepAliveProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.probes.ThreadPoolProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionsStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.FileCacheStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.KeepAliveStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;

public class GrizzlyMonitoring {
    private static final String CONFIG_ELEMENT = "http-service";
    private final Map<String, ThreadPoolStatsProvider> threadPoolStatsProvidersMap = new ConcurrentHashMap<String, ThreadPoolStatsProvider>();
    private final Map<String, FileCacheStatsProvider> fileCacheStatsProvidersMap = new ConcurrentHashMap<String, FileCacheStatsProvider>();
    private final Map<String, KeepAliveStatsProvider> keepAliveStatsProvidersMap = new ConcurrentHashMap<String, KeepAliveStatsProvider>();
    private final Map<String, ConnectionsStatsProvider> connectionsStatsProvidersMap = new ConcurrentHashMap<String, ConnectionsStatsProvider>();
    private final ThreadPoolProbeProvider threadPoolProbeProvider = new ThreadPoolProbeProvider();
    private final FileCacheProbeProvider fileCacheProbeProvider = new FileCacheProbeProvider();
    private final KeepAliveProbeProvider keepAliveProbeProvider = new KeepAliveProbeProvider();
    private final ConnectionsProbeProvider connectionsProbeProvider = new ConnectionsProbeProvider();

    public ThreadPoolProbeProvider getThreadPoolProbeProvider() {
        return this.threadPoolProbeProvider;
    }

    public FileCacheProbeProvider getFileCacheProbeProvider() {
        return this.fileCacheProbeProvider;
    }

    public KeepAliveProbeProvider getKeepAliveProbeProvider() {
        return this.keepAliveProbeProvider;
    }

    public ConnectionsProbeProvider getConnectionsProbeProvider() {
        return this.connectionsProbeProvider;
    }

    public void registerThreadPoolStatsProvider(String name) {
        ThreadPoolStatsProvider threadPoolStatsProvider = new ThreadPoolStatsProvider(name);
        ThreadPoolStatsProvider oldthreadPoolStatsProvider = this.threadPoolStatsProvidersMap.put(name, threadPoolStatsProvider);
        if (oldthreadPoolStatsProvider != null) {
            StatsProviderManager.unregister((Object)oldthreadPoolStatsProvider);
        }
        StatsProviderManager.register((String)CONFIG_ELEMENT, (PluginPoint)PluginPoint.SERVER, (String)(this.subtreePrefix(name) + "/thread-pool"), (Object)threadPoolStatsProvider);
    }

    public void unregisterThreadPoolStatsProvider(String name) {
        ThreadPoolStatsProvider threadPoolStatsProvider = this.threadPoolStatsProvidersMap.remove(name);
        if (threadPoolStatsProvider != null) {
            StatsProviderManager.unregister((Object)threadPoolStatsProvider);
        }
    }

    public void registerKeepAliveStatsProvider(String name) {
        KeepAliveStatsProvider keepAliveStatsProvider = new KeepAliveStatsProvider(name);
        KeepAliveStatsProvider oldKeepAliveStatsProvider = this.keepAliveStatsProvidersMap.put(name, keepAliveStatsProvider);
        if (oldKeepAliveStatsProvider != null) {
            StatsProviderManager.unregister((Object)oldKeepAliveStatsProvider);
        }
        StatsProviderManager.register((String)CONFIG_ELEMENT, (PluginPoint)PluginPoint.SERVER, (String)(this.subtreePrefix(name) + "/keep-alive"), (Object)keepAliveStatsProvider);
    }

    public void unregisterKeepAliveStatsProvider(String name) {
        KeepAliveStatsProvider keepAliveStatsProvider = this.keepAliveStatsProvidersMap.remove(name);
        if (keepAliveStatsProvider != null) {
            StatsProviderManager.unregister((Object)keepAliveStatsProvider);
        }
    }

    public void registerFileCacheStatsProvider(String name) {
        FileCacheStatsProvider fileCacheStatsProvider = new FileCacheStatsProvider(name);
        FileCacheStatsProvider oldFileCacheStatsProvider = this.fileCacheStatsProvidersMap.put(name, fileCacheStatsProvider);
        if (oldFileCacheStatsProvider != null) {
            StatsProviderManager.unregister((Object)oldFileCacheStatsProvider);
        }
        StatsProviderManager.register((String)CONFIG_ELEMENT, (PluginPoint)PluginPoint.SERVER, (String)(this.subtreePrefix(name) + "/file-cache"), (Object)fileCacheStatsProvider);
    }

    public void unregisterFileCacheStatsProvider(String name) {
        FileCacheStatsProvider fileCacheStatsProvider = this.fileCacheStatsProvidersMap.remove(name);
        if (fileCacheStatsProvider != null) {
            StatsProviderManager.unregister((Object)fileCacheStatsProvider);
        }
    }

    public void registerConnectionsStatsProvider(String name) {
        ConnectionsStatsProvider connectionsStatsProvider = new ConnectionsStatsProvider(name);
        ConnectionsStatsProvider oldConnectionsStatsProvider = this.connectionsStatsProvidersMap.put(name, connectionsStatsProvider);
        if (oldConnectionsStatsProvider != null) {
            StatsProviderManager.unregister((Object)oldConnectionsStatsProvider);
        }
        StatsProviderManager.register((String)CONFIG_ELEMENT, (PluginPoint)PluginPoint.SERVER, (String)(this.subtreePrefix(name) + "/connections"), (Object)connectionsStatsProvider);
    }

    public void unregisterConnectionsStatsProvider(String name) {
        ConnectionsStatsProvider connectionsStatsProvider = this.connectionsStatsProvidersMap.remove(name);
        if (connectionsStatsProvider != null) {
            StatsProviderManager.unregister((Object)connectionsStatsProvider);
        }
    }

    private String subtreePrefix(String name) {
        return "network/" + name;
    }
}

