/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.ThreadPool;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-threadpools")
@Scoped(value=PerLookup.class)
@I18n(value="list.threadpools")
public class ListThreadpools
implements AdminCommand {
    @Inject
    ThreadPools threadPools;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListThreadpools.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            List poolList = this.threadPools.getThreadPool();
            for (ThreadPool pool : poolList) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(pool.getName());
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            String str = e.getMessage();
            report.setMessage(localStrings.getLocalString("list.thread.pools.failed", "List Thread Pools failed because of: " + str));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

