/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.util.Map;
import javax.naming.InitialContext;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ServerContextImpl
implements ServerContext,
PostConstruct {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    StartupContext startupContext;
    @Inject
    Habitat habitat;
    @Inject
    ClassLoaderHierarchy clh;
    File instanceRoot;
    String instanceName = "server";
    String[] args;

    public void postConstruct() {
        this.instanceRoot = this.env.getDomainRoot();
        this.args = new String[this.startupContext.getArguments().size() * 2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : this.startupContext.getArguments().entrySet()) {
            this.args[i++] = entry.getKey().toString();
            this.args[i++] = entry.getValue().toString();
        }
    }

    public File getInstanceRoot() {
        return this.instanceRoot;
    }

    public String[] getCmdLineArgs() {
        return this.args;
    }

    public File getInstallRoot() {
        return this.startupContext.getRootDirectory().getParentFile();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getServerConfigURL() {
        File domainXML = new File(this.instanceRoot, "config");
        domainXML = new File(domainXML, "domain.xml");
        return domainXML.toURI().toString();
    }

    public Server getConfigBean() {
        return (Server)this.habitat.getComponent(Server.class);
    }

    public InitialContext getInitialContext() {
        GlassfishNamingManager gfNamingManager = (GlassfishNamingManager)this.habitat.getComponent(GlassfishNamingManager.class);
        return (InitialContext)gfNamingManager.getInitialContext();
    }

    public ClassLoader getCommonClassLoader() {
        return this.clh.getCommonClassLoader();
    }

    public ClassLoader getSharedClassLoader() {
        return this.clh.getConnectorClassLoader(null);
    }

    public ClassLoader getLifecycleParentClassLoader() {
        return this.clh.getConnectorClassLoader(null);
    }

    public InvocationManager getInvocationManager() {
        return (InvocationManager)this.habitat.getComponent(InvocationManager.class);
    }

    public String getDefaultDomainName() {
        return "com.sun.appserv";
    }

    public Habitat getDefaultHabitat() {
        return this.habitat;
    }
}

