/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.universal.GFBase64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.listener.GenericJavaConfigListener;
import com.sun.enterprise.v3.admin.listener.SystemPropertyListener;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.hk2.component.ConstructorWomb;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.Privacy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminAdapter
extends GrizzlyAdapter
implements Adapter,
PostConstruct,
EventListener {
    public static final String VS_NAME = "__asadmin";
    public static final String PREFIX_URI = "/__asadmin";
    public static final Logger logger = LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin");
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(AdminAdapter.class);
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final GFBase64Decoder decoder = new GFBase64Decoder();
    private static final String BASIC = "Basic ";
    private static final String QUERY_STRING_SEPARATOR = "&";
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    CommandRunnerImpl commandRunner;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Events events;
    @Inject(name="server-config")
    Config config;
    private AdminEndpointDecider epd = null;
    @Inject
    ServerContext sc;
    @Inject
    Habitat habitat;
    @Inject
    volatile AdminService as = null;
    @Inject
    volatile Domain domain;
    final Class<? extends Privacy> privacyClass;
    private boolean isRegistered = false;
    CountDownLatch latch = new CountDownLatch(1);

    protected AdminAdapter(Class<? extends Privacy> privacyClass) {
        this.privacyClass = privacyClass;
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.epd = new AdminEndpointDecider(this.config, logger);
        this.registerDynamicReconfigListeners();
        this.setHandleStaticResources(true);
        this.setRootFolder((String)this.env.getProps().get("com.sun.aas.instanceRoot") + "/asadmindocroot/");
    }

    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        LogHelper.getDefaultLogger().finer("Admin adapter !");
        LogHelper.getDefaultLogger().finer("Received something on " + req.getRequestURI());
        LogHelper.getDefaultLogger().finer("QueryString = " + req.getQueryString());
        String requestURI = req.getRequestURI();
        ActionReport report = this.getClientActionReport(requestURI, req);
        if (requestURI.indexOf(46) != -1) {
            requestURI = requestURI.substring(0, requestURI.indexOf(46));
        }
        PayloadImpl.Outbound outboundPayload = PayloadImpl.Outbound.newInstance();
        try {
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                report = this.getClientActionReport(req.getRequestURI(), req);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("V3 cannot process this command at this time, please wait");
            } else {
                if (!this.authenticate(req, report, res)) {
                    return;
                }
                report = this.doCommand(requestURI, req, report, (Payload.Outbound)outboundPayload);
            }
        }
        catch (InterruptedException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("V3 cannot process this command at this time, please wait");
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Exception while processing command: " + e);
        }
        try {
            res.setStatus(200);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            report.writeReport((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            outboundPayload.addPart(0, report.getContentType(), "report", null, (InputStream)bais);
            res.setContentType(outboundPayload.getContentType());
            outboundPayload.writeTo((OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.finishResponse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean authenticate(Request req) throws Exception {
        String[] up = AdminAdapter.getUserPassword(req);
        String user = up[0];
        String password = up.length > 1 ? up[1] : "";
        AdminAccessController authenticator = (AdminAccessController)this.habitat.getByContract(AdminAccessController.class);
        if (authenticator != null) {
            return authenticator.loginAsAdmin(user, password, this.as.getAuthRealmName());
        }
        return true;
    }

    public static String[] getUserPassword(Request req) throws IOException {
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            return new String[]{"", ""};
        }
        String enc = authHeader.substring(BASIC.length());
        String dec = new String(decoder.decodeBuffer(enc));
        int i = dec.indexOf(58);
        if (i < 0) {
            return new String[]{"", ""};
        }
        return new String[]{dec.substring(0, i), dec.substring(i + 1)};
    }

    private boolean authenticate(GrizzlyRequest req, ActionReport report, GrizzlyResponse res) throws Exception {
        boolean authenticated = this.authenticate(req.getRequest());
        if (!authenticated) {
            String msg = adminStrings.getLocalString("adapter.auth.userpassword", "Invalid user name or password");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            report.setActionDescription("Authentication error");
            res.setStatus(401);
            res.setHeader("WWW-Authenticate", "BASIC");
            res.setContentType(report.getContentType());
            report.writeReport((OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.finishResponse();
        }
        return authenticated;
    }

    private ActionReport getClientActionReport(String requestURI, GrizzlyRequest req) {
        ActionReport report = null;
        if (requestURI.indexOf(46) != -1) {
            String qualifier = requestURI.substring(requestURI.indexOf(46) + 1);
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, qualifier);
        } else {
            String accept;
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null) {
                report = (ActionReport)this.habitat.getComponent(ActionReport.class, userAgent.substring(userAgent.indexOf(47) + 1));
            }
            if (report == null && (accept = req.getHeader("Accept")) != null) {
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (report == null && st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    report = (ActionReport)this.habitat.getComponent(ActionReport.class, scheme.substring(scheme.indexOf(47) + 1));
                }
            }
        }
        if (report == null) {
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, "html");
        }
        return report;
    }

    protected abstract boolean validatePrivacy(AdminCommand var1);

    private ActionReport doCommand(String requestURI, GrizzlyRequest req, ActionReport report, Payload.Outbound outboundPayload) {
        if (!requestURI.startsWith(this.getContextRoot())) {
            String msg = adminStrings.getLocalString("adapter.panic", "Wrong request landed in AdminAdapter {0}", new Object[]{requestURI});
            report.setMessage(msg);
            LogHelper.getDefaultLogger().info(msg);
            return report;
        }
        String command = "";
        if (requestURI.length() > this.getContextRoot().length() + 1) {
            command = requestURI.substring(this.getContextRoot().length() + 1);
        }
        ParameterMap parameters = this.extractParameters(req.getQueryString());
        try {
            AdminCommand adminCommand;
            PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)req.getContentType(), (InputStream)req.getInputStream());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("***** AdminAdapter " + req.getMethod() + "  *****");
            }
            if ((adminCommand = this.commandRunner.getCommand(command, report, logger)) == null) {
                String message = adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{command});
                logger.log(Level.FINE, message);
                report.setMessage(message);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return report;
            }
            if (!this.validatePrivacy(adminCommand)) {
                report.failure(logger, adminStrings.getLocalString("adapter.wrongprivacy", "Command {0} does not have {1} visibility", new Object[]{command, this.privacyClass.getSimpleName().toLowerCase()}), null);
                return report;
            }
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(command, report);
            inv.parameters(parameters).inbound((Payload.Inbound)inboundPayload).outbound(outboundPayload).execute();
        }
        catch (Throwable t) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(t);
            report.setMessage(t.getLocalizedMessage());
            report.setActionDescription("Last-chance AdminAdapter exception handler");
        }
        return report;
    }

    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    ParameterMap extractParameters(String requestString) {
        ParameterMap parameters = new ParameterMap();
        StringTokenizer stoken = new StringTokenizer(requestString == null ? "" : requestString, QUERY_STRING_SEPARATOR);
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            if (token.indexOf("=") == -1) continue;
            String paramName = null;
            String value = null;
            paramName = token.substring(0, token.indexOf("="));
            value = token.substring(token.indexOf("=") + 1);
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.WARNING, adminStrings.getLocalString("adapter.param.decode", "Cannot decode parameter {0} = {1}"));
            }
            parameters.add(paramName, value);
        }
        if (logger.isLoggable(Level.FINER)) {
            for (Map.Entry entry : parameters.entrySet()) {
                for (String v : (List)entry.getValue()) {
                    logger.finer("Key " + (String)entry.getKey() + " = " + v);
                }
            }
        }
        return parameters;
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.latch.countDown();
            logger.fine("Ready to receive administrative commands");
        }
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    private void registerJavaConfigListener() {
        Habitat habitat = this.sc.getDefaultHabitat();
        ConstructorWomb womb = new ConstructorWomb(GenericJavaConfigListener.class, habitat, null);
        ConfigListener jcl = (ConfigListener)womb.get(null);
    }

    private void registerSystemPropertyListener() {
        ObservableBean ob = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.domain);
        SystemPropertyListener ls = (SystemPropertyListener)this.habitat.getComponent(SystemPropertyListener.class);
        ob.addListener((ConfigListener)ls);
        Server s = this.domain.getServerNamed("server");
        ob = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)s);
        ob.addListener((ConfigListener)ls);
    }

    private void registerDynamicReconfigListeners() {
        this.registerJavaConfigListener();
        this.registerSystemPropertyListener();
    }
}

