/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.server.AppServerStartup;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.internal.api.DomainUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="upgrade")
public class UpgradeStartup
implements ModuleStartup {
    @Inject
    CommandRunner runner;
    @Inject
    AppServerStartup appservStartup;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ServerEnvironment env;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    CommandRunner commandRunner;
    @Inject(optional=true)
    DomainUpgrade[] upgrades = null;
    @Inject
    Logger logger;
    private static final String MODULE_TYPE = "moduleType";
    private static final String J2EE_APPS = "j2ee-apps";
    private static final String J2EE_MODULES = "j2ee-modules";

    public void setStartupContext(StartupContext startupContext) {
        this.appservStartup.setStartupContext(startupContext);
    }

    public void start() {
        ArrayList<ApplicationRef> enabledApps = new ArrayList<ApplicationRef>();
        ArrayList<String> enabledAppNames = new ArrayList<String>();
        for (ApplicationRef appRef : this.server.getApplicationRef()) {
            this.logger.log(Level.INFO, "app " + appRef.getRef() + " is " + appRef.getEnabled() + " resulting in " + Boolean.parseBoolean(appRef.getEnabled()));
            if (!Boolean.parseBoolean(appRef.getEnabled())) continue;
            this.logger.log(Level.INFO, "Disabling application " + appRef.getRef());
            enabledApps.add(appRef);
            enabledAppNames.add(appRef.getRef());
        }
        if (enabledApps.size() > 0) {
            try {
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... configBeanProxies) throws PropertyVetoException, TransactionFailure {
                        for (ConfigBeanProxy proxy : configBeanProxies) {
                            ApplicationRef appRef = (ApplicationRef)proxy;
                            appRef.setEnabled(Boolean.FALSE.toString());
                        }
                        return null;
                    }
                }, (ConfigBeanProxy[])((ConfigBeanProxy[])enabledApps.toArray(new ApplicationRef[enabledApps.size()])));
            }
            catch (TransactionFailure tf) {
                this.logger.log(Level.SEVERE, "Exception while disabling applications", tf);
                return;
            }
        }
        this.appservStartup.start();
        for (Application app : this.applications.getApplications()) {
            if (Boolean.valueOf(app.getDeployProperties().getProperty("isLifecycle")).booleanValue()) continue;
            this.logger.log(Level.INFO, "Redeploy application " + app.getName() + " located at " + app.getLocation());
            this.redeployApp(app);
        }
        if (enabledAppNames.size() > 0) {
            for (ApplicationRef appRef : this.server.getApplicationRef()) {
                if (!enabledAppNames.contains(appRef.getRef())) continue;
                this.logger.log(Level.INFO, "Enabling application " + appRef.getRef());
                try {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ApplicationRef>(){

                        public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                            param.setEnabled(Boolean.TRUE.toString());
                            return null;
                        }
                    }, (ConfigBeanProxy)appRef);
                }
                catch (TransactionFailure tf) {
                    this.logger.log(Level.SEVERE, "Exception while re-enabling application " + appRef.getRef(), tf);
                    return;
                }
            }
        }
        this.cleanupLeftOverDirectories();
        Logger.getAnonymousLogger().info("Exiting after upgrade");
        try {
            Thread.sleep(3000L);
            if (this.runner != null) {
                this.runner.getCommandInvocation("stop-domain", (ActionReport)new PlainTextActionReporter()).execute();
            }
        }
        catch (InterruptedException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while attempting to shutdown after upgrade", e);
        }
    }

    public void stop() {
        this.appservStartup.stop();
    }

    private void cleanupLeftOverDirectories() {
        File oldJ2eeAppsRepository = new File(this.env.getApplicationRepositoryPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsRepository);
        File oldJ2eeModulesRepository = new File(this.env.getApplicationRepositoryPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesRepository);
        File oldJ2eeAppsGeneratedXMLDir = new File(this.env.getApplicationGeneratedXMLPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsGeneratedXMLDir);
        File oldJ2eeModulesGeneratedXMLDir = new File(this.env.getApplicationGeneratedXMLPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesGeneratedXMLDir);
        File oldJ2eeAppsEJBStubDir = new File(this.env.getApplicationEJBStubPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsEJBStubDir);
        File oldJ2eeModulesEJBStubDir = new File(this.env.getApplicationEJBStubPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesEJBStubDir);
        File oldJ2eeAppsJSPCompileDir = new File(this.env.getApplicationCompileJspPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsJSPCompileDir);
        File oldJ2eeModulesJSPCompileDir = new File(this.env.getApplicationCompileJspPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesJSPCompileDir);
        File policyRootDir = new File(this.env.getApplicationStubPath(), "policy");
        File adminapp = new File(policyRootDir, "adminapp");
        FileUtils.whack((File)adminapp);
        File admingui = new File(policyRootDir, "admingui");
        FileUtils.whack((File)admingui);
        File ejbtimer = new File(policyRootDir, "__ejb_container_timer_app");
        FileUtils.whack((File)ejbtimer);
        File mejbapp = new File(policyRootDir, "MEjbApp");
        FileUtils.whack((File)mejbapp);
        File wstx = new File(policyRootDir, "WSTXServices");
        FileUtils.whack((File)wstx);
        File jwsappclient = new File(policyRootDir, "__JWSappclients");
        FileUtils.whack((File)jwsappclient);
    }

    private boolean redeployApp(Application app) {
        if (app.getModule().size() > 0) {
            this.logger.log(Level.INFO, "Skip redeploying v3 type application " + app.getName());
            return true;
        }
        ApplicationRef ref = null;
        for (ApplicationRef appRef : this.server.getApplicationRef()) {
            if (!appRef.getRef().equals(app.getName())) continue;
            ref = appRef;
            break;
        }
        DeployCommandParameters deployParams = app.getDeployParameters(ref);
        if (!Boolean.valueOf(app.getDirectoryDeployed()).booleanValue()) {
            File repackagedFile = null;
            try {
                repackagedFile = this.repackageArchive(app);
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, "Repackaging of application " + app.getName() + " failed: " + ioe.getMessage(), ioe);
                return false;
            }
            if (repackagedFile == null) {
                this.logger.log(Level.SEVERE, "Repackaging of application " + app.getName() + " failed.");
                return false;
            }
            this.logger.log(Level.INFO, "Repackaged application " + app.getName() + " at " + repackagedFile.getPath());
            deployParams.path = repackagedFile;
        }
        deployParams.properties = app.getDeployProperties();
        deployParams.properties.remove(MODULE_TYPE);
        deployParams.properties.setProperty("compatibility", "v2");
        deployParams.force = true;
        deployParams.dropandcreatetables = false;
        deployParams.createtables = false;
        deployParams.enabled = false;
        PlainTextActionReporter report = new PlainTextActionReporter();
        this.commandRunner.getCommandInvocation("deploy", (ActionReport)report).parameters((CommandParameters)deployParams).execute();
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
            this.logger.log(Level.SEVERE, "Redeployment of application " + app.getName() + " failed: " + report.getMessage() + "\nPlease redeploy " + app.getName() + " manually.", report.getFailureCause());
            return false;
        }
        return true;
    }

    private File repackageArchive(Application app) throws IOException {
        URI uri = null;
        try {
            uri = new URI(app.getLocation());
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (uri == null) {
            return null;
        }
        Properties appProperties = app.getDeployProperties();
        String moduleType = appProperties.getProperty(MODULE_TYPE);
        String suffix = this.getSuffixFromType(moduleType);
        if (suffix == null) {
            suffix = ".jar";
        }
        File repositoryDir = new File(uri);
        File tmp = File.createTempFile("upgrade", null);
        String targetParentDir = tmp.getParent();
        tmp.delete();
        if (moduleType.equals("j2ee-application")) {
            return this.repackageApplication(repositoryDir, targetParentDir, suffix);
        }
        return this.repackageStandaloneModule(repositoryDir, targetParentDir, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File repackageApplication(File appDir, String targetParentDir, String suffix) throws IOException {
        OutputStream os;
        String appName = appDir.getName();
        ReadableArchive source = this.archiveFactory.openArchive(appDir);
        File tempEar = new File(targetParentDir, appName + suffix);
        if (tempEar.exists()) {
            tempEar.delete();
        }
        WritableArchive target = this.archiveFactory.createArchive(tempEar);
        Collection directoryEntries = source.getDirectories();
        ArrayList<String> subModuleEntries = new ArrayList<String>();
        ArrayList<String> entriesToExclude = new ArrayList<String>();
        for (String directoryEntry : directoryEntries) {
            if (!directoryEntry.endsWith("_jar") && !directoryEntry.endsWith("_war") && !directoryEntry.endsWith("_rar")) continue;
            subModuleEntries.add(directoryEntry);
            File moduleJar = this.processModule(new File(appDir, directoryEntry), targetParentDir, null);
            os = null;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(moduleJar));
            try {
                os = target.putNextEntry(moduleJar.getName());
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)moduleJar.length());
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        for (String subModuleEntry : subModuleEntries) {
            Enumeration ee = source.entries(subModuleEntry);
            while (ee.hasMoreElements()) {
                String eeEntryName = (String)ee.nextElement();
                entriesToExclude.add(eeEntryName);
            }
        }
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (entriesToExclude.contains(entryName)) continue;
            BufferedInputStream is = new BufferedInputStream(source.getEntry(entryName));
            os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        source.close();
        target.close();
        return tempEar;
    }

    private File repackageStandaloneModule(File moduleDirName, String targetParentDir, String suffix) throws IOException {
        return this.processModule(moduleDirName, targetParentDir, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File processModule(File moduleDir, String targetParentDir, String suffix) throws IOException {
        String moduleName = moduleDir.getName();
        if (moduleName.endsWith("_jar") || moduleName.endsWith("_war") || moduleName.endsWith("_rar")) {
            suffix = "." + moduleName.substring(moduleName.length() - 3);
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(95));
        }
        ReadableArchive source = this.archiveFactory.openArchive(moduleDir);
        File tempJar = new File(targetParentDir, moduleName + suffix);
        if (tempJar.exists()) {
            tempJar.delete();
        }
        WritableArchive target = this.archiveFactory.createArchive(tempJar);
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            BufferedInputStream is = new BufferedInputStream(source.getEntry(entryName));
            OutputStream os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        Manifest m = source.getManifest();
        if (m != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
        source.close();
        target.close();
        return tempJar;
    }

    private String getSuffixFromType(String moduleType) {
        if (moduleType == null) {
            return null;
        }
        if (moduleType.equals("connector-module")) {
            return ".rar";
        }
        if (moduleType.equals("ejb-module")) {
            return ".jar";
        }
        if (moduleType.equals("web-module")) {
            return ".war";
        }
        if (moduleType.equals("appclient-module")) {
            return ".jar";
        }
        if (moduleType.equals("j2ee-application")) {
            return ".ear";
        }
        return null;
    }
}

