/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JvmOptionBag;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.ListJvmOptions;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.UnknownOptionsAreOperands;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="delete-jvm-options")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jvm.options")
@UnknownOptionsAreOperands
public final class DeleteJvmOptions
implements AdminCommand {
    @Param(name="target", optional=true)
    String target;
    @Param(name="profiler", optional=true)
    Boolean fromProfiler = false;
    @Inject
    JavaConfig jc;
    @Param(name="jvm_option_name", primary=true, separator=58)
    List<String> jvmOptions;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    private static final Logger logger = Logger.getLogger(DeleteJvmOptions.class.getPackage().getName());

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JavaConfig bag;
            if (this.fromProfiler.booleanValue()) {
                if (this.jc.getProfiler() == null) {
                    report.setMessage(lsm.getString("create.profiler.first"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                bag = this.jc.getProfiler();
            } else {
                bag = this.jc;
            }
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            this.deleteX((JvmOptionBag)bag, this.jvmOptions, part);
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : lsm.getStringWithDefault("delete.jvm.options.failed", "Command: delete-jvm-options failed", (Object[])new String[]{e.getMessage()});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void deleteX(JvmOptionBag bag, final List<String> toRemove, final ActionReport.MessagePart part) throws Exception {
        SingleConfigCode<JvmOptionBag> scc = new SingleConfigCode<JvmOptionBag>(){

            public Object run(JvmOptionBag bag) throws PropertyVetoException, TransactionFailure {
                ArrayList jvmopts = new ArrayList(bag.getJvmOptions());
                int orig = jvmopts.size();
                boolean removed = jvmopts.removeAll(toRemove);
                bag.setJvmOptions(jvmopts);
                int now = jvmopts.size();
                if (removed) {
                    part.setMessage(lsm.getString("deleted.message", (Object)(orig - now)));
                } else {
                    part.setMessage(lsm.getString("no.option.deleted"));
                }
                return true;
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)bag);
    }
}

