/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.v3.common.XMLContentActionReporter;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.common.util.admin.UnacceptableValueException;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CommandRunnerImpl
implements CommandRunner {
    private final Logger logger = LogDomains.getLogger(CommandRunnerImpl.class, (String)"javax.enterprise.system.tools.admin");
    private final InjectionManager injectionMgr = new InjectionManager();
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext sc;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ProcessEnvironment processEnv;
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunnerImpl.class);

    public ActionReport getActionReport(String name) {
        return (ActionReport)this.habitat.getComponent(ActionReport.class, name);
    }

    public CommandModel getModel(String commandName, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot instantiate " + commandName, e);
            return null;
        }
        return CommandRunnerImpl.getModel(command);
    }

    public AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            e.printStackTrace();
            report.setFailureCause((Throwable)e);
        }
        if (command == null) {
            String msg = !CommandRunnerImpl.ok(commandName) ? adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.") : (this.habitat.getInhabitant(AdminCommand.class, commandName) == null ? adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName}) : adminStrings.getLocalString("adapter.command.notcreated", "Implementation for the command {0} exists in the system, but it has some errors, check server.log for details", new Object[]{commandName}));
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
        }
        return command;
    }

    public CommandRunner.CommandInvocation getCommandInvocation(String name, ActionReport report) {
        return new ExecutionContext(name, report);
    }

    private ActionReport doCommand(CommandModel model, final AdminCommand command, InjectionResolver<Param> injector, final AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(model.getCommandName() + " AdminCommand");
        try {
            GenericCrudCommand c = (GenericCrudCommand)GenericCrudCommand.class.cast(command);
            c.setInjectionResolver(injector);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = model.getI18n();
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        try {
            this.injectionMgr.inject((Object)command, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDependencyException e) {
            String errorMsg;
            Param param = (Param)e.getAnnotation(Param.class);
            CommandModel.ParamModel paramModel = null;
            for (CommandModel.ParamModel pModel : model.getParameters()) {
                if (!pModel.getParam().equals(param)) continue;
                paramModel = pModel;
                break;
            }
            String usage = CommandRunnerImpl.getUsageText(command, model);
            if (paramModel != null) {
                String paramName = paramModel.getName();
                String paramDesc = CommandRunnerImpl.getParamDescription(localStrings, i18n_key, paramModel);
                errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", new Object[]{model.getCommandName(), paramName}) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter ({2})", new Object[]{model.getCommandName(), paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{model.getCommandName(), paramName})));
            } else {
                errorMsg = adminStrings.getLocalString("admin.param.missing.nofound", "Cannot find {1} in {0} command model, file a bug", new Object[]{model.getCommandName(), e.getUnsatisfiedName()});
            }
            this.logger.severe(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return report;
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof UnacceptableValueException || cause instanceof IllegalArgumentException)) {
                exception = (Exception)cause;
            }
            this.logger.log(Level.SEVERE, "invocation.exception", exception);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(CommandRunnerImpl.getUsageText(command, model));
            return report;
        }
        final AdminCommand wrappedComamnd = new AdminCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AdminCommandContext context) {
                ClassLoader ccl;
                Thread thread = Thread.currentThread();
                ClassLoader origCL = thread.getContextClassLoader();
                if (origCL != (ccl = CommandRunnerImpl.this.sc.getCommonClassLoader())) {
                    try {
                        thread.setContextClassLoader(ccl);
                        command.execute(context);
                    }
                    finally {
                        thread.setContextClassLoader(origCL);
                    }
                } else {
                    command.execute(context);
                }
            }
        };
        Async async = command.getClass().getAnnotation(Async.class);
        if (async == null) {
            try {
                wrappedComamnd.execute(context);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, adminStrings.getLocalString("adapter.exception", "Exception in command execution : ", new Object[]{e}), e);
                report.setMessage(e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
            }
        } else {
            Thread t = new Thread(){

                public void run() {
                    try {
                        wrappedComamnd.execute(context);
                    }
                    catch (RuntimeException e) {
                        CommandRunnerImpl.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            t.setPriority(async.priority());
            t.start();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(adminStrings.getLocalString("adapter.command.launch", "Command {0} was successfully initiated asynchronously.", new Object[]{model.getCommandName()}));
        }
        return context.getActionReport();
    }

    private static String getParamDescription(LocalStringManagerImpl localStrings, String i18nKey, CommandModel.ParamModel model) {
        I18n i18n = model.getI18n();
        String paramDesc = i18n == null ? localStrings.getLocalString(i18nKey + "." + model.getName(), "") : localStrings.getLocalString(i18n.value(), "");
        if (paramDesc == null) {
            paramDesc = "";
        }
        return paramDesc;
    }

    static String getUsageText(AdminCommand command, CommandModel model) {
        String usage;
        StringBuffer usageText = new StringBuffer();
        I18n i18n = model.getI18n();
        String i18nKey = null;
        LocalStringManagerImpl lsm = new LocalStringManagerImpl(command.getClass());
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (i18nKey != null && CommandRunnerImpl.ok(usage = lsm.getLocalString(i18nKey + ".usagetext", ""))) {
            usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
            usageText.append(usage);
            return usageText.toString();
        }
        return CommandRunnerImpl.generateUsageText(model);
    }

    private static String generateUsageText(CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
        usageText.append(model.getCommandName());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (CommandModel.ParamModel pModel : model.getParameters()) {
            Param param = pModel.getParam();
            String paramName = pModel.getName().toLowerCase(Locale.ENGLISH);
            if (param.password() || param.obsolete()) continue;
            boolean optional = param.optional();
            Class ftype = pModel.getType();
            String fvalue = null;
            String fvalueString = null;
            try {
                fvalue = param.defaultValue();
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
            } else if (ftype.isAssignableFrom(String.class)) {
                if (CommandRunnerImpl.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                } else {
                    usageText.append("=").append(paramName);
                }
            } else if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
            } else {
                usageText.append("=").append(paramName);
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    public void getHelp(AdminCommand command, ActionReport report) {
        CommandModel model = CommandRunnerImpl.getModel(command);
        report.setActionDescription(model.getCommandName() + " help");
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18nKey = "";
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (report instanceof XMLContentActionReporter) {
            this.getMetadata(command, model, report);
        } else {
            report.setMessage(model.getCommandName() + " - " + localStrings.getLocalString(i18nKey, ""));
            report.getTopMessagePart().addProperty("SYNOPSIS", CommandRunnerImpl.getUsageText(command, model));
            for (CommandModel.ParamModel param : model.getParameters()) {
                this.addParamUsage(report, localStrings, i18nKey, param);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void getMetadata(AdminCommand command, CommandModel model, ActionReport report) {
        String usage;
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = model.getI18n();
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        ActionReport.MessagePart top = report.getTopMessagePart();
        ActionReport.MessagePart cmd = top.addChild();
        cmd.setChildrenType("command");
        cmd.addProperty("name", model.getCommandName());
        if (model.unknownOptionsAreOperands()) {
            cmd.addProperty("unknown-options-are-operands", "true");
        }
        if (CommandRunnerImpl.ok(usage = localStrings.getLocalString(i18n_key + ".usagetext", ""))) {
            cmd.addProperty("usage", usage);
        }
        CommandModel.ParamModel primary = null;
        for (CommandModel.ParamModel p : model.getParameters()) {
            String paramDesc;
            Param param = p.getParam();
            if (param.primary()) {
                primary = p;
                continue;
            }
            ActionReport.MessagePart ppart = cmd.addChild();
            ppart.setChildrenType("option");
            ppart.addProperty("name", p.getName());
            ppart.addProperty("type", CommandRunnerImpl.typeOf(p));
            ppart.addProperty("optional", Boolean.toString(param.optional()));
            if (param.obsolete()) {
                ppart.addProperty("obsolete", "true");
            }
            if (CommandRunnerImpl.ok(paramDesc = CommandRunnerImpl.getParamDescription(localStrings, i18n_key, p))) {
                ppart.addProperty("description", paramDesc);
            }
            if (CommandRunnerImpl.ok(param.shortName())) {
                ppart.addProperty("short", param.shortName());
            }
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                ppart.addProperty("default", param.defaultValue());
            }
            if (CommandRunnerImpl.ok(param.acceptableValues())) {
                ppart.addProperty("acceptable-values", param.acceptableValues());
            }
            if (!CommandRunnerImpl.ok(param.alias())) continue;
            ppart.addProperty("alias", param.alias());
        }
        if (primary != null) {
            ActionReport.MessagePart primpart = cmd.addChild();
            primpart.setChildrenType("operand");
            primpart.addProperty("name", primary.getName());
            primpart.addProperty("type", CommandRunnerImpl.typeOf(primary));
            primpart.addProperty("min", primary.getParam().optional() ? "0" : "1");
            primpart.addProperty("max", primary.getParam().multiple() ? "unlimited" : "1");
            String desc = CommandRunnerImpl.getParamDescription(localStrings, i18n_key, primary);
            if (CommandRunnerImpl.ok(desc)) {
                primpart.addProperty("description", desc);
            }
        }
    }

    private static String typeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class || t == Boolean.TYPE) {
            return "BOOLEAN";
        }
        if (t == File.class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }

    public InputStream getManPage(String commandName, AdminCommand command) {
        Class<?> clazz = command.getClass();
        Package pkg = clazz.getPackage();
        String manPage = pkg.getName().replace('.', '/');
        manPage = manPage + "/" + commandName + ".1";
        ClassLoader loader = clazz.getClassLoader();
        InputStream in = loader.getResourceAsStream(manPage);
        return in;
    }

    private void addParamUsage(ActionReport report, LocalStringManagerImpl localStrings, String i18nKey, CommandModel.ParamModel model) {
        Param param = model.getParam();
        if (param != null) {
            String paramName = model.getName().toLowerCase(Locale.ENGLISH);
            if (param.password()) {
                return;
            }
            if (param.obsolete()) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", CommandRunnerImpl.getParamDescription(localStrings, i18nKey, model));
            } else {
                report.getTopMessagePart().addProperty(paramName, CommandRunnerImpl.getParamDescription(localStrings, i18nKey, model));
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static void validateParameters(CommandModel model, ParameterMap parameters) throws ComponentException {
        for (Map.Entry entry : parameters.entrySet()) {
            CommandModel.ParamModel pModel;
            String key = (String)entry.getKey();
            if (key.equals("DEFAULT") || key.startsWith(ASADMIN_CMD_PREFIX) || key.equals("help") || key.equals("Xhelp")) continue;
            boolean validOption = false;
            Iterator i$ = model.getParameters().iterator();
            while (!(!i$.hasNext() || (validOption = (pModel = (CommandModel.ParamModel)i$.next()).isParamId(key)) || pModel.getParam().password() && (validOption = pModel.isParamId(ASADMIN_CMD_PREFIX + key.toUpperCase(Locale.ENGLISH))))) {
            }
            if (validOption) continue;
            throw new ComponentException(" Invalid option: " + key);
        }
    }

    static boolean skipValidation(AdminCommand command) {
        try {
            Field f = command.getClass().getDeclaredField("skipParamValidation");
            f.setAccessible(true);
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    private static String encodeManPage(InputStream in) {
        try {
            String line;
            if (in == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static CommandModel getModel(AdminCommand command) {
        if (command instanceof CommandModelProvider) {
            return ((CommandModelProvider)command).getModel();
        }
        return new CommandModelImpl(command.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doCommand(ExecutionContext inv, AdminCommand command) {
        block55: {
            block56: {
                block53: {
                    block54: {
                        block47: {
                            block52: {
                                block50: {
                                    block51: {
                                        block48: {
                                            block49: {
                                                block45: {
                                                    block46: {
                                                        block43: {
                                                            block44: {
                                                                if (command == null && (command = this.getCommand(ExecutionContext.access$300(inv), ExecutionContext.access$400(inv), this.logger)) == null) {
                                                                    return;
                                                                }
                                                                try {
                                                                    c = (CommandModelProvider)CommandModelProvider.class.cast(command);
                                                                    model = c.getModel();
                                                                }
                                                                catch (ClassCastException e) {
                                                                    model = new CommandModelImpl(command.getClass());
                                                                }
                                                                ufm = null;
                                                                report = ExecutionContext.access$400(inv);
                                                                context = new AdminCommandContext(LogDomains.getLogger(command.getClass(), (String)"javax.enterprise.system.tools.admin"), report, ExecutionContext.access$500(inv), ExecutionContext.access$600(inv));
                                                                runtimeTypes = new ArrayList<RuntimeType>();
                                                                targetTypesAllowed = new HashSet<CommandTarget>();
                                                                doReplication = false;
                                                                if (Utility.getEnvOrProp((String)"ENABLE_REPLICATION") != null) {
                                                                    doReplication = Boolean.parseBoolean(Utility.getEnvOrProp((String)"ENABLE_REPLICATION"));
                                                                }
                                                                ufm = new UploadedFilesManager(inv.report, this.logger, ExecutionContext.access$500(inv));
                                                                if (ExecutionContext.access$800(inv) == null) break block43;
                                                                injectionTarget = new DelegatedInjectionResolver(model, ExecutionContext.access$800(inv), UploadedFilesManager.access$900(ufm));
                                                                this.doCommand(model, command, injectionTarget, context);
                                                                if (ufm == null) break block44;
                                                                UploadedFilesManager.access$1100(ufm);
                                                            }
                                                            return;
                                                        }
                                                        parameters = ExecutionContext.access$1000(inv);
                                                        if (parameters == null) {
                                                            parameters = new ParameterMap();
                                                        }
                                                        if (!CommandRunnerImpl.isSet(parameters, "help") && !CommandRunnerImpl.isSet(parameters, "Xhelp")) break block45;
                                                        in = this.getManPage(model.getCommandName(), command);
                                                        manPage = CommandRunnerImpl.encodeManPage(in);
                                                        if (manPage != null && CommandRunnerImpl.isSet(parameters, "help")) {
                                                            ExecutionContext.access$400(inv).getTopMessagePart().addProperty("MANPAGE", manPage);
                                                        } else {
                                                            report.getTopMessagePart().addProperty("GeneratedHelp", "true");
                                                            this.getHelp(command, report);
                                                        }
                                                        if (ufm == null) break block46;
                                                        UploadedFilesManager.access$1100(ufm);
                                                    }
                                                    return;
                                                }
                                                try {
                                                    if (!CommandRunnerImpl.skipValidation(command)) {
                                                        CommandRunnerImpl.validateParameters(model, parameters);
                                                    }
                                                }
                                                catch (ComponentException e) {
                                                    exception = e;
                                                    cause = e.getCause();
                                                    if (cause != null && cause instanceof UnacceptableValueException) {
                                                        exception = (Exception)cause;
                                                    }
                                                    this.logger.severe(exception.getMessage());
                                                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                    report.setMessage(exception.getMessage());
                                                    report.setFailureCause(exception);
                                                    childPart = report.getTopMessagePart().addChild();
                                                    childPart.setMessage(CommandRunnerImpl.getUsageText(command, model));
                                                    if (ufm != null) {
                                                        UploadedFilesManager.access$1100(ufm);
                                                    }
                                                    return;
                                                }
                                                injectionMgr = new MapInjectionResolver(model, parameters, UploadedFilesManager.access$900(ufm));
                                                if (!doReplication) ** GOTO lbl169
                                                clAnnotation = model.getClusteringAttributes();
                                                if (clAnnotation == null) {
                                                    runtimeTypes.add(RuntimeType.DAS);
                                                    runtimeTypes.add(RuntimeType.INSTANCE);
                                                } else if (clAnnotation.value().length == 0) {
                                                    runtimeTypes.add(RuntimeType.DAS);
                                                    runtimeTypes.add(RuntimeType.INSTANCE);
                                                } else {
                                                    for (RuntimeType t : clAnnotation.value()) {
                                                        runtimeTypes.add(t);
                                                    }
                                                }
                                                if (!this.serverEnv.isDas()) break block47;
                                                targetName = (String)parameters.getOne((Object)"target");
                                                if (targetName == null) {
                                                    targetName = "server";
                                                }
                                                if ((tgtTypeAnnotation = command.getClass().getAnnotation(TargetType.class)) != null) {
                                                    for (CommandTarget c : tgtTypeAnnotation.value()) {
                                                        targetTypesAllowed.add(c);
                                                    }
                                                }
                                                if (targetTypesAllowed.size() == 0) {
                                                    targetTypesAllowed.add(CommandTarget.DAS);
                                                    targetTypesAllowed.add(CommandTarget.STANDALONE_INSTANCE);
                                                    targetTypesAllowed.add(CommandTarget.CLUSTER);
                                                    targetTypesAllowed.add(CommandTarget.CONFIG);
                                                }
                                                if (CommandTarget.DAS.isValid(this.habitat, targetName) && !runtimeTypes.contains(RuntimeType.DAS)) {
                                                    runtimeTypes.add(RuntimeType.DAS);
                                                }
                                                if (CommandTarget.DOMAIN.isValid(this.habitat, targetName) || this.domain.getServerNamed(targetName) != null || this.domain.getClusterNamed(targetName) != null || this.domain.getConfigNamed(targetName) != null) break block48;
                                                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                report.setMessage(CommandRunnerImpl.adminStrings.getLocalString("commandrunner.executor.invalidtarget", "Unable to find a valid target with name {0}", new Object[]{targetName}));
                                                if (ufm == null) break block49;
                                                UploadedFilesManager.access$1100(ufm);
                                            }
                                            return;
                                        }
                                        isTargetValidType = false;
                                        it = targetTypesAllowed.iterator();
                                        while (it.hasNext()) {
                                            if (!((CommandTarget)it.next()).isValid(this.habitat, targetName)) continue;
                                            isTargetValidType = true;
                                            break;
                                        }
                                        if (isTargetValidType) break block50;
                                        validTypes = new StringBuilder();
                                        it = targetTypesAllowed.iterator();
                                        while (it.hasNext()) {
                                            validTypes.append(((CommandTarget)it.next()).getDescription() + " ");
                                        }
                                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                        report.setMessage(CommandRunnerImpl.adminStrings.getLocalString("commandrunner.executor.invalidtargettype", "Target {0} is not a supported type. Command {1} supports these types of targets only : {2}", new Object[]{targetName, model.getCommandName(), validTypes.toString()}));
                                        if (ufm == null) break block51;
                                        UploadedFilesManager.access$1100(ufm);
                                    }
                                    return;
                                }
                                if (!CommandTarget.CLUSTERED_INSTANCE.isValid(this.habitat, targetName) || targetTypesAllowed.contains(CommandTarget.CLUSTERED_INSTANCE)) break block47;
                                c = this.domain.getClusterForInstance(targetName);
                                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                report.setMessage(CommandRunnerImpl.adminStrings.getLocalString("commandrunner.executor.instanceopnotallowed", "The {0} command is not allowed on instance {1} because it is part of cluster {2}", new Object[]{model.getCommandName(), targetName, c.getName()}));
                                if (ufm == null) break block52;
                                UploadedFilesManager.access$1100(ufm);
                            }
                            return;
                        }
                        supplementalExecutor = (SupplementalCommandExecutor)this.habitat.getComponent(SupplementalCommandExecutor.class, "SupplementalCommandExecutorImpl");
                        supplementalReturn = supplementalExecutor.execute(model.getCommandName(), Supplemental.Timing.Before, context, (InjectionResolver)injectionMgr);
                        if (!supplementalReturn.equals((Object)ActionReport.ExitCode.FAILURE)) break block53;
                        report.setActionExitCode(supplementalReturn);
                        report.setMessage(CommandRunnerImpl.adminStrings.getLocalString("commandrunner.executor.supplementalcmdfailed", "A supplemental command failed; cannot proceed further"));
                        if (ufm == null) break block54;
                        UploadedFilesManager.access$1100(ufm);
                    }
                    return;
                }
                if (this.serverEnv.isDas() && runtimeTypes.contains(RuntimeType.DAS) || this.serverEnv.isInstance() && runtimeTypes.contains(RuntimeType.INSTANCE)) {
                    this.doCommand(model, command, (InjectionResolver<Param>)injectionMgr, context);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE) || !(supplementalReturn = supplementalExecutor.execute(model.getCommandName(), Supplemental.Timing.After, context, (InjectionResolver)injectionMgr)).equals((Object)ActionReport.ExitCode.FAILURE)) break block55;
                report.setActionExitCode(supplementalReturn);
                report.setMessage(CommandRunnerImpl.adminStrings.getLocalString("commandrunner.executor.supplementalcmdfailed", "A supplemental command failed; cannot proceed further"));
                if (ufm == null) break block56;
                UploadedFilesManager.access$1100(ufm);
            }
            return;
        }
        try {
            block58: {
                break block58;
lbl169:
                // 1 sources

                this.doCommand(model, command, (InjectionResolver<Param>)injectionMgr, context);
            }
            ** if (ufm == null) goto lbl-1000
        }
        catch (Exception ex) {
            block57: {
                try {
                    this.logger.severe(ex.getMessage());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(ex.getMessage());
                    report.setFailureCause((Throwable)ex);
                    childPart = report.getTopMessagePart().addChild();
                    childPart.setMessage(CommandRunnerImpl.getUsageText(command, model));
                    if (ufm == null) break block57;
                }
                catch (Throwable var19_35) {
                    if (ufm != null) {
                        UploadedFilesManager.access$1100(ufm);
                    }
                    throw var19_35;
                }
                UploadedFilesManager.access$1100(ufm);
            }
            return;
        }
lbl-1000:
        // 1 sources

        {
            UploadedFilesManager.access$1100(ufm);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (this.processEnv.getProcessType().isEmbedded()) {
            return;
        }
        if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE) && this.serverEnv.isDas() && doReplication) {
            executor = null;
            executor = model.getClusteringAttributes() != null && model.getClusteringAttributes().executor() != null ? (ClusterExecutor)this.habitat.getComponent(model.getClusteringAttributes().executor()) : (ClusterExecutor)this.habitat.getComponent(ClusterExecutor.class, "GlassFishClusterExecutor");
            if (executor == null) {
                err = CommandRunnerImpl.adminStrings.getLocalString("commandrunner.clusterexecutor.notinitialized", "Unable to get an instance of ClusterExecutor; Cannot dynamically reconfigure instances");
                this.logger.severe(err);
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
                report.setMessage(err);
                return;
            }
            report.setActionExitCode(executor.execute(model.getCommandName(), command, context, parameters));
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                report.setMessage(CommandRunnerImpl.adminStrings.getLocalString("commandrunner.executor.errorwhilereplication", "An error occurred during replication"));
            }
        }
    }

    private static boolean isSet(ParameterMap params, String name) {
        String val = (String)params.getOne((Object)name);
        if (val == null) {
            return false;
        }
        return val.length() == 0 || Boolean.valueOf(val) != false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UploadedFilesManager {
        private final ActionReport report;
        private final Logger logger;
        private Map<String, File> optionNameToFileMap;
        private PayloadFilesManager.Temp payloadFilesMgr = null;

        private UploadedFilesManager(ActionReport report, Logger logger, Payload.Inbound inboundPayload) throws IOException, Exception {
            this.logger = logger;
            this.report = report;
            this.extractFiles(inboundPayload);
        }

        private Map<String, File> optionNameToFileMap() {
            return this.optionNameToFileMap;
        }

        private void close() {
            if (this.payloadFilesMgr != null) {
                this.payloadFilesMgr.cleanup();
            }
        }

        private Map<String, File> extractFiles(Payload.Inbound inboundPayload) throws IOException, Exception {
            if (inboundPayload == null) {
                return Collections.EMPTY_MAP;
            }
            File uniqueSubdirUnderApplications = this.chooseTempDirParent();
            this.payloadFilesMgr = new PayloadFilesManager.Temp(uniqueSubdirUnderApplications, this.report, this.logger);
            Map payloadFiles = this.payloadFilesMgr.processPartsExtended(inboundPayload);
            this.optionNameToFileMap = new HashMap<String, File>();
            for (Map.Entry e : payloadFiles.entrySet()) {
                String optionName = ((Properties)e.getValue()).getProperty("data-request-name");
                if (optionName == null) continue;
                this.optionNameToFileMap.put(optionName, (File)e.getKey());
            }
            return this.optionNameToFileMap;
        }

        private File chooseTempDirParent() throws IOException {
            File appRoot = new File(CommandRunnerImpl.this.domain.getApplicationRoot());
            if (!appRoot.isDirectory()) {
                appRoot.mkdirs();
            }
            return appRoot;
        }

        static /* synthetic */ Map access$900(UploadedFilesManager x0) {
            return x0.optionNameToFileMap();
        }

        static /* synthetic */ void access$1100(UploadedFilesManager x0) {
            x0.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatedInjectionResolver
    extends InjectionResolver<Param> {
        private final CommandModel model;
        private final CommandParameters parameters;
        private final Map<String, File> optionNameToUploadedFileMap;

        public DelegatedInjectionResolver(CommandModel model, CommandParameters parameters, Map<String, File> optionNameToUploadedFileMap) {
            super(Param.class);
            this.model = model;
            this.parameters = parameters;
            this.optionNameToUploadedFileMap = optionNameToUploadedFileMap;
        }

        public boolean isOptional(AnnotatedElement element, Param annotation) {
            String name = CommandModel.getParamName((Param)annotation, (AnnotatedElement)element);
            CommandModel.ParamModel param = this.model.getModelFor(name);
            return param.getParam().optional();
        }

        public <V> V getValue(Object component, AnnotatedElement target, Class<V> type) throws ComponentException {
            if (target instanceof Field) {
                Field targetField = (Field)target;
                try {
                    Field sourceField = this.parameters.getClass().getField(targetField.getName());
                    targetField.setAccessible(true);
                    Object paramValue = sourceField.get(this.parameters);
                    String paramFileValue = MapInjectionResolver.getUploadedFileParamValue((String)targetField.getName(), targetField.getType(), this.optionNameToUploadedFileMap);
                    if (paramFileValue != null) {
                        paramValue = new File(paramFileValue);
                    }
                    if (paramValue != null) {
                        DelegatedInjectionResolver.checkAgainstAcceptableValues(target, paramValue.toString());
                    }
                    return type.cast(paramValue);
                }
                catch (IllegalAccessException e) {
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            return null;
        }

        private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
            Param param = target.getAnnotation(Param.class);
            String acceptable = param.acceptableValues();
            String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
            if (CommandRunnerImpl.ok(acceptable) && CommandRunnerImpl.ok(paramValueStr)) {
                String[] ss;
                for (String s : ss = acceptable.split(",")) {
                    if (!paramValueStr.equals(s.trim())) continue;
                    return;
                }
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
            }
        }
    }

    private class ExecutionContext
    implements CommandRunner.CommandInvocation {
        protected final String name;
        protected final ActionReport report;
        protected ParameterMap params;
        protected CommandParameters paramObject;
        protected Payload.Inbound inbound;
        protected Payload.Outbound outbound;

        private ExecutionContext(String name, ActionReport report) {
            this.name = name;
            this.report = report;
        }

        public CommandRunner.CommandInvocation parameters(CommandParameters paramObject) {
            this.paramObject = paramObject;
            return this;
        }

        public CommandRunner.CommandInvocation parameters(ParameterMap params) {
            this.params = params;
            return this;
        }

        public CommandRunner.CommandInvocation inbound(Payload.Inbound inbound) {
            this.inbound = inbound;
            return this;
        }

        public CommandRunner.CommandInvocation outbound(Payload.Outbound outbound) {
            this.outbound = outbound;
            return this;
        }

        public void execute() {
            this.execute(null);
        }

        private ParameterMap parameters() {
            return this.params;
        }

        private CommandParameters typedParams() {
            return this.paramObject;
        }

        private String name() {
            return this.name;
        }

        private ActionReport report() {
            return this.report;
        }

        private Payload.Inbound inboundPayload() {
            return this.inbound;
        }

        private Payload.Outbound outboundPayload() {
            return this.outbound;
        }

        public void execute(AdminCommand command) {
            CommandRunnerImpl.this.doCommand(this, command);
        }

        static /* synthetic */ String access$300(ExecutionContext x0) {
            return x0.name();
        }

        static /* synthetic */ ActionReport access$400(ExecutionContext x0) {
            return x0.report();
        }

        static /* synthetic */ Payload.Inbound access$500(ExecutionContext x0) {
            return x0.inboundPayload();
        }

        static /* synthetic */ Payload.Outbound access$600(ExecutionContext x0) {
            return x0.outboundPayload();
        }

        static /* synthetic */ CommandParameters access$800(ExecutionContext x0) {
            return x0.typedParams();
        }

        static /* synthetic */ ParameterMap access$1000(ExecutionContext x0) {
            return x0.parameters();
        }
    }
}

